/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data.impl;

import com.businessobjects.visualization.common.exceptions.SerializationException;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.internal.Base64Coder;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.common.DataStructure;
import com.businessobjects.visualization.dataexchange.common.DataType;
import com.businessobjects.visualization.dataexchange.data.Data;
import com.businessobjects.visualization.dataexchange.data.InvalidDataTypeException;
import com.businessobjects.visualization.dataexchange.data.generated.XMLData;
import com.businessobjects.visualization.dataexchange.data.impl.Helper;
import com.businessobjects.visualization.dataexchange.data.impl.TreeNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;

public class TreeNodeArray
implements Data {
    private TreeNode[] treeNodes_;
    private DataType defaultDataType_;
    static final String SER_KEY = "id";
    static final String PARENT_KEY = "pId";
    static final String VALUE_KEY = "v";
    static final String INDEX_KEY = "i";
    static final String PROP_PREFIX_KEY = "p_";
    static final int PROP_STARTING_INDEX = 4;
    static final String NODE_COUNT_KEY = "nodecount";
    static final String ARRAY_COUNT_KEY = "arraycount";

    public TreeNodeArray(DataType defaultDataType, TreeNode[] treeNodeList) {
        this.treeNodes_ = treeNodeList;
        this.defaultDataType_ = defaultDataType;
    }

    public TreeNodeArray(DataType defaultDataType, Collection treeNodeCollection) {
        this(defaultDataType, treeNodeCollection.toArray(new TreeNode[0]));
    }

    public TreeNodeArray(XMLData values, SerializationHelper sh) {
        try {
            if (values.m_encodedvalues.charAt(0) != '[') {
                this.treeNodes_ = (TreeNode[])SerializationHelper.bytesToObject(Base64Coder.decode(values.m_encodedvalues));
            } else {
                JSONDeserializer jd = new JSONDeserializer(values.m_encodedvalues);
                this.treeNodes_ = jd.getResult();
            }
            this.defaultDataType_ = Helper.fromXML(values.m_dataType);
        }
        catch (JSONException e) {
            throw new SerializationException("VIZ_00002_ERR_DESERIALIZATION_ERROR", e);
        }
        catch (IOException e) {
            throw new SerializationException("VIZ_00002_ERR_DESERIALIZATION_ERROR", e);
        }
    }

    public Object getValues() {
        return this.treeNodes_;
    }

    public void setValues(Object values, DataType aType, int iCardinality) throws InvalidDataTypeException {
        this.treeNodes_ = (TreeNode[])values;
        this.defaultDataType_ = aType;
    }

    public int getValuesCount(int iCardinality) {
        return this.treeNodes_.length;
    }

    public DataType getType() {
        return this.defaultDataType_;
    }

    public DataStructure getStructure() {
        return DataStructure.TREE;
    }

    public int getCardinality() {
        return 1;
    }

    public Object getXMLDelegate() {
        XMLData data = new XMLData();
        data.m_dataType = Helper.toXML(this.getType());
        data.m_a_cardinality = this.getCardinality();
        data.m_dataStructure = Helper.toXML(DataStructure.TREE);
        try {
            data.m_encodedvalues = this.toJSONString();
        }
        catch (JSONException e) {
            throw new VisualizationInternalException(e);
        }
        return data;
    }

    public boolean supportProperties() {
        return true;
    }

    public void setProperties(Object properties) {
        throw new InvalidDataTypeException("VIZ_00027_ERR_PROPERTIES_ARE_BOUND");
    }

    public Object getProperties() {
        Properties[] props = new Properties[this.treeNodes_.length];
        for (int i = 0; i < this.treeNodes_.length; ++i) {
            props[i] = this.treeNodes_[i].getProperties();
        }
        return props;
    }

    public String toJSONString() throws JSONException {
        JSONSerializer js = new JSONSerializer(this.treeNodes_);
        return js.toJSONString();
    }

    static class JSONDeserializer {
        int lastId_;
        TreeNode[] nodesList_;
        int[] parentIdList_;
        TreeNode[] indexList_;
        String serializedJSONString_;

        JSONDeserializer(String ser) throws JSONException {
            JSONTokener jt = new JSONTokener(ser);
            JSONArray array = (JSONArray)jt.nextValue();
            JSONObject header = array.getJSONObject(0);
            int nodeCount = header.getInt(TreeNodeArray.NODE_COUNT_KEY);
            int arrayCount = header.getInt(TreeNodeArray.ARRAY_COUNT_KEY);
            this.nodesList_ = new TreeNode[nodeCount];
            this.parentIdList_ = new int[nodeCount];
            this.indexList_ = new TreeNode[arrayCount];
            int k = 1;
            while (k < array.length()) {
                JSONObject jo = array.getJSONObject(k++);
                String[] keyNames = JSONObject.getNames(jo);
                System.out.println(jo.toString());
                System.out.println(keyNames.length);
                int id = jo.getInt(TreeNodeArray.SER_KEY);
                int parentId = jo.getInt(TreeNodeArray.PARENT_KEY);
                int index = jo.getInt(TreeNodeArray.INDEX_KEY);
                Object value = jo.get(TreeNodeArray.VALUE_KEY);
                TreeNode node = null;
                node = value == JSONObject.NULL ? TreeNode.newMissingNodeInstance() : new TreeNode((String)value);
                this.nodesList_[id] = node;
                this.parentIdList_[id] = parentId;
                if (index != -1) {
                    this.indexList_[index] = node;
                }
                if (keyNames.length <= 4) continue;
                Properties props = new Properties();
                for (int i = 0; i < keyNames.length; ++i) {
                    int prefixSize = TreeNodeArray.PROP_PREFIX_KEY.length();
                    if (keyNames[i].length() <= prefixSize || !keyNames[i].substring(0, prefixSize).equals(TreeNodeArray.PROP_PREFIX_KEY)) continue;
                    props.put(keyNames[i].substring(prefixSize), jo.getString(keyNames[i]));
                }
                node.setProperties(props);
            }
            for (int i = 0; i < this.nodesList_.length; ++i) {
                int parentId = this.parentIdList_[i];
                if (parentId == -1) continue;
                this.nodesList_[parentId].addChild(this.nodesList_[i]);
            }
        }

        TreeNode[] getResult() {
            return this.indexList_;
        }
    }

    static class JSONSerializer {
        int lastId_;
        HashMap nodesMap_ = new HashMap();
        ArrayList rootNodes_ = new ArrayList();
        TreeNode[] indexedList_;
        HashSet indexedHash_;

        JSONSerializer(TreeNode[] indexedList) {
            int i;
            this.indexedHash_ = new HashSet(indexedList.length);
            this.indexedList_ = indexedList;
            for (i = 0; i < indexedList.length; ++i) {
                this.indexedHash_.add(indexedList[i]);
            }
            for (i = 0; i < this.indexedList_.length; ++i) {
                this.recurseNodes(this.indexedList_[i]);
            }
            Iterator iter = this.rootNodes_.iterator();
            while (iter.hasNext()) {
                this.fetchToLeaves((TreeNode)iter.next());
            }
        }

        int findIndex(TreeNode node) {
            for (int i = 0; i < this.indexedList_.length; ++i) {
                if (node != this.indexedList_[i]) continue;
                return i;
            }
            return -1;
        }

        String toJSONString() throws JSONException {
            JSONStringer js = new JSONStringer();
            js.array();
            js.object().key(TreeNodeArray.NODE_COUNT_KEY).value(this.lastId_).key(TreeNodeArray.ARRAY_COUNT_KEY).value(this.indexedList_.length).endObject();
            for (int i = 0; i < this.indexedList_.length; ++i) {
                TreeNode node = this.indexedList_[i];
                int id = (Integer)this.nodesMap_.get(node);
                int parentId = node.isRoot() ? -1 : (Integer)this.nodesMap_.get(node.getParent());
                js.object();
                js.key(TreeNodeArray.SER_KEY).value(id);
                js.key(TreeNodeArray.PARENT_KEY).value(parentId);
                js.key(TreeNodeArray.VALUE_KEY).value(node.getValue());
                js.key(TreeNodeArray.INDEX_KEY).value(i);
                Properties props = node.getProperties();
                if (props != null) {
                    Enumeration<Object> propEnum = props.keys();
                    while (propEnum.hasMoreElements()) {
                        String key = (String)propEnum.nextElement();
                        js.key(TreeNodeArray.PROP_PREFIX_KEY + key).value(props.getProperty(key));
                    }
                }
                js.endObject();
            }
            Iterator iter = this.nodesMap_.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                TreeNode node = (TreeNode)entry.getKey();
                if (this.indexedHash_.contains(node)) continue;
                int id = (Integer)entry.getValue();
                int parentId = node.isRoot() ? -1 : (Integer)this.nodesMap_.get(node.getParent());
                js.object();
                js.key(TreeNodeArray.SER_KEY).value(id);
                js.key(TreeNodeArray.PARENT_KEY).value(parentId);
                js.key(TreeNodeArray.VALUE_KEY).value(node.getValue());
                js.key(TreeNodeArray.INDEX_KEY).value(-1L);
                Properties props = node.getProperties();
                if (props != null) {
                    Enumeration<Object> propEnum = props.keys();
                    while (propEnum.hasMoreElements()) {
                        String key = (String)propEnum.nextElement();
                        js.key(TreeNodeArray.PROP_PREFIX_KEY + key).value(props.getProperty(key));
                    }
                }
                js.endObject();
            }
            js.endArray();
            return js.toString();
        }

        int markNode(TreeNode node) {
            int returnId = this.lastId_;
            this.nodesMap_.put(node, new Integer(this.lastId_));
            ++this.lastId_;
            return returnId;
        }

        void fetchToLeaves(TreeNode node) {
            TreeNode[] childs = node.getChildren();
            if (childs != null) {
                for (int i = 0; i < childs.length; ++i) {
                    if (!this.nodesMap_.containsKey(childs[i])) {
                        this.markNode(childs[i]);
                    }
                    this.fetchToLeaves(childs[i]);
                }
            }
        }

        int recurseNodes(TreeNode node) {
            if (!this.nodesMap_.containsKey(node)) {
                if (!node.isRoot()) {
                    this.recurseNodes(node.getParent());
                } else {
                    this.rootNodes_.add(node);
                }
                return this.markNode(node);
            }
            return (Integer)this.nodesMap_.get(node);
        }
    }
}

