/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data.impl;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.dataexchange.callbacks.IDimensionLabelsIterator;
import com.businessobjects.visualization.dataexchange.callbacks.IMember;
import com.businessobjects.visualization.dataexchange.data.impl.DimensionLabelsBaseIterator;
import com.businessobjects.visualization.dataexchange.data.impl.TreeMemberImpl;
import com.businessobjects.visualization.dataexchange.data.impl.TreeNode;
import com.businessobjects.visualization.dataexchange.data.impl.TreeNodeArray;

public class DimensionLabelsTreeIterator
extends DimensionLabelsBaseIterator {
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$dataexchange$data$impl$DimensionLabelsTreeIterator == null ? (class$com$businessobjects$visualization$dataexchange$data$impl$DimensionLabelsTreeIterator = DimensionLabelsTreeIterator.class$("com.businessobjects.visualization.dataexchange.data.impl.DimensionLabelsTreeIterator")) : class$com$businessobjects$visualization$dataexchange$data$impl$DimensionLabelsTreeIterator));
    private TreeNode[] treeNodes_;
    private TreeNodeArray data_;
    private int maxLevel_ = -1;
    static /* synthetic */ Class class$com$businessobjects$visualization$dataexchange$data$impl$DimensionLabelsTreeIterator;

    public DimensionLabelsTreeIterator(TreeNodeArray data, int iAxisIndex, int iDimIndex) {
        this(data, -1, -1, iAxisIndex, iDimIndex, -1);
    }

    public DimensionLabelsTreeIterator(TreeNodeArray data, int iAxisIndex, int iDimIndex, int iMaxLevel) {
        this(data, -1, -1, iAxisIndex, iDimIndex, iMaxLevel);
    }

    public DimensionLabelsTreeIterator(TreeNodeArray data, int startIndex, int range, int iAxisIndex, int iDimIndex) {
        this(data, startIndex, range, iAxisIndex, iDimIndex, -1);
    }

    public DimensionLabelsTreeIterator(TreeNodeArray data, int startIndex, int range, int iAxisIndex, int iDimIndex, int iMaxLevel) {
        if (data == null) {
            throw new VisualizationRuntimeException("VIZ_00017_ERR_CANNOT_INSTANTIATE_I");
        }
        this.axisIndex_ = iAxisIndex;
        this.maxLevel_ = iMaxLevel == -1 ? Integer.MAX_VALUE : iMaxLevel;
        this.dimensionIndex_ = iDimIndex;
        this.data_ = data;
        this.treeNodes_ = (TreeNode[])data.getValues();
        this.setLimits(startIndex, range, this.treeNodes_.length - 1);
        this.reset();
        this.lastIndex_ = this.upperIndexLimit_;
        while (this.lastIndex_ - this.lowerIndexLimit_ > 1 && this.treeNodes_[this.lastIndex_].equals(this.treeNodes_[this.lastIndex_ - 1])) {
            --this.lastIndex_;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Created DimTreeIter : " + this.toString()));
        }
    }

    public boolean hasNext() {
        int localIndex;
        for (localIndex = this.currentIndex_; localIndex <= this.lastIndex_ && this.treeNodes_[localIndex].getLevel() > this.maxLevel_; ++localIndex) {
        }
        return localIndex <= this.lastIndex_;
    }

    public IMember next() {
        if (!this.hasNext()) {
            throw new VisualizationRuntimeException("VIZ_00018_ERR_CANNOT_MOVE_NEXT_LAB");
        }
        TreeMemberImpl aMember = new TreeMemberImpl(this.treeNodes_[this.currentIndex_], this);
        aMember.setStartIndex(this.currentIndex_);
        aMember.setValuated(true);
        ++this.currentIndex_;
        while (this.hasNext() && (this.treeNodes_[this.currentIndex_].equals(aMember.getTreeNode()) || this.treeNodes_[this.currentIndex_].getLevel() > this.maxLevel_)) {
            ++this.currentIndex_;
        }
        if (this.currentIndex_ <= this.lastIndex_) {
            aMember.setIndexRange(this.currentIndex_ - aMember.getStartIndex());
        } else {
            aMember.setIndexRange(this.upperIndexLimit_ + 1 - aMember.getStartIndex());
        }
        this.currentMember_ = aMember;
        return aMember;
    }

    public IDimensionLabelsIterator createFramedIterator(int iStartIndex, int iRange) {
        DimensionLabelsTreeIterator newIter = new DimensionLabelsTreeIterator(this.data_, iStartIndex, iRange, this.axisIndex_, this.dimensionIndex_, this.maxLevel_);
        newIter.setChildDimensionLabels(this.childIterator_);
        newIter.setParentDimensionLabelsIterator(this.parentIterator_);
        return newIter;
    }

    public void setChildDimensionLabels(DimensionLabelsBaseIterator iterator) {
        this.childIterator_ = iterator;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DimensionLabelsTreeIterator[");
        buffer.append(" childIterator_ = ").append(this.childIterator_);
        buffer.append(" currentIndex_ = ").append(this.currentIndex_);
        buffer.append(" currentMember_ = ").append(this.currentMember_);
        buffer.append(" dimensionDefaultDataType_ = ").append(this.dimensionDefaultDataType_);
        buffer.append(" dimensionIndex_ = ").append(this.dimensionIndex_);
        buffer.append(" maxLevelIndex_ = ").append(this.maxLevel_);
        buffer.append(" parentIterator_ = ").append(this.parentIterator_);
        buffer.append(" lastIndex_ = ").append(this.lastIndex_);
        buffer.append(" lowerIndexLimit_ = ").append(this.lowerIndexLimit_);
        buffer.append(" upperIndexLimit_ = ").append(this.upperIndexLimit_);
        buffer.append("]");
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

