/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.consumer;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.GraphicInstance;
import com.businessobjects.visualization.dataexchange.DataHolder;
import com.businessobjects.visualization.dataexchange.LegendGroup;
import com.businessobjects.visualization.dataexchange.LegendItem;
import com.businessobjects.visualization.dataexchange.callbacks.IDimensionLabelsIterator;
import com.businessobjects.visualization.dataexchange.callbacks.IValuesGrid;
import com.businessobjects.visualization.dataexchange.consumer.DataHandler;
import com.businessobjects.visualization.dataexchange.consumer.MinMaxHelper;
import com.businessobjects.visualization.dataexchange.definition.FilterInfo;
import com.businessobjects.visualization.dataexchange.definition.MeasureValues;
import com.businessobjects.visualization.feed.Feed;
import com.businessobjects.visualization.window.DataWindow;
import com.businessobjects.visualization.window.DataWindowManager;
import com.businessobjects.visualization.window.WindowSize;
import java.util.ArrayList;
import java.util.HashMap;

public class FeedMeasuresHandler
extends DataHandler {
    private static final ILogger LOG = LoggerManager.getLogger((String)(class$com$businessobjects$visualization$dataexchange$consumer$FeedMeasuresHandler == null ? (class$com$businessobjects$visualization$dataexchange$consumer$FeedMeasuresHandler = FeedMeasuresHandler.class$("com.businessobjects.visualization.dataexchange.consumer.FeedMeasuresHandler")) : class$com$businessobjects$visualization$dataexchange$consumer$FeedMeasuresHandler).getName());
    private String[] dataNames_;
    private double[][] dataSets_;
    private int dataSetCount_;
    private IValuesGrid valuesGrid_;
    private int clusterAxisIndex_ = 1;
    private int labelsAxisIndex_;
    private ArrayList legendItems_ = new ArrayList();
    private HashMap legendGroups_ = new HashMap();
    static /* synthetic */ Class class$com$businessobjects$visualization$dataexchange$consumer$FeedMeasuresHandler;

    public FeedMeasuresHandler(Feed yAxisFeed, String[] serieNames, GraphicInstance context) {
        this(yAxisFeed, serieNames, 0, new DataHolder(context.getDataDescriptor(), context.getDataAdapter()), context.getWindowManager());
    }

    public double getValueAt(int clusterIndex, int labelsIndex) {
        int axis0Index = clusterIndex;
        int axis1Index = labelsIndex;
        if (this.clusterAxisIndex_ == 0) {
            axis0Index = labelsIndex;
            axis1Index = clusterIndex;
        }
        return this.valuesGrid_.getSerie(axis0Index, 0)[axis1Index];
    }

    private double[] getSerie(int dataIdx) {
        if (this.clusterAxisIndex_ == 0) {
            int firstAxisLength = this.valuesGrid_.getSeriesCount();
            double[] serie = new double[firstAxisLength];
            for (int i = 0; i < firstAxisLength; ++i) {
                serie[i] = this.valuesGrid_.getSerie(i, 0)[dataIdx];
            }
            return serie;
        }
        return this.valuesGrid_.getSerie(dataIdx, 0);
    }

    public FeedMeasuresHandler(Feed yAxisFeed, String[] serieNames, int analysisAxisIndex, GraphicInstance gi) {
        this(yAxisFeed, serieNames, analysisAxisIndex, new DataHolder(gi.getDataDescriptor(), gi.getDataAdapter()), gi.getWindowManager());
    }

    public FeedMeasuresHandler(Feed yAxisFeed, String[] serieNames, int analysisAxisIndex, DataHolder dh, DataWindowManager dwm) {
        this.init(dh, yAxisFeed.getDataContainers()[0]);
        this.setLabelsAxisIndex(analysisAxisIndex);
        this.valuesGrid_ = this.getMeasureCallBack(dh);
        if (serieNames == null) {
            this.dataSetCount_ = 1;
            this.dataNames_ = new String[]{this.getTitle()};
        } else {
            this.dataNames_ = serieNames;
            this.dataSetCount_ = this.dataNames_.length;
        }
        DataWindow dataWindow = dwm.checkDataWindow();
        WindowSize windowSize = null;
        if (dataWindow != null && dwm.getDataPushMode() == 0) {
            windowSize = dataWindow.getWindowSize();
            if (this.dataSetCount_ > 1 && windowSize.getCountByAxis()[this.clusterAxisIndex_] != -3 && windowSize.getCountByAxis()[this.labelsAxisIndex_] == 1) {
                this.dataSets_ = new double[dataWindow.getWindowSize().getCountByAxis()[this.clusterAxisIndex_]][];
                for (int i = 0; i < serieNames.length; ++i) {
                    int index = dataWindow.getWindowStartIndexes()[this.clusterAxisIndex_] + i;
                    double[] singleValue = new double[]{this.getValueAt(index, dataWindow.getWindowStartIndexes()[this.labelsAxisIndex_])};
                    this.dataSets_[i] = singleValue;
                }
                this.dataSetCount_ = this.dataNames_.length;
                return;
            }
        }
        this.dataSets_ = new double[this.dataSetCount_][];
        for (int dataIdx = 0; dataIdx < this.dataSetCount_; ++dataIdx) {
            if (dataWindow != null && dwm.getDataPushMode() == 0) {
                if (windowSize.getCountByAxis()[this.labelsAxisIndex_] != -3) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Constructor with range on Axis 0: " + dataWindow.getDataRangeByAxis()[this.labelsAxisIndex_]));
                    }
                    this.dataSets_[dataIdx] = new double[windowSize.getCountByAxis()[this.labelsAxisIndex_]];
                    if (this.clusterAxisIndex_ == 0) {
                        int windowStartIndex = dataWindow.getWindowStartIndexes()[this.labelsAxisIndex_];
                        for (int i = 0; i < windowSize.getCountByAxis()[this.labelsAxisIndex_]; ++i) {
                            this.dataSets_[dataIdx][i] = this.valuesGrid_.getSerie(i + windowStartIndex, 0)[dataIdx];
                        }
                        continue;
                    }
                    System.arraycopy(this.valuesGrid_.getSerie(dataIdx, 0), dataWindow.getWindowStartIndexes()[this.labelsAxisIndex_], this.dataSets_[dataIdx], 0, windowSize.getCountByAxis()[this.labelsAxisIndex_]);
                    continue;
                }
                if (windowSize.getCountByAxis().length > 1 && windowSize.getCountByAxis()[this.clusterAxisIndex_] != -3) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Constructor with range on Axis 1: " + dataWindow.getDataRangeByAxis()[this.clusterAxisIndex_]));
                    }
                    this.dataSets_[dataIdx] = this.getSerie(dataIdx + dataWindow.getDataRangeByAxis()[this.clusterAxisIndex_].getLower());
                    continue;
                }
            }
            this.dataSets_[dataIdx] = this.getSerie(dataIdx);
        }
    }

    public IValuesGrid getValuesGrid() {
        return this.valuesGrid_;
    }

    public void fillInLegend(IDimensionLabelsIterator iterator, String title) {
        DataHandler.getLegendInfos(iterator, this.legendItems_, this.legendGroups_, title);
    }

    public LegendItem getLegendItem(int i) {
        return this.legendItems_.size() == 0 ? new LegendItem(this.dataNames_[i], -1) : (LegendItem)this.legendItems_.get(i);
    }

    public ArrayList getLegendItems() {
        return this.legendItems_;
    }

    public LegendGroup getLegendGroup(int i) {
        return (LegendGroup)this.legendGroups_.get(new Integer(i));
    }

    public HashMap getLegendGroups() {
        return this.legendGroups_;
    }

    public int getDataSetCount() {
        return this.dataSetCount_;
    }

    public double[] getData(int dataSetIdx) {
        return this.dataSets_[dataSetIdx];
    }

    public String getDataName(int dataSetIdx) {
        return this.dataNames_[dataSetIdx];
    }

    private IValuesGrid getMeasureCallBack(DataHolder dh) {
        MeasureValues mv = (MeasureValues)this.getDataContainer();
        int mgIndex = dh.getDataDescriptor().getDatasetDescriptor().getMeasureGroupIndex(mv);
        int mvIndex = dh.getDataDescriptor().getDatasetDescriptor().getValueGroupList()[mgIndex].getMeasureValuesIndex(mv);
        return dh.getDataAdapter().getDataset().getValuesGrid(mgIndex, mvIndex);
    }

    public MeasureValues getMeasureValues() {
        return (MeasureValues)this.getDataContainer();
    }

    private double computeGridMinMax(MinMaxHelper.MinMax f) {
        double res = MinMaxHelper.init(f);
        FilterInfo[] filters = null;
        if (this.getDataHolder().getDataDescriptor().getDatasetDescriptor().hasFilterInfo()) {
            filters = this.getDataHolder().getDataDescriptor().getDatasetDescriptor().getFilterInfoList();
        }
        int length = this.valuesGrid_.getSeriesCount();
        for (int i = 0; i < length; ++i) {
            double[] values = this.valuesGrid_.getSerie(i, 0);
            if (filters != null && filters.length > 0) {
                values = FilterInfo.filter(values, filters, this.labelsAxisIndex_);
            }
            res = MinMaxHelper.computeMinMax(res, values, f);
        }
        return res;
    }

    public boolean isDataContainingNoValue() {
        int length = this.valuesGrid_.getSeriesCount();
        for (int i = 0; i < length; ++i) {
            double[] values = this.valuesGrid_.getSerie(i, 0);
            for (int j = 0; j < values.length; ++j) {
                if (values[j] != 1.7E308) continue;
                return true;
            }
        }
        return false;
    }

    public double getMin() {
        return this.computeGridMinMax(MinMaxHelper.GET_MIN);
    }

    public double getMinNotZero() {
        return this.computeGridMinMax(MinMaxHelper.GET_MIN_NOT_ZERO);
    }

    public double getMax() {
        return this.computeGridMinMax(MinMaxHelper.GET_MAX);
    }

    public double[][] appendCumulativeSerie(double[][] source, boolean stackedCluster) {
        double[][] resSerie = null;
        int serieCount = this.valuesGrid_.getSeriesCount();
        int serieLength = this.valuesGrid_.getSerie(0, 0).length;
        if (this.clusterAxisIndex_ == 0) {
            int tmp = serieCount;
            serieCount = serieLength;
            serieLength = tmp;
        }
        resSerie = source != null ? source : (stackedCluster ? new double[2][serieLength] : new double[2][serieLength * serieCount]);
        int startIndex = 0;
        for (int i = 0; i < serieCount; ++i) {
            double[] values = this.getSerie(i);
            if (stackedCluster) {
                startIndex = i * serieCount;
            }
            for (int j = 0; j < serieLength; ++j) {
                if (values[j] == 1.7E308) continue;
                if (stackedCluster) {
                    if (values[j] >= 0.0) {
                        double[] dArray = resSerie[0];
                        int n = j;
                        dArray[n] = dArray[n] + values[j];
                        continue;
                    }
                    double[] dArray = resSerie[1];
                    int n = j;
                    dArray[n] = dArray[n] + values[j];
                    continue;
                }
                if (values[j] >= 0.0) {
                    double[] dArray = resSerie[0];
                    int n = startIndex + j;
                    dArray[n] = dArray[n] + values[j];
                    continue;
                }
                double[] dArray = resSerie[1];
                int n = startIndex + j;
                dArray[n] = dArray[n] + values[j];
            }
        }
        return resSerie;
    }

    public void setLabelsAxisIndex(int analysisAxisIndex) {
        if (analysisAxisIndex != 0) {
            this.labelsAxisIndex_ = analysisAxisIndex;
            this.clusterAxisIndex_ = 0;
        }
    }

    public int getClusterIndex() {
        return this.clusterAxisIndex_;
    }

    public String getTitle() {
        String title = this.getDataContainerAdapter().getTitle();
        if (title == null) {
            title = this.getDataContainer().getId();
        }
        return title;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

