/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.dataexchange.data.AnalysisAxisAdapter;
import com.businessobjects.visualization.dataexchange.data.DataAdapter;
import com.businessobjects.visualization.dataexchange.data.DimensionLabelsAdapter;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesAdapter;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesGroupAdapter;
import com.businessobjects.visualization.dataexchange.definition.AnalysisAxis;
import com.businessobjects.visualization.dataexchange.definition.DataDescriptor;
import com.businessobjects.visualization.dataexchange.definition.DimensionLabels;
import com.businessobjects.visualization.dataexchange.definition.MeasureValues;
import com.businessobjects.visualization.dataexchange.definition.MeasureValuesGroup;

public class DataHolder {
    private final DataDescriptor dataDescriptor_;
    private final DataAdapter dataAdapter_;
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$dataexchange$DataHolder == null ? (class$com$businessobjects$visualization$dataexchange$DataHolder = DataHolder.class$("com.businessobjects.visualization.dataexchange.DataHolder")) : class$com$businessobjects$visualization$dataexchange$DataHolder));
    static /* synthetic */ Class class$com$businessobjects$visualization$dataexchange$DataHolder;

    public DataHolder(DataDescriptor dd, DataAdapter da) {
        this.dataDescriptor_ = dd;
        this.dataAdapter_ = da;
    }

    public DataAdapter getDataAdapter() {
        return this.dataAdapter_;
    }

    public DataDescriptor getDataDescriptor() {
        return this.dataDescriptor_;
    }

    public static boolean checkConsistency(DataDescriptor dd, DataAdapter da, boolean bThrowsException) {
        try {
            MeasureValuesGroupAdapter[] mvga;
            if (dd == null || dd.getDatasetDescriptor() == null) {
                throw new VisualizationRuntimeException("VIZ_00060_ERR_NO_DATA_DEFINITION_E");
            }
            if (da == null || da.getDataset() == null) {
                throw new VisualizationRuntimeException("VIZ_00064_ERR_NO_DATA_ADAPTER_EXIS");
            }
            da.checkDataConsistency();
            AnalysisAxis[] aa = dd.getDatasetDescriptor().getAxisList();
            AnalysisAxisAdapter[] aad = da.getDataset().getAxisList();
            if (aa.length != aad.length) {
                throw new VisualizationInternalException("Invalid number of axes, descriptor:" + aa.length + " adapter:" + aad.length);
            }
            for (int i = 0; i < aa.length; ++i) {
                DimensionLabelsAdapter[] dlAdapterList;
                DimensionLabels[] dlList = aa[i].getDimensionLabelsList();
                if (dlList.length != (dlAdapterList = aad[i].getDimensionLabelsList()).length) {
                    throw new VisualizationInternalException("Invalid number of dimensions on axis:" + i + ", descriptor dims:" + dlList.length + " adapter dims:" + dlAdapterList.length);
                }
                for (int j = 0; j < dlList.length; ++j) {
                    if (dlAdapterList[j].getData().getType() != dlList[j].getDataType()) {
                        throw new VisualizationInternalException("Not matching dataType on axis:" + i + " dim:" + j);
                    }
                    if (dlAdapterList[j].getData().getStructure() == dlList[j].getDataStructure()) continue;
                    throw new VisualizationInternalException("Not matching dataStructure on axis:" + i + " dim:" + j);
                }
            }
            MeasureValuesGroup[] mvg = dd.getDatasetDescriptor().getValueGroupList();
            if (mvg.length != (mvga = da.getDataset().getValueGroupList()).length) {
                throw new VisualizationInternalException("Invalid number of measureGroups, descriptor:" + mvg.length + " adapter:" + mvga.length);
            }
            for (int i = 0; i < mvg.length; ++i) {
                MeasureValuesAdapter[] mvAdapterList;
                MeasureValues[] mvList = mvg[i].getMeasureValuesList();
                if (mvList.length == (mvAdapterList = mvga[i].getMeasureValuesList()).length) continue;
                throw new VisualizationInternalException("Invalid number of measures on group:" + i + ", descriptor mes:" + mvList.length + " adapter mes:" + mvAdapterList.length);
            }
        }
        catch (VisualizationRuntimeException vre) {
            if (bThrowsException) {
                throw vre;
            }
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn((Object)"DataHolder, checkConsistency failed", (Throwable)((Object)vre));
            }
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

