/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization;

import com.businessobjects.visualization.GraphicDescription;
import com.businessobjects.visualization.Helper;
import com.businessobjects.visualization.LocalizedEngine;
import com.businessobjects.visualization.VisualizationEngine;
import com.businessobjects.visualization.common.internal.MigrationRegion;
import com.businessobjects.visualization.common.internal.VisuVersionManager;
import com.businessobjects.visualization.dataexchange.data.DataSamplesManager;
import com.businessobjects.visualization.feed.definition.DataFeedDefinition;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.xml.migration.generated.XMLMigProperty;
import com.businessobjects.visualization.graphic.xml.migration.generated.XMLMigRegion;
import com.businessobjects.visualization.graphic.xml.migration.generated.XMLMigration;
import com.businessobjects.visualization.graphic.xml.migration.generated.XMLMigrationRegion;
import com.businessobjects.visualization.rendering.formats.OutputType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

public class ProviderDescription {
    private String id_;
    private String name_;
    private String label_;
    private int outputType_;
    private int supportedLanguage_;
    private String loaderLibrary_;
    private String loaderClass_;
    private String loaderVersion_;
    private ArrayList graphicDescriptions_ = new ArrayList();
    private VisuVersionManager visuVersionManager_;
    private VisuObject[] defaultValues_;
    private String xmlProviderVersion_;
    private Hashtable feedDefTable_;
    private DataSamplesManager dataSamplesManager_;

    ProviderDescription(Hashtable feedDefTable, VisualizationEngine.VisuProvider xp, String loaderLibrary, String loaderClass, String loaderVersion, LocalizedEngine.Localizator loc) {
        this.id_ = xp.getXmlProvider().m_a_Id;
        this.name_ = loc.getValue(xp.getXmlProvider().m_a_Name);
        this.label_ = loc.getValue(xp.getXmlProvider().m_a_Label);
        this.outputType_ = OutputType.decodeOutputType(xp.getXmlProvider().m_a_Output);
        this.supportedLanguage_ = Helper.decodeSupportedLanguage(xp.getXmlProvider().m_a_SupportedLanguage);
        this.loaderLibrary_ = loaderLibrary;
        this.loaderClass_ = loaderClass;
        this.loaderVersion_ = loaderVersion;
        this.feedDefTable_ = feedDefTable;
        this.dataSamplesManager_ = xp.getDataSamplesManager();
        this.xmlProviderVersion_ = xp.getXmlProvider().m_a_version;
        this.visuVersionManager_ = new VisuVersionManager(this.xmlProviderVersion_);
        if (xp.getXMigrations() != null) {
            ArrayList migrationList = xp.getXMigrations().m_list_Migration;
            for (int i = 0; i < migrationList.size(); ++i) {
                XMLMigration xm = (XMLMigration)migrationList.get(i);
                for (int j = 0; j < xm.m_list_MigrationRegion.size(); ++j) {
                    int k;
                    XMLMigrationRegion xmr = (XMLMigrationRegion)xm.m_list_MigrationRegion.get(j);
                    MigrationRegion mr = this.visuVersionManager_.addRegionVersion(xm.m_a_version, xmr.m_a_parentUid, xmr.m_a_Id);
                    for (k = 0; k < xmr.m_list_MigRegion.size(); ++k) {
                        XMLMigRegion xmigr = (XMLMigRegion)xmr.m_list_MigRegion.get(k);
                        mr.addRegionId(xmigr.m_a_OldId, xmigr.m_a_CurrentId);
                    }
                    for (k = 0; k < xmr.m_list_MigProperty.size(); ++k) {
                        XMLMigProperty xmp = (XMLMigProperty)xmr.m_list_MigProperty.get(k);
                        mr.addPropertyId(xmp.m_a_OldId, xmp.m_a_CurrentId);
                    }
                }
            }
        }
    }

    public String getId() {
        return this.id_;
    }

    public String getName() {
        return this.name_;
    }

    public String getLabel() {
        return this.label_;
    }

    public GraphicDescription getGraphicDescription(String id) {
        Iterator iter = this.graphicDescriptions_.iterator();
        while (iter.hasNext()) {
            GraphicDescription gd = (GraphicDescription)iter.next();
            if (!gd.getId().equals(id)) continue;
            return gd;
        }
        return null;
    }

    public GraphicDescription[] getGraphics() {
        GraphicDescription[] result = new GraphicDescription[this.graphicDescriptions_.size()];
        this.graphicDescriptions_.toArray(result);
        return result;
    }

    Collection getGraphicDescriptionList() {
        return this.graphicDescriptions_;
    }

    public int getAvailableOutputTypes() {
        return this.outputType_;
    }

    public int getSupportedLanguages() {
        return this.supportedLanguage_;
    }

    public String getLoaderClass() {
        return this.loaderClass_;
    }

    public String getLoaderLibrary() {
        return this.loaderLibrary_;
    }

    public String getLoaderVersion() {
        return this.loaderVersion_;
    }

    public boolean checkStaticDependencies(URL url) {
        return false;
    }

    void addGraphicDescription(GraphicDescription gdesc) {
        this.graphicDescriptions_.add(gdesc);
    }

    public VisuObject[] getDefaultValues() {
        return this.defaultValues_;
    }

    void setDefaultValues(VisuObject[] vos) {
        this.defaultValues_ = vos;
    }

    public VisuVersionManager getVisuVersionManager() {
        return this.visuVersionManager_;
    }

    public DataSamplesManager getDataSamplesManager() {
        return this.dataSamplesManager_;
    }

    public String getXmlProviderVersion() {
        return this.xmlProviderVersion_;
    }

    public boolean isValidFeedRestriction(String dataFeedId, String feedDefId, int min, int max) {
        if (!this.feedDefTable_.containsKey(dataFeedId)) {
            return false;
        }
        DataFeedDefinition dataFeedDef = (DataFeedDefinition)this.feedDefTable_.get(dataFeedId);
        return dataFeedDef.findById(feedDefId) != null;
    }

    public boolean isValidDataFeedId(String dataFeedId) {
        return this.feedDefTable_.containsKey(dataFeedId);
    }
}

