/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.value;

import com.crystaldecisions.reports.common.NumberUtil;
import com.crystaldecisions.reports.common.value.CrystalValue;
import com.crystaldecisions.reports.common.value.CurrencyValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.FormulaValueType;
import com.crystaldecisions.reports.common.value.NumberValue;
import java.util.Comparator;

public abstract class NumericValue
extends FormulaValue
implements Comparable {
    public static final double scalingFactor = 100.0;
    public static final int nExactDecimalPlaces = 2;
    private final double k;
    boolean normalized;

    NumericValue(double d, boolean bl) {
        if (d == 0.0) {
            d = 0.0;
        }
        this.k = d;
        this.normalized = bl || NumberUtil.isNormalized(d);
    }

    private static NumericValue a(double d, FormulaValueType formulaValueType, boolean bl) {
        if (formulaValueType == FormulaValueType.number) {
            return NumberValue.fromScaledDouble(d, bl);
        }
        if (formulaValueType == FormulaValueType.currency) {
            return CurrencyValue.fromScaledDouble(d, bl);
        }
        throw new UnsupportedOperationException();
    }

    public static NumericValue fromScaledDouble(double d, FormulaValueType formulaValueType) {
        return NumericValue.a(d, formulaValueType, false);
    }

    public static NumericValue fromScaledLong(long l, FormulaValueType formulaValueType) {
        return NumericValue.a(l, formulaValueType, NumberUtil.isNormalized(l));
    }

    public static NumericValue fromDouble(double d, FormulaValueType formulaValueType) {
        return NumericValue.fromScaledDouble(d * 100.0, formulaValueType);
    }

    public static NumericValue fromLong(long l, FormulaValueType formulaValueType) {
        return NumericValue.a((double)l * 100.0, formulaValueType, NumberUtil.isNormalizedUnscaledLong(l));
    }

    public static NumericValue fromNumericValue(NumericValue numericValue, FormulaValueType formulaValueType) {
        if (numericValue instanceof NumberValue && formulaValueType == FormulaValueType.number) {
            return numericValue;
        }
        if (numericValue instanceof CurrencyValue && formulaValueType == FormulaValueType.currency) {
            return numericValue;
        }
        return NumericValue.a(numericValue.getScaledDouble(), formulaValueType, numericValue.normalized);
    }

    public final NumericValue getNormalizedNumericValue() {
        if (this.normalized) {
            return this;
        }
        double d = NumberUtil.normalizeDouble(this.getScaledDouble());
        if (this.getScaledDouble() == d) {
            this.normalized = true;
            return this;
        }
        return NumericValue.a(d, this.getFormulaValueType(), true);
    }

    public final double getScaledDouble() {
        return this.k;
    }

    public final long getScaledLong() {
        if (Double.isInfinite(this.k) || Double.isNaN(this.k)) {
            throw new IllegalArgumentException("Infinite double value");
        }
        return (long)this.getScaledDouble();
    }

    public final int getScaledInt() {
        if (Double.isInfinite(this.k) || Double.isNaN(this.k)) {
            throw new IllegalArgumentException("Infinite double value");
        }
        return (int)this.getScaledDouble();
    }

    public final double getDouble() {
        return this.k / 100.0;
    }

    public final long getLong() {
        if (Double.isInfinite(this.k) || Double.isNaN(this.k)) {
            throw new IllegalArgumentException("Infinite double value");
        }
        return (long)this.getDouble();
    }

    public final int getInt() {
        if (Double.isInfinite(this.k) || Double.isNaN(this.k)) {
            throw new IllegalArgumentException("Infinite double value");
        }
        return (int)this.getDouble();
    }

    public final boolean isIntegerValue() {
        return this.getDouble() == (double)this.getInt();
    }

    public int hashCode(boolean bl) {
        long l = Double.doubleToLongBits(this.k);
        return (int)(l ^ l >>> 32);
    }

    public boolean equals(Object object, boolean bl) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object, Comparator comparator) {
        return this.compareTo(object);
    }

    public int compareTo(Object object) {
        return Double.compare(this.k, ((NumericValue)object).k);
    }

    public String toString() {
        return "(" + Double.toString(this.getDouble()) + ")";
    }

    public static int getAsInteger(CrystalValue crystalValue, int n) {
        if (crystalValue == null) {
            return n;
        }
        if (crystalValue instanceof NumericValue) {
            return ((NumericValue)crystalValue).getInt();
        }
        throw new NumberFormatException("InvalidValueType");
    }

    public static double getAsDouble(CrystalValue crystalValue, double d) {
        if (crystalValue == null) {
            return d;
        }
        if (crystalValue instanceof NumericValue) {
            return ((NumericValue)crystalValue).getDouble();
        }
        throw new NumberFormatException("InvalidValueType");
    }
}

