/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.value;

import com.crystaldecisions.reports.common.NumberUtil;
import com.crystaldecisions.reports.common.archive.ArchiveException;
import com.crystaldecisions.reports.common.archive.IInputArchive;
import com.crystaldecisions.reports.common.archive.IOutputArchive;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataInput;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataOutput;
import com.crystaldecisions.reports.common.filemanagement.RawData;
import com.crystaldecisions.reports.common.value.BooleanValue;
import com.crystaldecisions.reports.common.value.CurrencyValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.NumericValue;
import com.crystaldecisions.reports.common.value.ValueType;
import java.io.IOException;

public final class NumberValue
extends NumericValue {
    public static final NumberValue zero = new NumberValue(0.0, true);
    public static final NumberValue one = new NumberValue(100.0, true);
    public static final NumberValue two = new NumberValue(200.0, true);
    public static final NumberValue ten = new NumberValue(1000.0, true);

    private NumberValue(double d, boolean bl) {
        super(d, bl);
    }

    public void store(ValueType valueType, ExtendedDataOutput extendedDataOutput) throws IOException {
        assert (valueType.isNumber());
        switch (valueType.value()) {
            case 0: 
            case 1: {
                extendedDataOutput.writeByte(this.getInt());
                break;
            }
            case 2: 
            case 3: {
                extendedDataOutput.writeShort(this.getInt());
                break;
            }
            case 4: {
                extendedDataOutput.writeInt(this.getInt());
                break;
            }
            case 5: {
                extendedDataOutput.writeInt((int)this.getLong());
                break;
            }
            case 17: {
                extendedDataOutput.writeLong(this.getLong());
                break;
            }
            case 6: 
            case 16: {
                extendedDataOutput.writeDouble(this.getScaledDouble());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void storeToArchive(ValueType valueType, IOutputArchive iOutputArchive) throws ArchiveException {
        assert (valueType.isNumber());
        switch (valueType.value()) {
            case 0: {
                iOutputArchive.storeInt8s(this.getInt());
                break;
            }
            case 1: {
                iOutputArchive.storeInt8u(this.getInt());
                break;
            }
            case 2: {
                iOutputArchive.storeInt16s(this.getInt());
                break;
            }
            case 3: {
                iOutputArchive.storeInt16u(this.getInt());
                break;
            }
            case 4: {
                iOutputArchive.storeInt32(this.getInt());
                break;
            }
            case 5: {
                iOutputArchive.storeInt32((int)this.getLong());
                break;
            }
            case 17: {
                iOutputArchive.storeInt64(this.getLong());
                break;
            }
            case 6: 
            case 16: {
                iOutputArchive.storeDouble(this.getScaledDouble());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public static NumberValue Load(ValueType valueType, ExtendedDataInput extendedDataInput) throws IOException {
        NumberValue numberValue;
        assert (valueType.isNumber());
        switch (valueType.value()) {
            case 0: {
                numberValue = NumberValue.fromLong(extendedDataInput.readByte());
                break;
            }
            case 1: {
                numberValue = NumberValue.fromLong(extendedDataInput.readUnsignedByte());
                break;
            }
            case 2: {
                numberValue = NumberValue.fromLong(extendedDataInput.readShort());
                break;
            }
            case 3: {
                numberValue = NumberValue.fromLong(extendedDataInput.readUnsignedShort());
                break;
            }
            case 4: {
                numberValue = NumberValue.fromLong(extendedDataInput.readInt());
                break;
            }
            case 5: {
                byte[] byArray = new byte[4];
                extendedDataInput.readFully(byArray);
                numberValue = NumberValue.fromLong(RawData.Int32uFromData(byArray, 0));
                break;
            }
            case 17: {
                numberValue = NumberValue.fromLong(extendedDataInput.readLong());
                break;
            }
            case 6: 
            case 16: {
                numberValue = NumberValue.fromScaledDouble(extendedDataInput.readDouble());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return numberValue;
    }

    public static NumberValue LoadFromArchive(ValueType valueType, IInputArchive iInputArchive) throws ArchiveException {
        NumberValue numberValue;
        assert (valueType.isNumber());
        switch (valueType.value()) {
            case 0: {
                numberValue = NumberValue.fromLong(iInputArchive.loadInt8s());
                break;
            }
            case 1: {
                numberValue = NumberValue.fromLong(iInputArchive.loadInt8u());
                break;
            }
            case 2: {
                numberValue = NumberValue.fromLong(iInputArchive.loadInt16s());
                break;
            }
            case 3: {
                numberValue = NumberValue.fromLong(iInputArchive.loadInt16u());
                break;
            }
            case 4: {
                numberValue = NumberValue.fromLong(iInputArchive.loadInt32());
                break;
            }
            case 5: {
                byte[] byArray = iInputArchive.loadBlock(4);
                numberValue = NumberValue.fromLong(RawData.Int32uFromData(byArray, 0));
                break;
            }
            case 17: {
                numberValue = NumberValue.fromLong(iInputArchive.loadInt64());
                break;
            }
            case 6: 
            case 16: {
                numberValue = NumberValue.fromScaledDouble(iInputArchive.loadDouble());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return numberValue;
    }

    public static int GetMaxEncodedSize(ValueType valueType) {
        int n = 0;
        switch (valueType.value()) {
            case 0: 
            case 1: {
                n = 1;
                break;
            }
            case 2: 
            case 3: {
                n = 2;
                break;
            }
            case 4: 
            case 5: {
                n = 4;
                break;
            }
            case 17: 
            case 18: {
                n = 8;
                break;
            }
            case 6: 
            case 16: {
                n = 8;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return n;
    }

    public int getEncodedSizeForArchive(ValueType valueType) {
        assert (valueType.isNumber());
        return NumberValue.GetMaxEncodedSize(valueType);
    }

    public int getEncodedSize(ValueType valueType) {
        assert (valueType.isNumber());
        return NumberValue.GetMaxEncodedSize(valueType);
    }

    static NumberValue fromScaledDouble(double d, boolean bl) {
        if (d == zero.getScaledDouble()) {
            return zero;
        }
        if (d == one.getScaledDouble()) {
            return one;
        }
        if (d == two.getScaledDouble()) {
            return two;
        }
        if (d == ten.getScaledDouble()) {
            return ten;
        }
        return new NumberValue(d, bl);
    }

    public static NumberValue fromScaledDouble(double d) {
        return NumberValue.fromScaledDouble(d, false);
    }

    public static NumberValue fromScaledLong(long l) {
        return NumberValue.fromScaledDouble((double)l, NumberUtil.isNormalized(l));
    }

    public static NumberValue fromDouble(double d) {
        return NumberValue.fromScaledDouble(d * 100.0);
    }

    public static NumberValue fromLong(long l) {
        return NumberValue.fromScaledDouble((double)l * 100.0, NumberUtil.isNormalizedUnscaledLong(l));
    }

    public static NumberValue fromCurrencyValue(CurrencyValue currencyValue) {
        return NumberValue.fromScaledDouble(currencyValue.getScaledDouble(), currencyValue.normalized);
    }

    public FormulaValue coerceToNumber() {
        return this;
    }

    public FormulaValue coerceToCurrency() {
        return CurrencyValue.fromNumberValue(this);
    }

    public FormulaValue coerceToBoolean() {
        return this.getScaledDouble() == 0.0 ? BooleanValue.FALSE : BooleanValue.TRUE;
    }

    public ValueType getValueType() {
        return ValueType.number;
    }

    public String toString() {
        return "n" + super.toString();
    }
}

