/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.value;

import com.crystaldecisions.reports.common.archive.ArchiveException;
import com.crystaldecisions.reports.common.archive.IInputArchive;
import com.crystaldecisions.reports.common.archive.IOutputArchive;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataOutput;
import com.crystaldecisions.reports.common.value.CrystalValue;
import com.crystaldecisions.reports.common.value.ValueType;
import java.io.DataInput;
import java.io.IOException;
import java.util.Comparator;

public abstract class BinaryValue
extends CrystalValue
implements Comparable {
    public static final BinaryValue empty = BinaryValue.fromByteArray(new byte[0]);

    public static BinaryValue fromByteArray(byte[] byArray) {
        return BinaryValue.makeSimpleMutableBinaryValue(byArray);
    }

    public static BinaryValue makeSimpleMutableBinaryValue(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return SimpleMutableBinaryValue.byte;
        }
        return new SimpleMutableBinaryValue(byArray);
    }

    public static BinaryValue makeSimpleImmutableBinaryValue(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return SimpleImmutableBinaryValue.case;
        }
        return new SimpleImmutableBinaryValue(byArray);
    }

    public static BinaryValue makeSimpleImmutableBinaryValue(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0 || n2 == 0) {
            return SimpleImmutableBinaryValue.case;
        }
        return new SimpleImmutableBinaryValue(byArray, n, n2);
    }

    public abstract int getLength();

    public abstract byte[] getAllBytes();

    public abstract void getBytes(int var1, byte[] var2, int var3, int var4);

    public abstract byte[] getByteSequence(int var1, int var2);

    public abstract byte getByteAt(int var1);

    public final ValueType getValueType() {
        return ValueType.blob;
    }

    public boolean equals(Object object, boolean bl) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        int n = BinaryValue.compare(this.getLength(), ((BinaryValue)object).getLength());
        if (n != 0) {
            return n;
        }
        for (int i = 0; i < this.getLength(); ++i) {
            n = BinaryValue.compare(this.getByteAt(i), ((BinaryValue)object).getByteAt(i));
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public int compareTo(Object object, Comparator comparator) {
        return this.compareTo(object);
    }

    public static BinaryValue Load(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        return BinaryValue.makeSimpleImmutableBinaryValue(byArray);
    }

    public static BinaryValue LoadFromArchive(IInputArchive iInputArchive) throws ArchiveException {
        int n = iInputArchive.loadInt32();
        byte[] byArray = iInputArchive.loadBlock(n);
        return BinaryValue.makeSimpleImmutableBinaryValue(byArray);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class SimpleMutableBinaryValue
    extends SimpleBinaryValue {
        private static final SimpleMutableBinaryValue byte = new SimpleMutableBinaryValue(new byte[0]);

        private SimpleMutableBinaryValue(byte[] byArray) {
            super(byArray, false);
        }

        public byte[] getAllBytes() {
            return this.getAllBytes(false);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class SimpleImmutableBinaryValue
    extends SimpleBinaryValue {
        private static final SimpleImmutableBinaryValue case = new SimpleImmutableBinaryValue(new byte[0]);

        private SimpleImmutableBinaryValue(byte[] byArray) {
            super(byArray, true);
        }

        private SimpleImmutableBinaryValue(byte[] byArray, int n, int n2) {
            super(byArray, n, n2);
        }

        public byte[] getAllBytes() {
            return this.getAllBytes(true);
        }
    }

    private static abstract class SimpleBinaryValue
    extends BinaryValue {
        final byte[] byteArray;

        public void store(ValueType valueType, ExtendedDataOutput extendedDataOutput) throws IOException {
            assert (valueType == this.getValueType());
            extendedDataOutput.writeInt(this.byteArray.length);
            extendedDataOutput.write(this.byteArray);
        }

        public void storeToArchive(ValueType valueType, IOutputArchive iOutputArchive) throws ArchiveException {
            assert (valueType == this.getValueType());
            iOutputArchive.storeInt32(this.byteArray.length);
            iOutputArchive.storeBlock(this.byteArray);
        }

        public int getEncodedSizeForArchive(ValueType valueType) {
            return this.getEncodedSize(valueType);
        }

        public int getEncodedSize(ValueType valueType) {
            assert (valueType == this.getValueType());
            return 4 + this.byteArray.length;
        }

        private SimpleBinaryValue(byte[] byArray, boolean bl) {
            this.byteArray = bl ? (byte[])byArray.clone() : byArray;
        }

        private SimpleBinaryValue(byte[] byArray, int n, int n2) {
            this.byteArray = new byte[n2];
            System.arraycopy(byArray, n, this.byteArray, 0, n2);
        }

        public int getLength() {
            return this.byteArray.length;
        }

        public byte[] getAllBytes(boolean bl) {
            return bl ? (byte[])this.byteArray.clone() : this.byteArray;
        }

        public byte[] getByteSequence(int n, int n2) {
            if (n < 0) {
                throw new IndexOutOfBoundsException("beginIndex is less than zero");
            }
            if (n2 > this.byteArray.length) {
                throw new IndexOutOfBoundsException("endIndex is greater than the length.");
            }
            if (n > n2) {
                throw new IndexOutOfBoundsException("beginIndex is greater than endIndex");
            }
            int n3 = n2 - n;
            byte[] byArray = new byte[n3];
            for (int i = 0; i < n3; ++i) {
                byArray[i] = this.byteArray[n + i];
            }
            return byArray;
        }

        public byte getByteAt(int n) {
            return this.byteArray[n];
        }

        public void getBytes(int n, byte[] byArray, int n2, int n3) {
            System.arraycopy(this.byteArray, n, byArray, n2, n3);
        }

        public int hashCode(boolean bl) {
            int n = 17;
            for (int i = 0; i < this.getLength(); ++i) {
                n = 37 * n + this.getByteAt(i);
            }
            return n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.getLength();
            stringBuilder.append("b(");
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("(");
                stringBuilder.append(this.getByteAt(i));
                stringBuilder.append(")");
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }
}

