/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.value;

import com.crystaldecisions.reports.common.archive.ArchiveException;
import com.crystaldecisions.reports.common.archive.IInputArchive;
import com.crystaldecisions.reports.common.archive.IOutputArchive;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataInput;
import com.crystaldecisions.reports.common.filemanagement.ExtendedDataOutput;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.FormulaValueType;
import com.crystaldecisions.reports.common.value.RangeValue;
import com.crystaldecisions.reports.common.value.ValueType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayValue
extends FormulaValue {
    private final FormulaValue[] e;
    private final ValueType d;
    private static final FormulaValue[] f = new FormulaValue[0];
    public static final ArrayValue emptyNumberArray = new ArrayValue(f, FormulaValueType.number, false);
    public static final ArrayValue emptyCurrencyArray = new ArrayValue(f, FormulaValueType.currency, false);
    public static final ArrayValue emptyBooleanArray = new ArrayValue(f, FormulaValueType.bool, false);
    public static final ArrayValue emptyDateArray = new ArrayValue(f, FormulaValueType.date, false);
    public static final ArrayValue emptyTimeArray = new ArrayValue(f, FormulaValueType.time, false);
    public static final ArrayValue emptyDateTimeArray = new ArrayValue(f, FormulaValueType.dateTime, false);
    public static final ArrayValue emptyStringArray = new ArrayValue(f, FormulaValueType.string, false);
    public static final ArrayValue emptyNumberRangeArray = new ArrayValue(f, FormulaValueType.numberRange, false);
    public static final ArrayValue emptyCurrencyRangeArray = new ArrayValue(f, FormulaValueType.currencyRange, false);
    public static final ArrayValue emptyDateRangeArray = new ArrayValue(f, FormulaValueType.dateRange, false);
    public static final ArrayValue emptyTimeRangeArray = new ArrayValue(f, FormulaValueType.timeRange, false);
    public static final ArrayValue emptyDateTimeRangeArray = new ArrayValue(f, FormulaValueType.dateTimeRange, false);
    public static final ArrayValue emptyStringRangeArray = new ArrayValue(f, FormulaValueType.stringRange, false);

    private ArrayValue(FormulaValue[] formulaValueArray, FormulaValueType formulaValueType, boolean bl) {
        this.e = formulaValueArray;
        if (formulaValueType.isArray()) {
            throw new IllegalArgumentException("Arrays are not permitted in an ArrayValue.");
        }
        if (bl && !formulaValueType.isRange()) {
            if (formulaValueType == FormulaValueType.bool) {
                throw new IllegalArgumentException("There are no boolean range values");
            }
            formulaValueType = formulaValueType.getRangeFormulaValueType();
        }
        if (formulaValueArray.length > 0) {
            if (formulaValueType.getBaseFormulaValueType() == FormulaValueType.unknown) {
                throw new IllegalArgumentException("An array value cannot be of unknown type");
            }
            ValueType valueType = formulaValueType.toValueType();
            for (int i = 0; i < formulaValueArray.length; ++i) {
                if (formulaValueArray[i] == null) continue;
                ValueType valueType2 = formulaValueArray[i].getValueType();
                if (bl && !valueType2.isRange()) {
                    formulaValueArray[i] = RangeValue.fromSingleValue(formulaValueArray[i]);
                    valueType2 = formulaValueArray[i].getValueType();
                }
                if (valueType2 == valueType) continue;
                throw new IllegalArgumentException("All Values must have the same ValueType.");
            }
        }
        this.d = formulaValueType.toValueType().getArrayValueType();
    }

    private static ArrayValue a(FormulaValue[] formulaValueArray, FormulaValueType formulaValueType, boolean bl) {
        if (formulaValueArray == null) {
            return null;
        }
        if (formulaValueArray.length == 0) {
            if (bl) {
                if (formulaValueType == FormulaValueType.bool) {
                    throw new IllegalArgumentException("There are no boolean range values");
                }
                formulaValueType = formulaValueType.getRangeFormulaValueType();
            }
            switch (formulaValueType.value()) {
                case 6: {
                    return emptyNumberArray;
                }
                case 7: {
                    return emptyCurrencyArray;
                }
                case 8: {
                    return emptyBooleanArray;
                }
                case 9: {
                    return emptyDateArray;
                }
                case 10: {
                    return emptyTimeArray;
                }
                case 15: {
                    return emptyDateTimeArray;
                }
                case 11: {
                    return emptyStringArray;
                }
                case 4102: {
                    return emptyNumberRangeArray;
                }
                case 4103: {
                    return emptyCurrencyRangeArray;
                }
                case 4105: {
                    return emptyDateRangeArray;
                }
                case 4106: {
                    return emptyTimeRangeArray;
                }
                case 4111: {
                    return emptyDateTimeRangeArray;
                }
                case 4107: {
                    return emptyStringRangeArray;
                }
            }
        }
        return new ArrayValue(formulaValueArray, formulaValueType, bl);
    }

    private static FormulaValue[] if(FormulaValue[] formulaValueArray) {
        if (formulaValueArray == null) {
            return null;
        }
        if (formulaValueArray.length == 0) {
            return formulaValueArray;
        }
        return (FormulaValue[])formulaValueArray.clone();
    }

    private static FormulaValue[] a(List list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        if (n == 0) {
            return f;
        }
        FormulaValue[] formulaValueArray = new FormulaValue[n];
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (e != null && !(e instanceof FormulaValue)) {
                throw new IllegalArgumentException("All values in the list must be 'FormulaValue' objects.");
            }
            formulaValueArray[i] = (FormulaValue)e;
        }
        return formulaValueArray;
    }

    private static FormulaValueType a(FormulaValue[] formulaValueArray) {
        FormulaValueType formulaValueType = FormulaValueType.unknown;
        if (formulaValueArray != null) {
            for (int i = 0; i < formulaValueArray.length; ++i) {
                if (formulaValueArray[i] == null) continue;
                formulaValueType = formulaValueArray[i].getFormulaValueType();
                break;
            }
        }
        return formulaValueType;
    }

    public static ArrayValue fromArray(FormulaValue[] formulaValueArray) {
        return ArrayValue.a(ArrayValue.if(formulaValueArray), ArrayValue.a(formulaValueArray), false);
    }

    public static ArrayValue fromArray(FormulaValue[] formulaValueArray, FormulaValueType formulaValueType) {
        return ArrayValue.a(ArrayValue.if(formulaValueArray), formulaValueType, false);
    }

    public static ArrayValue fromMixedRangeArray(FormulaValue[] formulaValueArray) {
        return ArrayValue.a(ArrayValue.if(formulaValueArray), ArrayValue.a(formulaValueArray), true);
    }

    public static ArrayValue fromMixedRangeArray(FormulaValue[] formulaValueArray, FormulaValueType formulaValueType) {
        return ArrayValue.a(ArrayValue.if(formulaValueArray), formulaValueType, true);
    }

    public static ArrayValue fromSingleValue(FormulaValue formulaValue) {
        return ArrayValue.a(new FormulaValue[]{formulaValue}, formulaValue.getFormulaValueType(), false);
    }

    public static ArrayValue fromSingleValue(FormulaValue formulaValue, FormulaValueType formulaValueType) {
        return ArrayValue.a(new FormulaValue[]{formulaValue}, formulaValueType, false);
    }

    private static ArrayValue a(List list, boolean bl) {
        FormulaValue[] formulaValueArray = ArrayValue.a(list);
        return ArrayValue.a(formulaValueArray, ArrayValue.a(formulaValueArray), bl);
    }

    public static ArrayValue fromList(List list) {
        return ArrayValue.a(list, false);
    }

    private static ArrayValue a(List list, FormulaValueType formulaValueType, boolean bl) {
        return ArrayValue.a(ArrayValue.a(list), formulaValueType, bl);
    }

    public static ArrayValue fromList(List list, FormulaValueType formulaValueType) {
        return ArrayValue.a(list, formulaValueType, false);
    }

    public static ArrayValue fromMixedRangeList(List list) {
        return ArrayValue.a(list, true);
    }

    public static ArrayValue fromMixedRangeList(List list, FormulaValueType formulaValueType) {
        return ArrayValue.a(list, formulaValueType, true);
    }

    @Override
    public void store(ValueType valueType, ExtendedDataOutput extendedDataOutput) throws IOException {
        assert (valueType == this.getValueType());
        extendedDataOutput.writeInt(this.e.length);
        for (int i = 0; i < this.e.length; ++i) {
            this.e[i].store(valueType.getNonArrayValueType(), extendedDataOutput);
        }
    }

    @Override
    public void storeToArchive(ValueType valueType, IOutputArchive iOutputArchive) throws ArchiveException {
        assert (valueType == this.getValueType());
        iOutputArchive.storeInt32(this.e.length);
        for (int i = 0; i < this.e.length; ++i) {
            this.e[i].storeToArchive(valueType.getNonArrayValueType(), iOutputArchive);
        }
    }

    public static ArrayValue LoadFromArchive(ValueType valueType, IInputArchive iInputArchive) throws ArchiveException {
        assert (valueType.isArray());
        int n = iInputArchive.loadInt32();
        FormulaValue[] formulaValueArray = new FormulaValue[n];
        for (int i = 0; i < n; ++i) {
            formulaValueArray[i] = FormulaValue.LoadFromArchive(valueType.getNonArrayValueType(), iInputArchive);
        }
        return ArrayValue.fromArray(formulaValueArray);
    }

    public static ArrayValue Load(ValueType valueType, ExtendedDataInput extendedDataInput) throws IOException {
        assert (valueType.isArray());
        int n = extendedDataInput.readInt();
        FormulaValue[] formulaValueArray = new FormulaValue[n];
        for (int i = 0; i < n; ++i) {
            formulaValueArray[i] = FormulaValue.Load(valueType.getNonArrayValueType(), extendedDataInput);
        }
        return ArrayValue.fromArray(formulaValueArray);
    }

    @Override
    public int getEncodedSizeForArchive(ValueType valueType) {
        assert (valueType == this.getValueType());
        int n = 4;
        for (int i = 0; i < this.e.length; ++i) {
            n += this.e[i].getEncodedSizeForArchive(valueType.getNonArrayValueType());
        }
        return n;
    }

    @Override
    public int getEncodedSize(ValueType valueType) {
        assert (valueType == this.getValueType());
        int n = 4;
        for (int i = 0; i < this.e.length; ++i) {
            n += this.e[i].getEncodedSize(valueType.getNonArrayValueType());
        }
        return n;
    }

    @Override
    public FormulaValue coerceToNumber() {
        return this.a(FormulaValueType.number);
    }

    @Override
    public FormulaValue coerceToCurrency() {
        return this.a(FormulaValueType.currency);
    }

    @Override
    public FormulaValue coerceToBoolean() {
        return this.a(FormulaValueType.bool);
    }

    @Override
    public FormulaValue coerceToDate() {
        return this.a(FormulaValueType.date);
    }

    @Override
    public FormulaValue coerceToTime() {
        return this.a(FormulaValueType.time);
    }

    @Override
    public FormulaValue coerceToDateTime() {
        return this.a(FormulaValueType.dateTime);
    }

    @Override
    public FormulaValue coerceToString() {
        return this.a(FormulaValueType.string);
    }

    private FormulaValue a(FormulaValueType formulaValueType) {
        int n;
        FormulaValueType formulaValueType2 = this.getFormulaValueType();
        FormulaValueType formulaValueType3 = formulaValueType2.getBaseFormulaValueType();
        if (formulaValueType3 == formulaValueType) {
            return this;
        }
        FormulaValueType formulaValueType4 = formulaValueType;
        if (formulaValueType2.isRange()) {
            formulaValueType4 = formulaValueType4.getRangeFormulaValueType();
        }
        if ((n = this.getLength()) == 0) {
            return ArrayValue.a(f, formulaValueType4, false);
        }
        FormulaValue[] formulaValueArray = new FormulaValue[n];
        for (int i = 0; i < n; ++i) {
            if (this.get(i) == null) continue;
            formulaValueArray[i] = ArrayValue.coerce(this.get(i), formulaValueType4);
            if (formulaValueArray[i] != null) continue;
            return null;
        }
        return ArrayValue.a(formulaValueArray, formulaValueType4, false);
    }

    @Override
    public FormulaValue coerceToRange() {
        if (this.getValueType().isRange()) {
            return this;
        }
        return ArrayValue.a(this.getArray(), this.getFormulaValueType().getNonArrayFormulaValueType(), true);
    }

    @Override
    public FormulaValue coerceToArray() {
        return this;
    }

    public FormulaValue[] getArray() {
        return ArrayValue.if(this.e);
    }

    public List<FormulaValue> getList() {
        ArrayList<FormulaValue> arrayList = new ArrayList<FormulaValue>();
        for (int i = 0; i < this.getLength(); ++i) {
            arrayList.add(this.get(i));
        }
        return arrayList;
    }

    public int getLength() {
        return this.e.length;
    }

    public FormulaValue get(int n) {
        return this.e[n];
    }

    @Override
    public ValueType getValueType() {
        return this.d;
    }

    public FormulaValueType getElementFormulaValueType() {
        return this.getFormulaValueType().getNonArrayFormulaValueType();
    }

    @Override
    public boolean equals(Object object, boolean bl) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass() || ((ArrayValue)object).getLength() != this.getLength()) {
            return false;
        }
        for (int i = 0; i < this.getLength(); ++i) {
            if (!(this.get(i) == null ? ((ArrayValue)object).get(i) != null : !this.get(i).equals(((ArrayValue)object).get(i), bl))) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object object, Comparator comparator) {
        if (object == this) {
            return 0;
        }
        ArrayValue arrayValue = (ArrayValue)object;
        if (this.getValueType() != arrayValue.getValueType()) {
            throw new ClassCastException("Can't compare ArrayValues with different valueTypes");
        }
        int n = ArrayValue.compare(this.getLength(), arrayValue.getLength());
        if (n != 0) {
            return n;
        }
        for (int i = 0; i < this.getLength(); ++i) {
            n = ArrayValue.compare(this.get(i) == null ? 0 : 1, arrayValue.get(i) == null ? 0 : 1);
            if (n != 0) {
                return n;
            }
            if (this.get(i) == null && arrayValue.get(i) == null || (n = this.get(i).compareTo(arrayValue.get(i), comparator)) == 0) continue;
            return n;
        }
        return 0;
    }

    @Override
    public int hashCode(boolean bl) {
        int n = 17;
        for (int i = 0; i < this.getLength(); ++i) {
            n = 37 * n + (this.get(i) == null ? 0 : this.get(i).hashCode(bl));
        }
        return n;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("a(");
        for (int i = 0; i < this.getLength(); ++i) {
            if (i > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(this.get(i));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

