/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.place;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Detectiv;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextStyleObjFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Pie;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_Base;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JGraphType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.LegendMarkersLabels;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisUtils;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IAxis2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.INumericAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.place.PlaceDefaultElements;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.place.PlaceMode;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaceUtilities {
    public static final String TRUNCATED_SUFFIX = "...";
    private static final Logger m_logger = Logger.getLogger((String)"com.businessobjects.visualization.pfjgraphics.rendering.pfj.place.PlaceUtilities");
    public static final int MARGIN_VC = 500;
    public static final int SMALL_MARGIN_VC = 50;
    public static final int LABEL_TITLE_MARGIN_VC = 50;
    public static final int TITLE_MARGIN_VC = 400;
    static final String DEFAULT_TITLE_FONT = "Arial";
    static final String DEFAULT_LABEL_FONT = "San Serif";
    static final int DEFAULT_TITLE_FONTSIZE = 1539;
    static final int DEFAULT_SUBTITLE_FONTSIZE = 1099;
    static final int DEFAULT_FONTSIZE_LARGE = 1200;
    static final int DEFAULT_FONTSIZE_MEDIUM = 1000;
    static final int DEFAULT_FONTSIZE_SMALL = 800;
    static final int DEFAULT_FONTSIZE_TINY = 600;
    public static final int DEFAULT_LEGEND_FONTSIZE = 1000;
    public static final int MIN_FONTSIZE = 500;
    static final int DEFAULT_MARKER_PERCENTAGE = 50;

    public static void addWordWrapIfOK(Perspective p, IdentObj o) {
        if (p.getPlaceWordWrap(o) > 0) {
            p.setTextWrap(o, true);
        }
    }

    public static void addWordWrapIfNeeded(Perspective p, IdentObj o, int boundLengthVC) {
        if (p.getPlaceWordWrap(o) > 0) {
            p.setTextWrap(o, false);
            int textLen = PlaceUtilities.getDimLargestLabelVC((Perspective)p, (IdentObj)o).width;
            if ((double)textLen > 0.8 * (double)boundLengthVC) {
                p.setTextWrap(o, true);
            }
        }
    }

    public static void addWordWrap(Perspective p, IdentObj o) {
        if (p.getPlaceWordWrap(o) > 0) {
            p.setTextWrap(o, true);
        }
    }

    public static boolean addRotationIfOK(Perspective p, IdentObj o, int rotation) {
        if (p.getPlaceRotate(o) > 0) {
            p.setTextRotation(o, rotation);
            return true;
        }
        return false;
    }

    public static boolean autoskipIfOK(Perspective p, IdentObj o) {
        if (p.getPlaceSkip(o) > 0 && p.getTextRotation(Identity.O1Label) != 3) {
            p.setAutoSkip(o, 1);
            return true;
        }
        return false;
    }

    static final boolean isRotated90or270(Perspective p, IdentObj id) {
        return PlaceUtilities.isRotated90(p, id) || PlaceUtilities.isRotated270(p, id);
    }

    static final boolean isRotated90(Perspective p, IdentObj id) {
        boolean rotated = false;
        if (p.getTextRotation(id) == 1) {
            rotated = true;
        }
        return rotated;
    }

    static final boolean isRotated270(Perspective p, IdentObj id) {
        boolean rotated = false;
        if (p.getTextRotation(id) == 2) {
            rotated = true;
        }
        return rotated;
    }

    static final boolean isRotated45(Perspective p, IdentObj id) {
        boolean rotated = false;
        if (p.getTextRotation(id) == 3) {
            rotated = true;
        }
        return rotated;
    }

    public static boolean alignIfOK(Perspective p, IdentObj o, int alignment) {
        if (p.getPlaceAlign(o) > 0) {
            p.setTextJustHoriz(o, alignment);
            return true;
        }
        return false;
    }

    public static int getLongestWordLength(String text) {
        StringTokenizer st = new StringTokenizer(text, " \n\n\r\r\n\r");
        int max = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.length() <= max) continue;
            max = s.length();
        }
        return max;
    }

    public static List<IdentObj> getTextObjects(Perspective p) {
        List<IdentObj> textObjectList = PlaceUtilities.getLabelObjects(p);
        if (p.getDisplay(Identity.DataText)) {
            textObjectList.add(Identity.DataText);
        }
        if (p.getDisplay(Identity.PieGroupLabel)) {
            textObjectList.add(Identity.PieGroupLabel);
        }
        if (p.getDisplay(Identity.FunnelGroupLabel)) {
            textObjectList.add(Identity.FunnelGroupLabel);
        }
        if (p.getDisplay(Identity.PieRingLabel)) {
            textObjectList.add(Identity.PieRingLabel);
        }
        if (p.getDisplay(Identity.PieSliceLabel)) {
            textObjectList.add(Identity.PieSliceLabel);
        }
        if (p.getDisplay(Identity.FunnelSliceLabel)) {
            textObjectList.add(Identity.FunnelSliceLabel);
        }
        if (p.getDisplay(Identity.FunnelValueLabel)) {
            textObjectList.add(Identity.FunnelValueLabel);
        }
        if (p.getDisplay(Identity.LegendText)) {
            textObjectList.add(Identity.LegendText);
        }
        if (p.getDisplay(Identity.O1Title)) {
            textObjectList.add(Identity.O1Title);
        }
        if (p.getDisplay(Identity.X1Title)) {
            textObjectList.add(Identity.X1Title);
        }
        if (p.getDisplay(Identity.Y1Title)) {
            textObjectList.add(Identity.Y1Title);
        }
        if (p.getJGraphType().getAxisDescriptor().hasO2() && p.getDisplay(Identity.O2Title)) {
            textObjectList.add(Identity.O2Title);
        }
        if (p.getJGraphType().getAxisDescriptor().hasY2() && p.getDisplay(Identity.Y2Title)) {
            textObjectList.add(Identity.Y2Title);
        }
        if (p.getDisplay(Identity.Title)) {
            textObjectList.add(Identity.Title);
        }
        if (p.getDisplay(Identity.Subtitle)) {
            textObjectList.add(Identity.Subtitle);
        }
        if (p.getDisplay(Identity.Footnote)) {
            textObjectList.add(Identity.Footnote);
        }
        return textObjectList;
    }

    public static List<IdentObj> getLabelObjects(Perspective p) {
        ArrayList<IdentObj> textObjectList = new ArrayList<IdentObj>();
        if (p.getDisplay(Identity.O1Label)) {
            textObjectList.add(Identity.O1Label);
        }
        if (p.getDisplay(Identity.X1Label)) {
            textObjectList.add(Identity.X1Label);
        }
        if (p.getDisplay(Identity.Y1Label)) {
            textObjectList.add(Identity.Y1Label);
        }
        if (p.getJGraphType().getAxisDescriptor().hasO2() && p.getDisplay(Identity.O2Label)) {
            textObjectList.add(Identity.O2Label);
        }
        if (p.getJGraphType().getAxisDescriptor().hasY2() && p.getDisplay(Identity.Y2Label)) {
            textObjectList.add(Identity.Y2Label);
        }
        return textObjectList;
    }

    public static void alignAllIfOK(Perspective p) {
        List<IdentObj> textObjectList = PlaceUtilities.getTextObjects(p);
        for (IdentObj id : textObjectList) {
            PlaceUtilities.align(p, id);
        }
    }

    public static void autoskipAllIfOK(Perspective p) {
        List<IdentObj> textObjectList = PlaceUtilities.getTextObjects(p);
        for (IdentObj id : textObjectList) {
            PlaceUtilities.autoskipIfOK(p, id);
        }
    }

    public static void truncateAllIfOK(Perspective p) {
        List<IdentObj> textObjectList = PlaceUtilities.getTextObjects(p);
        for (IdentObj id : textObjectList) {
            PlaceUtilities.truncateText(p, id);
        }
    }

    public static void align(Perspective p, IdentObj id) {
        JGraphType type = p.getJGraphType();
        boolean isHoriz = type.isOrientHorz();
        int rotation = p.getTextRotation(id);
        int objectId = id.getObjectID();
        int just = 0;
        if (objectId == 14 && p.getLegendMarkerPosition() == 2 || objectId == 14 && p.getLegendMarkerPosition() == 3 || objectId == 14 && p.getLegendMarkerPosition() == 4 || objectId == 5 || objectId == 4 || objectId == 8 || objectId == 9 || objectId == 10 || objectId == 6 || objectId == 7 || objectId == 67 || objectId == 69 || objectId == 71 || objectId == 9003 || objectId == 9004 || objectId == 9005 || objectId == 540 || objectId == 821 || objectId == 524 && !PlaceUtilities.isRotated90or270(p, id) || objectId == 528 && isHoriz && !PlaceUtilities.isRotated45(p, id) || objectId == 685 && isHoriz || objectId == 695 && isHoriz || objectId == 528 && PlaceUtilities.isRotated90or270(p, id) || objectId == 532 && PlaceUtilities.isRotated90or270(p, id) || objectId == 504 || objectId == 514 && !type.is3DType() && !type.isWaterfall() && rotation == 0 && !isHoriz) {
            just = 1;
        } else if (objectId == 3 || objectId == 528 && type.isPolar() || objectId == 528 && type.isRadarType() || objectId == 528 || objectId == 528 && !isHoriz || objectId == 528 && isHoriz && PlaceUtilities.isRotated45(p, id) || objectId == 685 && !isHoriz || objectId == 695 && !isHoriz || objectId == 514 && !isHoriz && PlaceUtilities.isRotated45(p, id) || objectId == 514 && isHoriz || objectId == 524 && isHoriz || objectId == 524 && PlaceUtilities.isRotated90(p, id) || objectId == 514 && isHoriz || objectId == 514 && PlaceUtilities.isRotated90(p, id) || objectId == 518 && !PlaceUtilities.isRotated90or270(p, id) && !isHoriz) {
            just = 2;
        }
        PlaceUtilities.alignIfOK(p, id, just);
    }

    private static boolean useGroup(Perspective p, IdentObj id) {
        boolean useGroup = true;
        if (Identity.LegendText.getObjectID() == id.getObjectID() || Identity.O2Label.getObjectID() == id.getObjectID() || Identity.Y1Label.getObjectID() == id.getObjectID() || Identity.Y2Label.getObjectID() == id.getObjectID() || Identity.Y3Label.getObjectID() == id.getObjectID() || Identity.Y4Label.getObjectID() == id.getObjectID() || Identity.Y5Label.getObjectID() == id.getObjectID()) {
            useGroup = false;
        }
        return useGroup;
    }

    public static boolean truncateText(Perspective p, IdentObj id) {
        int truncationCount = p.getPlaceTruncateCount(id);
        return PlaceUtilities.truncateText(p, id, truncationCount);
    }

    public static boolean truncateText(Perspective p, IdentObj id, int truncationCount) {
        boolean isTitle;
        boolean hadToTruncate = false;
        if (truncationCount < 3) {
            return hadToTruncate;
        }
        boolean bl = isTitle = PlaceUtilities.isAxisTitle(id) || PlaceUtilities.isChartTitle(id);
        if (isTitle) {
            String text = p.getTextString(id);
            int numChars = text.length();
            if (numChars > truncationCount && numChars > 3) {
                String truncText = text.substring(0, truncationCount - 3);
                truncText = truncText.concat(TRUNCATED_SUFFIX);
                p.setTextString(id, truncText);
                hadToTruncate = true;
            }
        } else {
            boolean useGroup = PlaceUtilities.useGroup(p, id);
            int numLabels = useGroup ? p.getNumGroups() : p.getNumSeries();
            for (int i = 0; i < numLabels; ++i) {
                String text = useGroup ? p.getGroupLabel(i) : p.getSeriesLabel(i);
                int numChars = text.length();
                if (numChars <= truncationCount || numChars <= 3) continue;
                String truncText = text.substring(0, truncationCount - 3);
                truncText = truncText.concat(TRUNCATED_SUFFIX);
                if (useGroup) {
                    p.setGroupLabel(i, truncText);
                } else {
                    p.setSeriesLabel(i, truncText);
                }
                hadToTruncate = true;
            }
        }
        return hadToTruncate;
    }

    public static boolean containsALongWord(Perspective p, IdentObj id) {
        boolean containsALongWord = false;
        boolean useGroup = PlaceUtilities.useGroup(p, id);
        int numLabels = useGroup ? p.getNumGroups() : p.getNumSeries();
        for (int i = 0; i < numLabels; ++i) {
            String text;
            String string = text = useGroup ? p.getGroupLabel(i) : p.getSeriesLabel(i);
            if (PlaceUtilities.getLongestWordLength(text) <= 12) continue;
            containsALongWord = true;
            break;
        }
        return containsALongWord;
    }

    public static Dimension getDimLargestLabelVC(Perspective p, IdentObj id) {
        return PlaceUtilities.getDimLargestLabelVC(p, id, 32000);
    }

    public static Dimension getDimLargestLabelVC(Perspective p, IdentObj id, int maxWidth) {
        boolean isLegendText;
        Dimension d = new Dimension(0, 0);
        Dimension dMax = new Dimension(0, 0);
        JGraphType gt = p.getJGraphType();
        boolean isTitle = PlaceUtilities.isAxisTitle(id) || PlaceUtilities.isChartTitle(id);
        boolean bl = isLegendText = id.getObjectID() == Identity.LegendText.getObjectID();
        if (isTitle) {
            dMax = PlaceUtilities.getTextDim(p, id, p.getTextString(id));
        } else if (isLegendText) {
            int numLegendItems = LegendMarkersLabels.getNumLabels(p);
            ITextStyle labelTextStyle = TextStyleObjFactory.newTextStyleObj(p, id);
            for (int i = 0; i < numLegendItems; ++i) {
                String strLabel = LegendMarkersLabels.getLabel(p, i);
                d = PlaceUtilities.getTextDim(p, id, strLabel, maxWidth, labelTextStyle);
                if (d.width > dMax.width) {
                    dMax.width = d.width;
                }
                if (d.height <= dMax.height) continue;
                dMax.height = d.height;
            }
        } else if (id.getObjectID() == 524 && gt.isScatter()) {
            PlaceUtilities.calc(p);
            INumericAxis axis = (INumericAxis)AxisUtils.getAxisObj(p, 524);
            List<String> labelList = axis.getNumericLabels();
            ITextStyle labelTextStyle = TextStyleObjFactory.newTextStyleObj(p, id);
            for (String strLabel : labelList) {
                d = PlaceUtilities.getTextDim(p, id, strLabel, maxWidth, labelTextStyle);
                if (d.width > dMax.width) {
                    dMax.width = d.width;
                }
                if (d.height <= dMax.height) continue;
                dMax.height = d.height;
            }
        } else if (id.getObjectID() == 528 || id.getObjectID() == 532 || id.getObjectID() == 685 || id.getObjectID() == 690 || id.getObjectID() == 695) {
            INumericAxis axis = (INumericAxis)AxisUtils.getAxisObj(p, id.getObjectID());
            if (axis != null) {
                List<String> labelList = axis.getNumericLabels();
                m_logger.warn((Object)"Warning: this code path in PDE leads to inaccurate formatting. Fix me");
                ITextStyle labelTextStyle = TextStyleObjFactory.newTextStyleObj(p, id);
                for (String strLabel : labelList) {
                    d = PlaceUtilities.getTextDim(p, id, strLabel, maxWidth, labelTextStyle);
                    if (d.width > dMax.width) {
                        dMax.width = d.width;
                    }
                    if (d.height <= dMax.height) continue;
                    dMax.height = d.height;
                }
            }
        } else {
            boolean useGroup = PlaceUtilities.useGroup(p, id);
            int numLabels = useGroup ? p.getNumGroups() : p.getNumSeries();
            ITextStyle labelTextStyle = TextStyleObjFactory.newTextStyleObj(p, id);
            for (int i = 0; i < numLabels; ++i) {
                String strLabel = useGroup ? p.getGroupLabel(i) : p.getSeriesLabel(i);
                d = PlaceUtilities.getTextDim(p, id, strLabel, maxWidth, labelTextStyle);
                if (d.width > dMax.width) {
                    dMax.width = d.width;
                }
                if (d.height <= dMax.height) continue;
                dMax.height = d.height;
            }
        }
        if (p.getTextRotation(id) == 3) {
            int maxLen = Math.max(dMax.width, dMax.height);
            dMax.width = maxLen + 1;
            dMax.height = maxLen + 1;
        }
        return dMax;
    }

    public static Dimension getTextDim(Perspective p, IdentObj id, String text) {
        ITextStyle labelTextStyle = TextStyleObjFactory.newTextStyleObj(p, id);
        return PlaceUtilities.getTextDim(p, id, text, 32000, labelTextStyle);
    }

    public static Dimension getTextDim(Perspective p, IdentObj id, String text, ITextStyle labelTextStyle) {
        return PlaceUtilities.getTextDim(p, id, text, 32000, labelTextStyle);
    }

    public static Dimension getTextDim(Perspective p, IdentObj id, String text, int maxWidth) {
        ITextStyle labelTextStyle = TextStyleObjFactory.newTextStyleObj(p, id);
        return PlaceUtilities.getTextDim(p, id, text, maxWidth, labelTextStyle);
    }

    public static Dimension getTextDim(Perspective p, IdentObj id, String text, int maxWidth, ITextStyle labelTextStyle) {
        Dimension dimMaxVC = new Dimension(maxWidth, 32000);
        Dimension dimMaxDC = p.getVC().virtToDest(dimMaxVC);
        int angle = p.getTextRotation(id);
        double nFontSizeHeightDC = TextUtil.getFontSizeHeightDC(p, id);
        boolean bWordWrap = labelTextStyle.getWordWrap();
        Dimension dimLabelDC = labelTextStyle.getTextSizeDC(text, nFontSizeHeightDC, dimMaxDC, null, bWordWrap);
        Dimension d = new Dimension(0, 0);
        if (angle == 3) {
            int maxLen = Math.max(dimLabelDC.width, dimLabelDC.height);
            dimLabelDC.width = maxLen + 1;
            dimLabelDC.height = maxLen + 1;
        }
        if (angle == 1 || angle == 2) {
            d.width = p.getVC().destToVirtHeight(dimLabelDC.width);
            d.height = p.getVC().destToVirtWidth(dimLabelDC.height);
        } else {
            d = p.getVC().destToVirt(dimLabelDC);
        }
        return d;
    }

    public static void setAvailableSpace(Perspective perspective, Rectangle rAvailableSpace) {
        JChart_Base chart = perspective.getGraphObject();
        chart.setAvailableSpace(new Rectangle(rAvailableSpace));
    }

    public static void calc(Perspective p, boolean suppressLabelDrawing) {
        p.suppressLabelDrawing(suppressLabelDrawing);
        PlaceUtilities.calc(p);
        p.suppressLabelDrawing(false);
    }

    public static void calc(Perspective p) {
        JChart_Base chart = p.getGraphObject();
        assert (chart != null);
        p.setPDECalc(true);
        ((Detectiv)p.getDetectiv()).resetList();
        chart.calc();
        p.setPDECalc(false);
    }

    public static void legendCalc(Perspective p) {
        JChart_Base chart = p.getGraphObject();
        p.setPDECalc(true);
        ((Detectiv)p.getDetectiv()).resetList();
        chart.calcLegend();
        p.setPDECalc(false);
    }

    public static void axisCalc(Perspective p, int whichAxis, Rectangle frame) {
        IAxis axis = AxisUtils.getAxisObj(p, whichAxis);
        if (axis != null) {
            p.setPDECalc(true);
            ((Detectiv)p.getDetectiv()).resetList();
            axis.pdeCalc(frame);
            p.setPDECalc(false);
        }
    }

    public static Dimension getAxisMaxSize(Perspective p, int whichAxis, boolean reCalc, Rectangle frame) {
        Dimension d = new Dimension(0, 0);
        IAxis axis = AxisUtils.getAxisObj(p, whichAxis);
        if (axis != null) {
            if (reCalc) {
                PlaceUtilities.axisCalc(p, whichAxis, frame);
            }
            if (axis.isNumericAxis() && !(axis instanceof IAxis2D)) {
                d = PlaceUtilities.getDimLargestLabelVC(p, new IdentObj(whichAxis));
            } else {
                Rectangle r = axis.getLabelBoundingBoxVC();
                d = r.getSize();
            }
        }
        return d;
    }

    public static final boolean isChartTitle(IdentObj id) {
        boolean isTitle = false;
        if (id.getObjectID() == 5 || id.getObjectID() == 4 || id.getObjectID() == 3) {
            isTitle = true;
        }
        return isTitle;
    }

    public static final boolean isAxisTitle(IdentObj id) {
        boolean isTitle = false;
        if (id.getObjectID() == 6 || id.getObjectID() == 6 || id.getObjectID() == 7 || id.getObjectID() == 67 || id.getObjectID() == 69 || id.getObjectID() == 71 || id.getObjectID() == 8 || id.getObjectID() == 9 || id.getObjectID() == 10 || id.getObjectID() == 11) {
            isTitle = true;
        }
        return isTitle;
    }

    public static final void shrinkToFit(Perspective p, IdentObj id) {
        JChart_Base chart = p.getGraphObject();
        PlaceUtilities.calc(p);
        PlaceUtilities.legendCalc(p);
        boolean isPie = chart instanceof JChart_2D_Pie;
        Dimension largestLabel = PlaceUtilities.getDimLargestLabelVC(p, id);
        int fontSize = p.getFontSizeVC(id);
        IAxis axis = AxisUtils.getAxisObj(p, id.getObjectID());
        int len = 32000;
        if (axis != null) {
            PlaceUtilities.axisCalc(p, id.getObjectID(), null);
            len = p.getTextRotation(id) == 0 ? axis.getMaxLabelSize() : (len /= 4);
        } else if (isPie) {
            JChart_2D_Pie pie = (JChart_2D_Pie)chart;
            len = pie.getTitleWidth();
        } else if (id.getObjectID() != 14) {
            if (PlaceUtilities.isChartTitle(id)) {
                len = p.getRect((IdentObj)id).width;
            } else if (PlaceUtilities.isAxisTitle(id)) {
                len = p.getRect((IdentObj)id).width;
            }
        }
        while (len < largestLabel.width && fontSize >= 500) {
            p.setFontSizeVC(id, fontSize -= 50);
            if (axis != null) {
                PlaceUtilities.axisCalc(p, id.getObjectID(), null);
            } else if (isPie) {
                ((JChart_2D_Pie)chart).calc();
            }
            largestLabel = PlaceUtilities.getDimLargestLabelVC(p, id);
        }
    }

    public static int getFontSize(Perspective p, IdentObj id) {
        int objId = id.getObjectID();
        int fontSize = 1000;
        int rotationFactor = 1;
        int angle = p.getTextRotation(id);
        if (angle == 1 || angle == 2) {
            rotationFactor = 5;
        } else if (angle > 2) {
            rotationFactor = 3;
        }
        if (Identity.O1Label.getObjectID() == objId) {
            if (p.getNumGroups() > 9 * rotationFactor) {
                fontSize = 600;
            } else if (p.getNumGroups() > 6 * rotationFactor) {
                fontSize = 800;
            } else if (PlaceUtilities.containsALongWord(p, id)) {
                fontSize = 600;
            }
        } else if (Identity.O2Label.getObjectID() == objId) {
            if (p.getNumSeries() > 9 * rotationFactor) {
                fontSize = 600;
            } else if (p.getNumSeries() > 6 * rotationFactor) {
                fontSize = 800;
            } else if (PlaceUtilities.containsALongWord(p, id)) {
                fontSize = 600;
            }
        } else if (Identity.Title.getObjectID() == objId) {
            fontSize = 1539;
        } else if (Identity.Subtitle.getObjectID() == objId) {
            fontSize = 1099;
        } else if (Identity.Footnote.getObjectID() == objId) {
            fontSize = 1099;
        }
        return fontSize;
    }

    public static final void setAxisTitleRectIfOK(Perspective p, IdentObj id, Rectangle r) {
        p.setRect(id, r);
    }

    public static void setChartFrame(Perspective p, Rectangle newFrame) {
        IdentObj frameID = p.isChartPieType() ? Identity.PieFrame : Identity.Frame;
        p.setFullFrame(frameID, newFrame);
    }

    public static Rectangle getPlaceResizeFrame(Perspective p, Rectangle maximizedFrame, Rectangle desiredFrame) {
        PlaceMode frameResizeMode = p.getPlaceResize(p.getCurrentFrame());
        if (frameResizeMode == PlaceMode.SEMI_AUTO) {
            Rectangle newFrame = maximizedFrame.intersection(desiredFrame);
            newFrame.height = Math.max(newFrame.height, PlaceDefaultElements.MIN_FRAME_DIMENSION_VC);
            newFrame.width = Math.max(newFrame.width, PlaceDefaultElements.MIN_FRAME_DIMENSION_VC);
            return newFrame;
        }
        if (frameResizeMode == PlaceMode.FULL_AUTO) {
            return maximizedFrame;
        }
        if (frameResizeMode == PlaceMode.MANUAL) {
            return desiredFrame;
        }
        return maximizedFrame;
    }
}

