/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.SphereView;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint.SpherePaintContext;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

public class SpherePaint
implements Paint {
    private Color color1;
    private Color color2;
    private SphereView sphereView;
    private Rectangle2D.Float bounds;
    private int transparency;

    public Color getCenterColor() {
        return this.color1;
    }

    public Color getBoundaryColor() {
        return this.color2;
    }

    public Rectangle2D getBounds() {
        return (Rectangle2D)this.bounds.clone();
    }

    public SpherePaint(Rectangle2D rect, Color color1, Color color2, SphereView sphereView) {
        this.color1 = color1;
        this.color2 = color2;
        this.bounds = new Rectangle2D.Float();
        this.bounds.setRect((float)rect.getX(), (float)rect.getY(), (float)rect.getWidth(), (float)rect.getHeight());
        this.sphereView = sphereView;
        int a1 = color1.getAlpha();
        int a2 = color2.getAlpha();
        this.transparency = (a1 & a2) == 255 ? 1 : 3;
    }

    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform transform, RenderingHints hints) {
        try {
            return new SpherePaintContext(this.bounds, this.color1, this.color2, this.sphereView, transform);
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException("transform should be invertible");
        }
    }

    public int getTransparency() {
        return this.transparency;
    }
}

