/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.model3d;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ExceptionalRiser;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IDrawContainer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Matrix4d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.Cone3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.ConeTessellated;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.ConeView;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.ListOfLayersComposition;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.Shape_Layer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.model3d.Model3DShape;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.Iterator;

public final class Model3DCone
extends Model3DShape {
    public static final int FRONT = 0;
    public static final int LEFT = 1;
    public static final int TOP = 2;
    public static final int BACK = 3;
    public static final int RIGHT = 4;
    public static final int BOTTOM = 5;
    private Point3d m_origin;
    private Point3d m_bottomCenter;
    private Point3d m_size;
    private boolean m_bCylinder;
    private JChart_3D m_chart;
    private IdentObj m_id;
    private boolean m_bAutoshading;
    private boolean m_bCanUseSimpleVisibility;
    private double m_distance;
    private boolean[][] m_bGridStatus;
    private ConeView m_coneView;
    public ConeTessellated m_blackBoxFactory = new ConeTessellated();

    public Model3DCone(JChart_3D chart, IdentObj id, IBlackBox bb, Point3d origin, Point3d size, boolean[][] bGridStatus, boolean bAutoshading, boolean bCanUseSimpleVisibility, boolean isCylinder) {
        this.m_origin = new Point3d(origin);
        this.m_size = new Point3d(size);
        this.m_chart = chart;
        this.m_id = id;
        IBlackBox bbExceptionalRiser = ExceptionalRiser.createExceptionBlackBox(this.m_chart.getPerspective(), id, bb);
        this.m_blackBoxFactory.setBlackBox(bbExceptionalRiser);
        this.m_bGridStatus = bGridStatus;
        this.m_bAutoshading = bAutoshading;
        this.m_bCanUseSimpleVisibility = bCanUseSimpleVisibility;
        double radius = 0.5 * Math.min(Math.abs(size.x), Math.abs(size.z));
        double height = size.y;
        Cone3D cone = null;
        cone = isCylinder ? new Cone3D(radius, radius, height) : new Cone3D(radius, 0.0, height);
        this.m_bCylinder = isCylinder;
        Point3d bottomCenter = new Point3d(origin.x + size.x / 2.0, origin.y, origin.z + size.z / 2.0);
        this.m_coneView = new ConeView(cone, chart, bottomCenter);
        this.m_bottomCenter = bottomCenter;
    }

    public Model3DCone(Model3DCone model) {
        this(model.m_chart, model.m_id, model.getBlackBox(), model.m_origin, model.m_size, model.m_bGridStatus, model.m_bAutoshading, model.m_bCanUseSimpleVisibility, model.m_bCylinder);
        this.m_distance = model.m_distance;
    }

    public IdentObj getIdentObj() {
        return this.m_id;
    }

    public Point2D.Double getPosition(Matrix4d matrix, int nDataTextPosition) throws UnsupportedOperationException {
        switch (nDataTextPosition) {
            default: 
        }
        throw new UnsupportedOperationException("NYI for data text position " + nDataTextPosition);
    }

    public void calcDistance(Matrix4d matrix, Point3d viewer) {
        Point3d center = this.getCenter();
        this.transformPoint3d(center, matrix);
        double dist2 = (viewer.x - center.x) * (viewer.x - center.x) + (viewer.y - center.y) * (viewer.y - center.y) + (viewer.z - center.z) * (viewer.z - center.z);
        this.m_distance = Math.sqrt(dist2);
    }

    IBlackBox getBlackBox() {
        return this.m_blackBoxFactory.getBlackBox();
    }

    public double getDistance() {
        return this.m_distance;
    }

    public Point3d getCenter() {
        return new Point3d(this.m_bottomCenter);
    }

    protected Point3d getGridLineEnd(int nAxis, int nFace, double d) {
        throw new UnsupportedOperationException();
    }

    protected Point3d getGridLineStart(int nAxis, int nFace, double d) {
        throw new UnsupportedOperationException();
    }

    public double getMinZ() {
        double fMinZ = -1.7976931348623157E308;
        Point3d[] vertices = this.m_coneView.getVertices();
        for (int i = 0; i < vertices.length; ++i) {
            double fZ = vertices[i].z;
            if (!(fZ > fMinZ)) continue;
            fMinZ = fZ;
        }
        return fMinZ;
    }

    public ListOfLayersComposition getComposition() {
        this.m_blackBoxFactory.setConeView(this.m_coneView);
        return this.m_blackBoxFactory.build();
    }

    public boolean isVisibleIpsoFacto(int f) {
        return this.m_coneView != null && this.m_coneView.isVisible();
    }

    public void display() {
        ListOfLayersComposition cmp = this.getComposition();
        IBlackBox bb = this.m_blackBoxFactory.getBlackBox();
        IDrawContainer det = this.m_chart.getDrawContainer();
        Iterator<Shape_Layer> it = cmp.iterator();
        while (it.hasNext()) {
            Shape_Layer layer = it.next();
            Shape shape = layer.getShape();
            DrawFactory.createShape(det, this.m_id, shape, bb, null, layer.getRenderer());
        }
    }
}

