/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxRenderer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;

public class StrokeRenderer
implements BlackBoxRenderer {
    private static final Rectangle rect = new Rectangle(0, 0, 1, 1);
    private Paint strokePaint;
    private Dimension2D margins;
    private Stroke stroke;

    public StrokeRenderer(Paint strokePaint, double strokeWidth) {
        this(strokePaint, new BasicStroke((float)strokeWidth));
    }

    public StrokeRenderer(Paint strokePaint, Stroke stroke) {
        if (strokePaint == null || stroke == null) {
            throw new IllegalArgumentException();
        }
        this.strokePaint = strokePaint;
        this.stroke = stroke;
        Shape strokedRect = stroke.createStrokedShape(rect);
        Rectangle2D rect = strokedRect.getBounds2D();
        this.margins = new Dimension((int)(rect.getWidth() - (double)StrokeRenderer.rect.width), (int)(rect.getHeight() - (double)StrokeRenderer.rect.height));
        if (this.margins.getWidth() < 0.0) {
            this.margins.setSize(0.0, this.margins.getHeight());
        }
        if (this.margins.getHeight() < 0.0) {
            this.margins.setSize(this.margins.getWidth(), 0.0);
        }
    }

    public Dimension2D getMargins() {
        return (Dimension2D)this.margins.clone();
    }

    public void render(Graphics2D g, Shape shape) {
        g.setStroke(this.stroke);
        g.setPaint(this.strokePaint);
        g.draw(shape);
    }

    public void updateFrom(IBlackBox bb) {
    }
}

