/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxRenderer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;

class ScaledRenderer
implements BlackBoxRenderer {
    private BlackBoxRenderer m_originalRenderer;

    ScaledRenderer(BlackBoxRenderer renderer) {
        this.m_originalRenderer = renderer;
    }

    public void render(Graphics2D g, Shape shape) {
        double scaleY;
        AffineTransform trans0 = g.getTransform();
        double scaleX = Math.abs(trans0.getScaleX());
        if (FP.equal(scaleX, scaleY = Math.abs(trans0.getScaleY()))) {
            this.m_originalRenderer.render(g, shape);
        } else {
            Rectangle rect = shape.getBounds();
            double x0 = (double)rect.x + 0.5 * (double)rect.width;
            double y0 = (double)rect.y + 0.5 * (double)rect.height;
            double fX = scaleX < scaleY ? 1.0 : scaleY / scaleX;
            double fY = scaleX < scaleY ? scaleX / scaleY : 1.0;
            AffineTransform scaleTrans = new AffineTransform(fX, 0.0, 0.0, fY, x0 - fX * x0, y0 - fY * y0);
            boolean isOK = FP.nonzero(fX * fY);
            if (isOK) {
                scaleTrans.preConcatenate(trans0);
                g.setTransform(scaleTrans);
            }
            this.m_originalRenderer.render(g, shape);
            g.setTransform(trans0);
        }
    }

    public void updateFrom(IBlackBox bb) {
        this.m_originalRenderer.updateFrom(bb);
    }

    public Dimension2D getMargins() {
        return this.m_originalRenderer.getMargins();
    }
}

