/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.Interpolation2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom.ConeView;

public class Cone3D {
    private boolean isTruncated = false;
    private double fBottomRadius;
    private double fTopRadius;
    private double fHeight;
    private double fCenterY;
    private double fTanOfConeAngle;
    private Point3d[] bottomPoints = null;
    private Point3d[] topPoints = null;

    public Cone3D(double bottomRadius, double topRadius, double height) {
        this(bottomRadius, topRadius, height, Interpolation2D.getDefaultPointsCount());
    }

    public Cone3D(double bottomRadius, double topRadius, double height, int nPointsLength) {
        if (topRadius < 0.0 || bottomRadius < topRadius) {
            throw new IllegalArgumentException("bottom radius is smaller than top radius of the cone");
        }
        this.fBottomRadius = bottomRadius;
        this.fTopRadius = topRadius;
        this.fHeight = height;
        this.isTruncated = topRadius > ConeView.EPSILON;
        Point3d[] bottomPoint = new Point3d[nPointsLength];
        Cone3D.calcCirclePoints(bottomRadius, 0.0, bottomPoint);
        int nTopLength = this.isTruncated ? nPointsLength : 1;
        Point3d[] topPoint = new Point3d[nTopLength];
        Cone3D.calcCirclePoints(topRadius, height, topPoint);
        this.topPoints = topPoint;
        this.bottomPoints = bottomPoint;
        double fDiff = bottomRadius - topRadius;
        double tangens = fDiff / this.fHeight;
        if (this.fHeight == 0.0) {
            this.fCenterY = Double.POSITIVE_INFINITY;
            this.fTanOfConeAngle = 0.0;
        } else if (Math.abs(tangens) < ConeView.EPSILON) {
            this.fCenterY = this.fHeight >= 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            this.fTanOfConeAngle = 0.0;
        } else {
            this.fCenterY = this.fBottomRadius / tangens;
            this.fTanOfConeAngle = tangens;
        }
    }

    public final boolean isTruncated() {
        return this.isTruncated;
    }

    public final double getBottomRadius() {
        return this.fBottomRadius;
    }

    public final double getTopRadius() {
        return this.fTopRadius;
    }

    public final double getHeight() {
        return this.fHeight;
    }

    public final double getCenterY() {
        return this.fCenterY;
    }

    public final double getTanOfConeAngle() {
        return this.fTanOfConeAngle;
    }

    public final Point3d[] getBottomPoints() {
        int nLen = this.bottomPoints.length;
        Point3d[] points = new Point3d[nLen];
        for (int i = 0; i < nLen; ++i) {
            points[i] = new Point3d(this.bottomPoints[i]);
        }
        return points;
    }

    public final Point3d[] getTopPoints() {
        int nLen = this.topPoints.length;
        Point3d[] points = new Point3d[nLen];
        for (int i = 0; i < nLen; ++i) {
            points[i] = new Point3d(this.topPoints[i]);
        }
        return points;
    }

    static void calcCirclePoints(double fCircleRadius, double fHeight, Point3d[] points) {
        int nPointsLength = points.length;
        double FULL_ANGLE = Math.PI * 2;
        double deltaAngle = FULL_ANGLE / (double)nPointsLength;
        double angle = 0.0;
        double xx = fCircleRadius;
        double zz = 0.0;
        points[0] = new Point3d(xx, 0.0, zz);
        for (int i = 1; i <= nPointsLength / 2; ++i) {
            xx = fCircleRadius * Math.cos(angle += deltaAngle);
            zz = fCircleRadius * Math.sin(angle);
            if (i >= points.length) {
                System.out.println("STOP");
            }
            points[i] = new Point3d(xx, 0.0, zz);
            points[nPointsLength - i] = new Point3d(xx, 0.0, -zz);
        }
        Point3d point = null;
        for (int i = 0; i < nPointsLength; ++i) {
            point = points[i];
            point.y = fHeight;
        }
    }

    private static Point3d calcControlPoint(Point3d p1, Point3d p2, double fRadius) {
        double zz;
        double xx;
        if (fRadius < ConeView.EPSILON) {
            return null;
        }
        if (Math.abs(p1.x - p2.x) < ConeView.EPSILON) {
            xx = fRadius * fRadius / p1.x;
            zz = 0.0;
        } else {
            double kk = (p1.x - p2.x) / (p1.z - p2.z);
            xx = fRadius * fRadius / (p2.x - kk * p2.z);
            zz = -kk * xx;
        }
        if (Double.isNaN(xx)) {
            return null;
        }
        return new Point3d(xx, 0.0, zz);
    }

    public static void test1() {
        Point3d p1 = new Point3d(0.0, 0.0, 2.0);
        Point3d p2 = new Point3d(2.0, 0.0, 0.0);
        Point3d p = Cone3D.calcControlPoint(p1, p2, 2.0);
        System.out.println(" (2,0,2)  ? = " + p);
        p1 = new Point3d(2.0, 0.0, 0.0);
        double sq = Math.sqrt(2.0);
        p2 = new Point3d(sq, 0.0, sq);
        p = Cone3D.calcControlPoint(p1, p2, 2.0);
        System.out.println(" (2,0,0.828)  ? = " + p);
        p2 = new Point3d(1.0, 0.0, Math.sqrt(3.0));
        p = Cone3D.calcControlPoint(p1, p2, 2.0);
        System.out.println(" (2,0,1.155)  ? = " + p);
    }
}

