/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Model3DFlatFace;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Model3DOctagonSolid;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;

public class Model3DCutCorner
extends Model3DFlatFace {
    public static final int LEFT = 0;
    public static final int LEFT_FRONT = 1;
    public static final int FRONT = 2;
    public static final int RIGHT_FRONT = 3;
    public static final int RIGHT = 4;
    public static final int RIGHT_BACK = 5;
    public static final int BACK = 6;
    public static final int LEFT_BACK = 7;
    public static final int TOP = 8;
    public static final int BOTTOM = 9;
    protected Point3d m_origin;
    protected Point3d m_size;
    private static final int[][] m_myfaces = new int[][]{{0, 1, 6, 5}, {1, 2, 7, 6}, {2, 3, 8, 7}, {3, 4, 9, 8}, {4, 0, 5, 9}, {5, 6, 7, 8, 9}, {4, 3, 2, 1, 0}};

    public Model3DCutCorner(JChart_3D chart, IdentObj id, IBlackBox bb, Point3d origin, Point3d size, boolean[][] bGridStatus, boolean bAutoshading) {
        super(chart, id, bb, 7, 10, bGridStatus, bAutoshading);
        double farX = size.x * 0.65;
        double farZ = size.z * 0.65;
        this.m_origin = new Point3d(origin);
        this.m_size = new Point3d(size);
        this.m_faces = m_myfaces;
        for (int i = 0; i < this.m_nVertices; ++i) {
            this.m_vertices[i] = new Point3d(origin);
            if (i <= 4) continue;
            this.m_vertices[i].y += this.m_size.y;
        }
        this.m_vertices[1].z += this.m_size.z;
        this.m_vertices[2].x += farX;
        this.m_vertices[2].z += this.m_size.z;
        this.m_vertices[3].x += this.m_size.x;
        this.m_vertices[3].z += farZ;
        this.m_vertices[4].x += this.m_size.x;
        this.m_vertices[6].z += this.m_size.z;
        this.m_vertices[7].x += farX;
        this.m_vertices[7].z += this.m_size.z;
        this.m_vertices[8].x += this.m_size.x;
        this.m_vertices[8].z += farZ;
        this.m_vertices[9].x += this.m_size.x;
    }

    public Model3DCutCorner(Model3DOctagonSolid model) {
        this(model.m_chart, model.m_id, model.m_bb, model.m_origin, model.m_size, model.m_bGridStatus, model.m_bAutoshading);
        this.m_distance = model.m_distance;
    }

    public Point3d getCenter() {
        return new Point3d(this.m_origin.x + this.m_size.x / 2.0, this.m_origin.y + this.m_size.y / 2.0, this.m_origin.z + this.m_size.z / 2.0);
    }

    public Point3d getGridLineEnd(int nAxis, int nFace, double d) {
        switch (nAxis) {
            case 1: {
                switch (nFace) {
                    case 0: {
                        return new Point3d(this.m_vertices[1].x, d, this.m_vertices[1].z);
                    }
                    case 1: {
                        return new Point3d(this.m_vertices[2].x, d, this.m_vertices[2].z);
                    }
                    case 2: {
                        return new Point3d(this.m_vertices[3].x, d, this.m_vertices[3].z);
                    }
                    case 3: {
                        return new Point3d(this.m_vertices[4].x, d, this.m_vertices[4].z);
                    }
                    case 4: {
                        return new Point3d(this.m_vertices[5].x, d, this.m_vertices[5].z);
                    }
                    case 5: {
                        return new Point3d(this.m_vertices[6].x, d, this.m_vertices[6].z);
                    }
                    case 6: {
                        return new Point3d(this.m_vertices[7].x, d, this.m_vertices[7].z);
                    }
                    case 7: {
                        return new Point3d(this.m_vertices[8].x, d, this.m_vertices[8].z);
                    }
                }
            }
        }
        return null;
    }

    public Point3d getGridLineStart(int nAxis, int nFace, double d) {
        switch (nAxis) {
            case 1: {
                switch (nFace) {
                    case 0: {
                        return new Point3d(this.m_vertices[0].x, d, this.m_vertices[0].z);
                    }
                    case 1: {
                        return new Point3d(this.m_vertices[1].x, d, this.m_vertices[1].z);
                    }
                    case 2: {
                        return new Point3d(this.m_vertices[2].x, d, this.m_vertices[2].z);
                    }
                    case 3: {
                        return new Point3d(this.m_vertices[3].x, d, this.m_vertices[3].z);
                    }
                    case 4: {
                        return new Point3d(this.m_vertices[4].x, d, this.m_vertices[4].z);
                    }
                    case 5: {
                        return new Point3d(this.m_vertices[5].x, d, this.m_vertices[5].z);
                    }
                    case 6: {
                        return new Point3d(this.m_vertices[6].x, d, this.m_vertices[6].z);
                    }
                    case 7: {
                        return new Point3d(this.m_vertices[7].x, d, this.m_vertices[7].z);
                    }
                }
            }
        }
        return null;
    }

    public int getNumPtsPerFace(int f) {
        if (f == 8 || f == 9) {
            return 5;
        }
        return 4;
    }
}

