/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.math;

import java.awt.geom.Point2D;

public class Jet_2D
extends Point2D.Float {
    private Point2D.Float m_point = null;
    private Point2D.Float m_jet = null;

    private Jet_2D() {
    }

    public Jet_2D(Point2D.Float point, Point2D.Float jet) {
        this.m_point = point == null ? new Point2D.Float() : point;
        float fNorm = jet == null ? 0.0f : (float)jet.distance(0.0, 0.0);
        this.m_jet = (double)fNorm == 0.0 ? new Point2D.Float(1.0f, 0.0f) : new Point2D.Float(jet.x / fNorm, jet.y / fNorm);
    }

    public Jet_2D(float x, float y, float z) {
        this.m_point = new Point2D.Float(x, y);
        this.setSlopeTan(z);
    }

    public final double getX() {
        return this.m_point.x;
    }

    public final double getY() {
        return this.m_point.y;
    }

    public void setLocation(float x, float y) {
        this.m_point.setLocation(x, y);
    }

    public void setSlopeTan(float z) {
        if (!Double.isInfinite(z)) {
            float fNorm = (float)Math.sqrt(1.0f + z * z);
            this.m_jet = new Point2D.Float(1.0f / fNorm, z / fNorm);
        } else {
            this.m_jet = (double)z == Double.NEGATIVE_INFINITY ? new Point2D.Float(0.0f, -1.0f) : new Point2D.Float(0.0f, 1.0f);
        }
    }

    public float getSlopeTan() {
        return this.m_jet.y / this.m_jet.x;
    }

    public float getSlopeSin() {
        return this.m_jet.y;
    }

    public Object clone() {
        Jet_2D jet = new Jet_2D();
        jet.m_point = new Point2D.Float(this.m_point.x, this.m_point.y);
        jet.m_jet = new Point2D.Float(this.m_jet.x, this.m_jet.y);
        return jet;
    }

    public int hashCode() {
        return this.m_point.hashCode() + 31 * this.m_jet.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Jet_2D)) {
            return false;
        }
        Jet_2D jet = (Jet_2D)obj;
        return jet.m_point.equals(this.m_point) && jet.m_jet.equals(this.m_jet);
    }
}

