/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JGraphType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

public class FrameObj {
    static final int SIDE_OFFSET = 100;
    static final int BOTTOM_OFFSET = 200;
    public static final int XDEPTH_OFFSET_RATIO = 3;
    Perspective m_Perspective;
    IdentObj m_id;
    Rectangle m_rect;
    private Polygon m_polySide;
    private Polygon m_polyBottom;
    private int m_depthAngle = 0;
    private int m_depthRadius = 0;
    private double m_dx = 0.0;
    private double m_dy = 0.0;

    public FrameObj(Perspective perspective) {
        assert (perspective != null);
        this.m_Perspective = perspective;
        this.m_id = new IdentObj(2);
        this.m_rect = null;
        this.m_polySide = null;
        this.m_polyBottom = null;
    }

    public void calc() {
        boolean bDrawWithDepth;
        JGraphType gt = this.m_Perspective.getJGraphType();
        this.m_rect = this.m_Perspective.getRect(this.m_id);
        this.m_depthAngle = this.m_Perspective.getDepthAngle();
        this.m_depthRadius = this.m_Perspective.getDepthRadius();
        if (this.m_depthAngle < 0 || this.m_depthAngle > 180 || this.m_depthRadius < 0 || this.m_depthRadius > 100) {
            this.m_depthRadius = 0;
        }
        if (!gt.wantDepthEffect()) {
            this.m_depthRadius = 0;
        }
        boolean bl = bDrawWithDepth = this.m_depthRadius > 0;
        if (bDrawWithDepth) {
            double r = 10 * this.m_depthRadius;
            this.m_dx = r * Math.cos((double)this.m_depthAngle * (Math.PI / 180));
            this.m_dy = r * Math.sin((double)this.m_depthAngle * (Math.PI / 180));
            if (this.m_depthAngle != 90 && FP.nonzero(this.m_dx)) {
                int xFrame = this.m_depthAngle < 90 ? this.m_rect.x : this.m_rect.x + this.m_rect.width;
                this.m_polySide = new Polygon();
                this.m_polySide.addPoint(xFrame, this.m_rect.y);
                this.m_polySide.addPoint(xFrame, this.m_rect.y + this.m_rect.height);
                this.m_polySide.addPoint(xFrame - (int)this.m_dx, this.m_rect.y + this.m_rect.height - (int)this.m_dy);
                this.m_polySide.addPoint(xFrame - (int)this.m_dx, this.m_rect.y - (int)this.m_dy);
                this.m_polySide.addPoint(xFrame, this.m_rect.y);
            }
            if (this.m_depthAngle != 0 && this.m_depthAngle != 180 && FP.nonzero(this.m_dy)) {
                this.m_polyBottom = new Polygon();
                this.m_polyBottom.addPoint(this.m_rect.x, this.m_rect.y);
                this.m_polyBottom.addPoint(this.m_rect.x + this.m_rect.width, this.m_rect.y);
                this.m_polyBottom.addPoint(this.m_rect.x + this.m_rect.width - (int)this.m_dx, this.m_rect.y - (int)this.m_dy);
                this.m_polyBottom.addPoint(this.m_rect.x - (int)this.m_dx, this.m_rect.y - (int)this.m_dy);
                this.m_polyBottom.addPoint(this.m_rect.x, this.m_rect.y);
            }
        }
        if (!(!this.m_Perspective.getFrameDisplay() || gt.isRadarType() || gt.isPolar() || gt.isFunnelType() || this.m_Perspective.getPDECalc())) {
            this.drawBackWall();
            if (bDrawWithDepth) {
                this.drawSideWall();
                this.drawBottomWall();
            }
        }
    }

    public void drawSeparator(boolean bHorz, double fSplit) {
        if (fSplit < 0.0 || fSplit > 1.0) {
            return;
        }
        IdentObj idSep = new IdentObj(17);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, idSep);
        double fLineWidth = this.m_Perspective.getLineWidth(Identity.FrameSeparator);
        Rectangle rFrame = new Rectangle(this.m_rect.x, this.m_rect.y, this.m_rect.width, this.m_rect.height);
        if (bHorz) {
            int x0 = (int)((double)rFrame.x + fSplit * (double)rFrame.width);
            int y0 = rFrame.y;
            if (this.m_depthRadius > 0) {
                Polygon polyVC = new Polygon();
                polyVC.addPoint(x0, y0);
                polyVC.addPoint(x0, y0 + rFrame.height);
                polyVC.addPoint(x0 - (int)this.m_dx, y0 + rFrame.height - (int)this.m_dy);
                polyVC.addPoint(x0 - (int)this.m_dx, y0 - (int)this.m_dy);
                polyVC.addPoint(x0, y0);
                DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), idSep, polyVC, (IBlackBox)blackBox, 1.0);
            } else {
                Java2DLine line2D = new Java2DLine(this.m_Perspective);
                line2D.createLine(idSep, idSep, x0, y0, x0, y0 + rFrame.height, blackBox, null, fLineWidth);
            }
        } else {
            int x0 = rFrame.x;
            int y0 = (int)((double)rFrame.y + fSplit * (double)rFrame.height);
            if (this.m_depthRadius > 0) {
                Polygon polyVC = new Polygon();
                polyVC.addPoint(x0, y0);
                polyVC.addPoint(x0 + rFrame.width, y0);
                polyVC.addPoint(x0 + rFrame.width - (int)this.m_dx, y0 - (int)this.m_dy);
                polyVC.addPoint(x0 - (int)this.m_dx, y0 - (int)this.m_dy);
                polyVC.addPoint(x0, y0);
                DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), idSep, polyVC, (IBlackBox)blackBox, 1.0);
            } else {
                Java2DLine line2D = new Java2DLine(this.m_Perspective);
                line2D.createLine(idSep, idSep, x0, y0, x0 + rFrame.width, y0, blackBox, null, fLineWidth);
            }
        }
    }

    public Rectangle getBackWallBounds() {
        return new Rectangle(this.m_rect.x, this.m_rect.y, this.m_rect.width, this.m_rect.height);
    }

    public Point getDepthOffset(double z) {
        if (z < 0.0) {
            z = 0.0;
        } else if (z > 1.0) {
            z = 1.0;
        }
        double dx = z * this.m_dx;
        double dy = z * this.m_dy;
        Point pt = new Point((int)dx, (int)dy);
        return pt;
    }

    public Rectangle getBottomEdge() {
        Rectangle r = this.m_rect.getBounds();
        if (this.m_depthRadius > 0 && this.m_polyBottom != null) {
            int width = r.width;
            r = this.m_polyBottom.getBounds();
            if (this.m_depthAngle > 90) {
                r.x = r.x + r.width - width;
            }
            r.width = width;
        }
        return r;
    }

    public Rectangle getLeftEdge() {
        Rectangle r = this.m_depthRadius > 0 && this.m_depthAngle < 90 && this.m_polySide != null ? this.m_polySide.getBounds() : this.m_rect.getBounds();
        return r;
    }

    public Rectangle getRightEdge() {
        Rectangle r = this.m_depthRadius > 0 && this.m_depthAngle > 90 && this.m_polySide != null ? this.m_polySide.getBounds() : this.m_rect.getBounds();
        return r;
    }

    public void drawFrameBorders(double fWidth) {
        int i;
        if (this.m_Perspective.getPDECalc()) {
            return;
        }
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, this.m_id);
        blackBox.setDropShadowOffsetDC(null);
        IdentObj newID = this.m_id;
        newID = this.m_id.changeMisc(1);
        Java2DLine line2D = new Java2DLine(this.m_Perspective);
        line2D.createLine(this.m_id, newID, this.m_rect.x, this.m_rect.y, this.m_rect.x + this.m_rect.width, this.m_rect.y, blackBox, null, fWidth);
        newID = this.m_id.changeMisc(2);
        line2D.createLine(this.m_id, newID, this.m_rect.x + this.m_rect.width, this.m_rect.y + this.m_rect.height, this.m_rect.x + this.m_rect.width, this.m_rect.y, blackBox, null, fWidth);
        newID = this.m_id.changeMisc(3);
        line2D.createLine(this.m_id, newID, this.m_rect.x, this.m_rect.y + this.m_rect.height, this.m_rect.x + this.m_rect.width, this.m_rect.y + this.m_rect.height, blackBox, null, fWidth);
        newID = this.m_id.changeMisc(4);
        line2D.createLine(this.m_id, newID, this.m_rect.x, this.m_rect.y, this.m_rect.x, this.m_rect.y + this.m_rect.height, blackBox, null, fWidth);
        if (this.m_depthAngle != 90 && FP.nonzero(this.m_dx)) {
            for (i = 0; i < this.m_polySide.npoints - 2; ++i) {
                newID = this.m_id.changeMisc(100 + i);
                line2D.createLine(this.m_id, newID, this.m_polySide.xpoints[i], this.m_polySide.ypoints[i], this.m_polySide.xpoints[i + 1], this.m_polySide.ypoints[i + 1], blackBox, null, 1.0);
            }
        }
        if (this.m_depthAngle != 0 && this.m_depthAngle != 180 && FP.nonzero(this.m_dy)) {
            for (i = 0; i < this.m_polyBottom.npoints - 2; ++i) {
                newID = this.m_id.changeMisc(200 + i);
                line2D.createLine(this.m_id, newID, this.m_polyBottom.xpoints[i], this.m_polyBottom.ypoints[i], this.m_polyBottom.xpoints[i + 1], this.m_polyBottom.ypoints[i + 1], blackBox, null, 1.0);
            }
        }
    }

    private void drawBackWall() {
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, this.m_id);
        DrawFactory.createRectangle(this.m_Perspective.getDetectiv(), this.m_id, this.m_rect.x, this.m_rect.y, this.m_rect.width, this.m_rect.height, blackBox, null);
    }

    private void drawSideWall() {
        if (this.m_depthAngle != 90 && FP.nonzero(this.m_dx)) {
            IdentObj idSide = new IdentObj(15);
            BlackBoxObj blackBoxSide = new BlackBoxObj(this.m_Perspective, idSide);
            DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), idSide, this.m_polySide, (IBlackBox)blackBoxSide, 1.0);
        }
    }

    private void drawBottomWall() {
        if (this.m_depthAngle != 0 && this.m_depthAngle != 180 && FP.nonzero(this.m_dy)) {
            IdentObj idBottom = new IdentObj(16);
            BlackBoxObj blackBoxBottom = new BlackBoxObj(this.m_Perspective, idBottom);
            DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), idBottom, this.m_polyBottom, (IBlackBox)blackBoxBottom, 1.0);
        }
    }
}

