/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.common.FontCache;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.FontInfoObj;
import com.pietjonas.wmfwriter2d.WMFGraphics2D;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Java2DTextLowLevel {
    static final int HORIZ_JUSTIFY_LEFT = 0;
    static final int HORIZ_JUSTIFY_CENTER = 1;
    static final int HORIZ_JUSTIFY_RIGHT = 2;
    static final double COS_SIN_45 = 0.7071067811865475;
    static final int VERT_ALIGN_TOP = 0;
    static final int VERT_ALIGN_CENTER = 1;
    static final int VERT_ALIGN_BOTTOM = 2;
    static final int ROTATE_NONE = 0;
    static final int ROTATE_ANGLE = 1;
    private int m_nRotate = 0;
    private int m_nRotationAngleDeg = 0;
    private AffineTransform m_transformRotate = new AffineTransform();
    private int m_nHorizJustify = 0;
    private int m_nVertAlign = 1;
    private boolean m_bWrap = false;
    private boolean m_bUnderline = false;
    static final int UNDERLINE_LOW_ONE_PIXEL = 1;
    static final int UNDERLINE_LOW_TWO_PIXEL = 2;
    static final int UNDERLINE_LOW_DOTTED = 3;
    static final int UNDERLINE_LOW_GRAY = 4;
    static final int UNDERLINE_LOW_DASHED = 5;
    private Integer m_nINTUnderlineType = TextAttribute.UNDERLINE_LOW_TWO_PIXEL;
    private Font m_font;
    private String m_strFontFamily = "Arial";
    private int m_nFontStyle = 0;
    private double m_nFontPointSize = 12.0;
    private Color m_colorForeground = Color.black;
    private boolean m_bUseBackgroundColor = false;
    private Color m_colorBackground = Color.white;
    private boolean m_bStrikeThrough = false;
    private String m_strText = "";
    private Rectangle m_rTextDC = new Rectangle(200, 200, 300, 200);
    private Map<TextAttribute, Serializable> m_attrMap = new HashMap<TextAttribute, Serializable>();
    private int m_nWrapWidth = 200;
    static final int FILL_COLOR = 1;
    static final int FILL_GRADIENT_LEFTTORIGHT = 2;
    static final int FILL_TEXTURE = 3;
    private int m_nFillType = 1;
    private Color m_colorGradientStart = Color.black;
    private Color m_colorGradientEnd = Color.black;
    private transient BufferedImage m_Texture;
    private FontRenderContext m_fontRenderContext;
    private boolean m_bAccurateTextSize;
    private static final Map desktopHints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");

    Java2DTextLowLevel(FontRenderContext frc) {
        this.m_transformRotate = new AffineTransform();
        this.m_transformRotate.setToIdentity();
        this.m_fontRenderContext = frc;
    }

    public void setForegroundColor(Color col) {
        this.m_colorForeground = new Color(col.getRed(), col.getGreen(), col.getBlue());
    }

    public Color getForegroundColor() {
        Color colorForeground = new Color(this.m_colorForeground.getRed(), this.m_colorForeground.getGreen(), this.m_colorForeground.getBlue());
        return colorForeground;
    }

    public void setUseBackgroundColor(boolean bUseBackgroundColor) {
        this.m_bUseBackgroundColor = bUseBackgroundColor;
    }

    public boolean getUseBackgroundColor() {
        return this.m_bUseBackgroundColor;
    }

    public void setBackgroundColor(Color col) {
        this.m_colorBackground = new Color(col.getRed(), col.getGreen(), col.getBlue());
    }

    public Color getBackgroundColor() {
        Color colorBackground = new Color(this.m_colorBackground.getRed(), this.m_colorBackground.getGreen(), this.m_colorBackground.getBlue());
        return colorBackground;
    }

    public void setFontFamily(String strFontFamily) {
        this.m_strFontFamily = strFontFamily;
    }

    public void setFontStyle(int nFontStyle) {
        this.m_nFontStyle = nFontStyle;
    }

    public void setFontPointSize(double nPtSize) {
        this.m_nFontPointSize = nPtSize;
    }

    public void setRectDC(Rectangle rText) {
        this.m_rTextDC = new Rectangle(rText.x, rText.y, rText.width, rText.height);
    }

    public Rectangle getRectDC() {
        Rectangle rTextDC = new Rectangle(this.m_rTextDC);
        return rTextDC;
    }

    public void setText(String strText) {
        this.m_strText = strText;
    }

    public void setWrap(boolean bWrap) {
        this.m_bWrap = bWrap;
    }

    public boolean getWrap() {
        return this.m_bWrap;
    }

    public double getFontPointSize() {
        return this.m_nFontPointSize;
    }

    public void setUnderlineType(int nUnderlineType) {
        switch (nUnderlineType) {
            case 1: {
                this.m_nINTUnderlineType = TextAttribute.UNDERLINE_LOW_ONE_PIXEL;
                break;
            }
            default: {
                this.m_nINTUnderlineType = TextAttribute.UNDERLINE_LOW_TWO_PIXEL;
                break;
            }
            case 3: {
                this.m_nINTUnderlineType = TextAttribute.UNDERLINE_LOW_DOTTED;
                break;
            }
            case 4: {
                this.m_nINTUnderlineType = TextAttribute.UNDERLINE_LOW_GRAY;
                break;
            }
            case 5: {
                this.m_nINTUnderlineType = TextAttribute.UNDERLINE_LOW_DASHED;
            }
        }
    }

    public void setUnderline(boolean bUnderline) {
        this.m_bUnderline = bUnderline;
    }

    public void setHorizJustify(int nHorizJustify) {
        this.m_nHorizJustify = nHorizJustify;
    }

    public void setVertAlign(int nVertAlign) {
        this.m_nVertAlign = nVertAlign;
    }

    public void setStrikeThrough(boolean bStrikeThrough) {
        this.m_bStrikeThrough = bStrikeThrough;
    }

    public void applyFontAttributes() {
        this.createFontAttrMap();
        this.adjustWrapWidth();
    }

    private void adjustWrapWidth() {
        if (this.m_bWrap) {
            if (this.m_nRotate == 0) {
                this.m_nWrapWidth = this.m_rTextDC.width;
            } else {
                switch (this.m_nRotationAngleDeg) {
                    default: {
                        this.m_nWrapWidth = this.m_rTextDC.width;
                        break;
                    }
                    case 90: 
                    case 270: {
                        this.m_nWrapWidth = this.m_rTextDC.height;
                        break;
                    }
                    case 45: 
                    case 135: 
                    case 225: 
                    case 315: {
                        int nSmallestSide = Math.min(this.m_rTextDC.width, this.m_rTextDC.height);
                        this.m_nWrapWidth = (int)Math.sqrt(nSmallestSide * nSmallestSide + nSmallestSide * nSmallestSide);
                        break;
                    }
                }
            }
        } else {
            this.m_nWrapWidth = 16000;
        }
    }

    private void createFontAttrMap() {
        this.m_font = FontCache.getFont(this.m_strFontFamily, this.m_nFontStyle, (float)this.m_nFontPointSize);
        this.m_attrMap = new Hashtable<TextAttribute, Serializable>();
        this.m_attrMap.put(TextAttribute.FONT, this.m_font);
        if (this.m_bStrikeThrough) {
            this.m_attrMap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        if (this.m_bUnderline) {
            this.m_attrMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            this.m_attrMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, this.m_nINTUnderlineType);
        }
        if (this.m_bUseBackgroundColor) {
            this.m_attrMap.put(TextAttribute.BACKGROUND, this.m_colorBackground);
        }
    }

    public void drawText(Graphics2D g, List<String> lines) {
        Stroke saveStroke = g.getStroke();
        Paint savePaint = g.getPaint();
        AffineTransform saveXform = g.getTransform();
        this.applyFontAttributes();
        g.setColor(this.m_colorForeground);
        g.setFont(this.m_font.deriveFont(this.m_fontRenderContext.getTransform()));
        if (this.m_nRotate == 1) {
            this.applyRotation(g);
        }
        switch (this.m_nFillType) {
            case 2: {
                this.applyGradient(g);
                break;
            }
            case 3: {
                this.applyTexture(g);
            }
        }
        this.drawTextWrapped(g, lines);
        g.setStroke(saveStroke);
        g.setPaint(savePaint);
        g.setTransform(saveXform);
    }

    private void drawTextWrapped(Graphics2D g, List<String> lines) {
        int nDrawPosY = this.getStartY(lines);
        for (String strLine : lines) {
            if (strLine.length() > 0) {
                this.drawOneLine(g, strLine, nDrawPosY);
            }
            if (this.m_nRotationAngleDeg == 315) {
                nDrawPosY = (int)((double)nDrawPosY + (double)this.getTextSizeNotWrappedDC((String)strLine).height * 0.7071067811865475);
                continue;
            }
            nDrawPosY += this.getTextSizeNotWrappedDC((String)strLine).height;
        }
    }

    private int getStartY(List<String> lines) {
        if (this.m_nRotationAngleDeg != 0) {
            return this.m_rTextDC.y;
        }
        int nTotalTextHeight = 0;
        for (String strLine : lines) {
            nTotalTextHeight += this.getTextSizeNotWrappedDC((String)strLine).height;
        }
        int startY = this.m_rTextDC.y;
        int space = this.m_rTextDC.height;
        if ((space -= nTotalTextHeight) <= 0) {
            return startY;
        }
        switch (this.m_nVertAlign) {
            default: {
                return startY;
            }
            case 1: {
                return startY + space / 2;
            }
            case 2: 
        }
        return startY + space;
    }

    private void drawString(Graphics2D g, AttributedCharacterIterator aciParagraph, String strText, float x, float y) {
        if (g instanceof WMFGraphics2D) {
            g.drawString(strText, x, y);
        } else {
            RenderingHints rh = null;
            if (desktopHints != null && !this.usingAttributedText()) {
                rh = g.getRenderingHints();
                g.setRenderingHints(desktopHints);
                g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                g.drawString(strText, x, y);
            } else {
                g.drawString(aciParagraph, x, y);
            }
            if (rh != null) {
                g.setRenderingHints(rh);
            }
        }
    }

    private boolean usingAttributedText() {
        return this.m_bStrikeThrough || this.m_bUnderline || this.m_bUseBackgroundColor;
    }

    private void drawOneLine(Graphics2D g, String strText, int nPosY) {
        AttributedString attrStr = new AttributedString(strText, this.m_attrMap);
        AttributedCharacterIterator aciParagraph = attrStr.getIterator();
        int nParagraphStart = aciParagraph.getBeginIndex();
        int nParagraphEnd = aciParagraph.getEndIndex();
        LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(aciParagraph, this.m_fontRenderContext);
        lineMeasurer.setPosition(nParagraphStart);
        double fDrawPosY = nPosY;
        int nCharIndex = 0;
        while (lineMeasurer.getPosition() < nParagraphEnd) {
            double fYAdjust;
            double fDrawPosX;
            int nTextWidthDC;
            TextLayout layout = lineMeasurer.nextLayout(Float.MAX_VALUE);
            fDrawPosY += (double)layout.getAscent();
            if (this.m_bWrap) {
                int nCharCount = layout.getCharacterCount();
                nTextWidthDC = this.getWrapWidthOneLineDC(layout, strText, nCharIndex, nCharCount);
                nCharIndex += nCharCount;
            } else {
                Dimension dimTextSizeDC = this.getTextSizeNotWrappedDC(strText);
                nTextWidthDC = dimTextSizeDC.width;
            }
            double fYSave = fDrawPosY;
            if (this.m_nRotationAngleDeg == 315) {
                fDrawPosX = this.horizJustifyRotated(nTextWidthDC);
                fDrawPosY = nPosY + this.m_rTextDC.height;
                fYAdjust = this.vertJustifyRotated();
                AffineTransform origTrans = g.getTransform();
                this.clearRotateTransform();
                this.m_transformRotate.rotate(Math.toRadians(this.m_nRotationAngleDeg), fDrawPosX, fDrawPosY -= fYAdjust);
                g.transform(this.m_transformRotate);
                this.drawString(g, aciParagraph, strText, (float)fDrawPosX, (float)fDrawPosY);
                g.setTransform(origTrans);
            } else if (this.m_nRotate == 1) {
                fDrawPosX = this.horizJustifyRotated(nTextWidthDC);
                fYAdjust = this.vertJustifyRotated();
                fDrawPosY -= fYAdjust;
            } else {
                fDrawPosX = this.horizJustify(strText);
            }
            if (this.m_nRotationAngleDeg != 315) {
                this.drawString(g, aciParagraph, strText, (float)fDrawPosX, (float)fDrawPosY);
            }
            fDrawPosY = fYSave;
            fDrawPosY += (double)(layout.getDescent() + layout.getLeading());
        }
    }

    private double vertJustifyRotated() {
        double fYAdjust = 0.0;
        Rectangle rectTextDC = this.getTextSizeRectDC();
        rectTextDC.x = this.m_rTextDC.x;
        rectTextDC.y = this.m_rTextDC.y;
        rectTextDC.width = (int)((double)rectTextDC.width * 0.7071067811865475);
        block0 : switch (this.m_nRotationAngleDeg) {
            default: {
                fYAdjust = 0.0;
                break;
            }
            case 0: 
            case 315: {
                switch (this.m_nHorizJustify) {
                    default: {
                        break block0;
                    }
                    case 1: {
                        fYAdjust = this.m_rTextDC.height - rectTextDC.width - rectTextDC.height / 2;
                        fYAdjust /= 2.0;
                        break block0;
                    }
                    case 2: 
                }
                fYAdjust = this.m_rTextDC.height - rectTextDC.width - rectTextDC.height / 2;
            }
        }
        return fYAdjust;
    }

    private double horizJustifyRotated(int nTextWidthDC) {
        double fDrawPosX = this.m_rTextDC.x;
        Rectangle rectTextDC = this.getTextSizeRectDC();
        rectTextDC.x = this.m_rTextDC.x;
        rectTextDC.y = this.m_rTextDC.y;
        rectTextDC.width = (int)((double)rectTextDC.width * 0.7071067811865475);
        block0 : switch (this.m_nRotationAngleDeg) {
            default: {
                fDrawPosX = this.m_rTextDC.x;
                break;
            }
            case 315: {
                switch (this.m_nHorizJustify) {
                    default: {
                        fDrawPosX = this.m_rTextDC.x + rectTextDC.height / 2;
                        break block0;
                    }
                    case 1: {
                        double nXAdjust = this.m_rTextDC.width - rectTextDC.width + rectTextDC.height / 2;
                        fDrawPosX = (double)this.m_rTextDC.x + nXAdjust / 2.0;
                        break block0;
                    }
                    case 2: 
                }
                double nXAdjust = this.m_rTextDC.width - rectTextDC.width;
                fDrawPosX = (double)this.m_rTextDC.x + nXAdjust;
                break;
            }
            case 90: 
            case 270: {
                switch (this.m_nHorizJustify) {
                    case 0: {
                        fDrawPosX = this.m_rTextDC.x;
                        break block0;
                    }
                    default: {
                        fDrawPosX = this.m_rTextDC.x + this.m_rTextDC.height / 2 - nTextWidthDC / 2;
                        break block0;
                    }
                    case 2: 
                }
                fDrawPosX = this.m_rTextDC.x + this.m_rTextDC.height - nTextWidthDC;
            }
        }
        return fDrawPosX;
    }

    private double horizJustify(String line) {
        double fDrawPosX;
        Dimension dimTextSizeDC = this.getTextSizeNotWrappedDC(line);
        switch (this.m_nHorizJustify) {
            case 0: {
                fDrawPosX = this.m_rTextDC.x;
                break;
            }
            default: {
                fDrawPosX = this.m_rTextDC.x + this.m_rTextDC.width / 2 - dimTextSizeDC.width / 2;
                break;
            }
            case 2: {
                fDrawPosX = this.m_rTextDC.x + this.m_rTextDC.width - dimTextSizeDC.width;
            }
        }
        return fDrawPosX;
    }

    public int extractLinesWordWrap(List<String> vectStrLines) {
        int nNumLines;
        if (this.m_bWrap) {
            List<String> lines = this.getListOfWrappedTextLines(this.m_strText);
            vectStrLines.addAll(lines);
            nNumLines = lines.size();
        } else {
            vectStrLines.add(this.m_strText);
            nNumLines = 1;
        }
        return nNumLines;
    }

    public int getNumLines() {
        if (this.m_bWrap) {
            List<String> lines = this.getListOfWrappedTextLines(this.m_strText);
            return lines.size();
        }
        return 1;
    }

    public Polygon getTextSizePolyDC() {
        Polygon polyTextDC = new Polygon();
        Dimension dimTextSizeDC = this.getTextSizeDC();
        polyTextDC.addPoint(this.m_rTextDC.x, this.m_rTextDC.y);
        polyTextDC.addPoint(this.m_rTextDC.x + dimTextSizeDC.width, this.m_rTextDC.y);
        polyTextDC.addPoint(this.m_rTextDC.x + dimTextSizeDC.width, this.m_rTextDC.y + dimTextSizeDC.height);
        polyTextDC.addPoint(this.m_rTextDC.x, this.m_rTextDC.y + dimTextSizeDC.height);
        polyTextDC.addPoint(this.m_rTextDC.x, this.m_rTextDC.y);
        switch (this.m_nRotate) {
            case 1: {
                Polygon shapePolyTextDC = polyTextDC;
                Shape shapePolyTextRotated = this.m_transformRotate.createTransformedShape(shapePolyTextDC);
                Rectangle rBoundsDC = shapePolyTextRotated.getBounds();
                polyTextDC = new Polygon();
                polyTextDC.addPoint(rBoundsDC.x, rBoundsDC.y);
                polyTextDC.addPoint(rBoundsDC.x + rBoundsDC.width, rBoundsDC.y);
                polyTextDC.addPoint(rBoundsDC.x + rBoundsDC.width, rBoundsDC.y + rBoundsDC.height);
                polyTextDC.addPoint(rBoundsDC.x, rBoundsDC.y + rBoundsDC.height);
                polyTextDC.addPoint(rBoundsDC.x, rBoundsDC.y);
            }
        }
        return polyTextDC;
    }

    public Rectangle getTextSizeRectDC() {
        Polygon polyTextDC = this.getTextSizePolyDC();
        Rectangle rTextDC = polyTextDC.getBounds();
        return rTextDC;
    }

    public Dimension getTextSizeDC() {
        return this.getTextSizeDC(-1);
    }

    public Dimension getTextSizeDC(int wrapWidth) {
        Dimension dimTextSizeDC = new Dimension(0, 0);
        if (this.m_strText.length() > 0) {
            this.applyFontAttributes();
            if (wrapWidth > 0) {
                this.m_nWrapWidth = wrapWidth;
            }
            dimTextSizeDC = this.m_bWrap ? this.getTextSizeWrappedDC(this.m_strText) : this.getTextSizeNotWrappedDC(this.m_strText);
        }
        return dimTextSizeDC;
    }

    private Dimension getTextSizeNotWrappedDC(String strText) {
        Rectangle rText;
        if (this.m_bAccurateTextSize) {
            TextLayout ty = new TextLayout(strText, this.m_font, this.m_fontRenderContext);
            Rectangle2D r = ty.getBounds();
            rText = r.getBounds();
        } else {
            Rectangle2D r2DText = this.m_font.getStringBounds(strText, this.m_fontRenderContext);
            rText = r2DText.getBounds();
            String strVersion = System.getProperty("java.version");
            Double ver = Double.valueOf(strVersion.substring(0, 3));
            if (Double.compare(ver, 1.6) < 0) {
                int maxStrHeight = 0;
                for (int i = 0; i < strText.length(); ++i) {
                    Rectangle2D rect = this.m_font.getStringBounds(strText, i, i, this.m_fontRenderContext);
                    maxStrHeight = rect.getBounds().height > maxStrHeight ? rect.getBounds().height : maxStrHeight;
                }
                rText.setSize(rText.width, maxStrHeight > rText.height ? maxStrHeight : rText.height);
            }
        }
        Dimension dimTextSizeDC = new Dimension(rText.width, rText.height);
        return dimTextSizeDC;
    }

    public static String[] splitWords(String string, String onToken) {
        StringTokenizer tokenizer = new StringTokenizer(string, onToken);
        String[] result = new String[tokenizer.countTokens()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = tokenizer.nextToken();
        }
        return result;
    }

    public static String addSpaceAfterNewline(String strText) {
        StringBuffer strWithSpaces = new StringBuffer();
        boolean bFoundNewline = false;
        int nLength = strText.length();
        for (int i = 0; i < nLength; ++i) {
            char c1;
            char c0 = strText.charAt(i);
            strWithSpaces.append(c0);
            if (c0 != '\n') continue;
            bFoundNewline = true;
            if (i == nLength - 1 || (c1 = strText.charAt(i + 1)) == ' ') continue;
            strWithSpaces.append(' ');
        }
        String strReturn = bFoundNewline ? strWithSpaces.toString() : strText;
        return strReturn;
    }

    private List<String> getListOfWrappedTextLines(String strText) {
        String strSpaceAfterNewLine = Java2DTextLowLevel.addSpaceAfterNewline(strText);
        String[] strArrayWords = Java2DTextLowLevel.splitWords(strSpaceAfterNewLine, " ");
        Dimension dimTextSize = new Dimension(0, 0);
        ArrayList<String> listLines = new ArrayList<String>();
        String strLine = "";
        String strTryLine = "";
        Dimension dimTryLineSize = new Dimension(0, 0);
        int nWordsInTryLine = 0;
        int i = 0;
        while (i < strArrayWords.length) {
            strTryLine = strTryLine + strArrayWords[i];
            ++nWordsInTryLine;
            dimTryLineSize = this.getTextSizeNotWrappedDC(strTryLine);
            int nNumNewLines = this.getNumNewLines(strTryLine);
            if (dimTryLineSize.width <= this.m_nWrapWidth && nNumNewLines <= 1) {
                strLine = strTryLine;
                dimTextSize.width = Math.max(dimTextSize.width, dimTryLineSize.width);
                strTryLine = strTryLine + " ";
                ++i;
                continue;
            }
            if (nWordsInTryLine == 1) {
                strLine = strTryLine;
                ++i;
            }
            listLines.add(strLine);
            strLine = null;
            strTryLine = "";
            nWordsInTryLine = 0;
        }
        if (strLine != null) {
            listLines.add(strLine);
        }
        return listLines;
    }

    private int getNumNewLines(String strText) {
        String strNewLine = System.getProperty("line.separator");
        StringTokenizer tokenizer = new StringTokenizer(strText, strNewLine);
        int nNumNewLines = tokenizer.countTokens();
        return nNumNewLines;
    }

    private Dimension getTextSizeWrappedDC(String strText) {
        Dimension textSize = new Dimension(0, 0);
        List<String> lines = this.getListOfWrappedTextLines(strText);
        for (String strLine : lines) {
            Dimension dimlineSize = this.getTextSizeNotWrappedDC(strLine);
            textSize.width = Math.max(textSize.width, dimlineSize.width);
            textSize.height += dimlineSize.height;
        }
        return textSize;
    }

    private int getWrapWidthOneLineDC(TextLayout layout, String strText, int nCharStartIndex, int nCharCount) {
        int nSubstringEnd = nCharStartIndex + nCharCount;
        String strSub = strText.substring(nCharStartIndex, nSubstringEnd);
        Dimension dimTextSizeDC = this.getTextSizeNotWrappedDC(strSub);
        return dimTextSizeDC.width;
    }

    public void setFillType(int nFillType) {
        this.m_nFillType = nFillType;
    }

    public int getFillType() {
        return this.m_nFillType;
    }

    public void setTexture(BufferedImage img) {
        this.m_Texture = img;
    }

    public BufferedImage getTexture() {
        return this.m_Texture;
    }

    private void applyTexture(Graphics2D g) {
        if (this.m_Texture != null) {
            TextLayout layoutText = new TextLayout(this.m_strText, this.m_attrMap, this.m_fontRenderContext);
            AffineTransform textAt = new AffineTransform();
            textAt.setToIdentity();
            Shape textShape = layoutText.getOutline(textAt);
            Rectangle rBounds = textShape.getBounds();
            if (this.m_bWrap) {
                rBounds.width = this.m_nWrapWidth;
            }
            TexturePaint tP = new TexturePaint(this.m_Texture, rBounds);
            g.setPaint(tP);
        }
    }

    public void setGradientStartColor(Color colorStart) {
        this.m_colorGradientStart = new Color(colorStart.getRed(), colorStart.getGreen(), colorStart.getBlue(), colorStart.getAlpha());
    }

    public Color getGradientStartColor() {
        Color colorStart = new Color(this.m_colorGradientStart.getRed(), this.m_colorGradientStart.getGreen(), this.m_colorGradientStart.getBlue());
        return colorStart;
    }

    public void setGradientEndColor(Color colorEnd) {
        this.m_colorGradientEnd = new Color(colorEnd.getRed(), colorEnd.getGreen(), colorEnd.getBlue(), colorEnd.getAlpha());
    }

    public Color getGradientEndColor() {
        Color colorEnd = new Color(this.m_colorGradientEnd.getRed(), this.m_colorGradientEnd.getGreen(), this.m_colorGradientEnd.getBlue());
        return colorEnd;
    }

    private void applyGradient(Graphics2D g) {
        FontMetrics metrics = g.getFontMetrics();
        int nMetricsWidth = metrics.stringWidth(this.m_strText);
        if (this.m_bWrap) {
            nMetricsWidth = this.m_nWrapWidth;
        }
        int nMetricsHeight = metrics.getHeight();
        GradientPaint gradPaint = new GradientPaint(this.m_rTextDC.x, this.m_rTextDC.y, this.m_colorGradientStart, this.m_rTextDC.x + nMetricsWidth, this.m_rTextDC.y + nMetricsHeight, this.m_colorGradientEnd, false);
        g.setPaint(gradPaint);
    }

    private void applyRotation(Graphics2D g) {
        this.clearRotateTransform();
        Dimension dimTextDC = this.getTextSizeDC();
        switch (this.m_nRotationAngleDeg) {
            default: {
                break;
            }
            case 45: 
            case 180: {
                this.m_transformRotate.rotate(Math.toRadians(this.m_nRotationAngleDeg), this.m_rTextDC.x + this.m_rTextDC.width / 2, this.m_rTextDC.y + dimTextDC.height / 2);
                break;
            }
            case 315: {
                break;
            }
            case 90: {
                this.m_transformRotate.rotate(Math.toRadians(this.m_nRotationAngleDeg), this.m_rTextDC.x, this.m_rTextDC.y);
                this.m_transformRotate.translate(0.0, -this.m_rTextDC.width / 2 - dimTextDC.height / 2);
                break;
            }
            case 270: {
                this.m_transformRotate.rotate(Math.toRadians(this.m_nRotationAngleDeg), this.m_rTextDC.x, this.m_rTextDC.y);
                this.m_transformRotate.translate(-this.m_rTextDC.height, this.m_rTextDC.width / 2 - dimTextDC.height / 2);
            }
        }
        g.transform(this.m_transformRotate);
    }

    public void setRotationEnum(int rotation) {
        switch (rotation) {
            default: {
                this.setRotation(0);
                break;
            }
            case 1: {
                this.setRotation(1);
                this.setRotationAngle(90);
                break;
            }
            case 2: {
                this.setRotation(1);
                this.setRotationAngle(270);
                break;
            }
            case 3: {
                this.setRotation(1);
                this.setRotationAngle(45);
                break;
            }
            case 4: {
                this.setRotation(1);
                this.setRotationAngle(180);
                break;
            }
            case 5: {
                this.setRotation(1);
                this.setRotationAngle(315);
            }
        }
    }

    public void setRotationAngle(int nAngleDeg) {
        this.m_nRotationAngleDeg = 360 - nAngleDeg;
    }

    private void clearRotateTransform() {
        this.m_transformRotate = new AffineTransform();
        this.m_transformRotate.setToIdentity();
    }

    public void setRotation(int nRotate) {
        switch (nRotate) {
            default: {
                this.m_nRotate = 0;
                break;
            }
            case 1: {
                this.m_nRotate = 1;
            }
        }
    }

    public void setFontInfo(FontInfoObj fontInfo, double fontSizeDC) {
        this.setFontPointSize(fontSizeDC);
        this.setFontFamily(fontInfo.m_strFontName);
        this.setUnderlineType(fontInfo.m_nINTUnderlineType);
        this.setRotationEnum(fontInfo.m_nRotationSetting);
        this.setWrap(fontInfo.m_bWordwrap);
        this.setUseBackgroundColor(fontInfo.m_bUseBackgroundColor);
        this.setBackgroundColor(fontInfo.m_colorBackground);
        this.setStrikeThrough(fontInfo.m_bStrikeThrough);
        switch (fontInfo.m_nFontStyle) {
            default: {
                this.setFontStyle(0);
                this.setUnderline(false);
                this.setStrikeThrough(false);
                break;
            }
            case 1: {
                this.setFontStyle(2);
                break;
            }
            case 2: {
                this.setFontStyle(1);
                break;
            }
            case 4: {
                this.setUnderline(true);
                break;
            }
            case 3: {
                this.setFontStyle(3);
                break;
            }
            case 5: {
                this.setFontStyle(2);
                this.setUnderline(true);
                break;
            }
            case 7: {
                this.setFontStyle(3);
                this.setUnderline(true);
                break;
            }
            case 6: {
                this.setFontStyle(1);
                this.setUnderline(true);
            }
        }
        switch (fontInfo.m_nAlignHoriz) {
            case 0: {
                this.setHorizJustify(0);
                break;
            }
            case 1: {
                this.setHorizJustify(1);
                break;
            }
            case 2: {
                this.setHorizJustify(2);
            }
        }
        switch (fontInfo.m_nAlignVert) {
            case 0: {
                this.setVertAlign(0);
                break;
            }
            case 1: {
                this.setVertAlign(1);
                break;
            }
            case 2: {
                this.setVertAlign(2);
            }
        }
    }

    public boolean useAccurateTextSizeCalculation(boolean bAccurate) {
        boolean retVal = this.m_bAccurateTextSize;
        this.m_bAccurateTextSize = bAccurate;
        return retVal;
    }

    public List<String> getListOfWrappedTextLines() {
        this.applyFontAttributes();
        return this.getListOfWrappedTextLines(this.m_strText);
    }
}

