/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.FillObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.Arc2D;
import java.awt.image.RescaleOp;

class FillColorObj
extends FillObj {
    private Paint paint;
    private double intensity = 1.0;

    public FillColorObj() {
        this.paint = Color.WHITE;
    }

    public FillColorObj(Paint paint) {
        this.paint = paint;
    }

    public void copy(FillObj fo) {
        this.paint = ((FillColorObj)fo).paint;
        this.intensity = ((FillColorObj)fo).intensity;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FillColorObj) {
            FillColorObj fco = (FillColorObj)obj;
            return this.paint.equals(fco.paint);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + this.paint.hashCode();
        return result;
    }

    public void fillOval(Graphics2D g, int x, int y, int width, int height) {
        this.setPaint(g);
        g.fillOval(x, y, width, height);
    }

    public void fillPolygon(Graphics2D g2, int[] nXPoints, int[] nYPoints, int nPoints) {
        this.setPaint(g2);
        if (this.internalBorderThickness != 0.0) {
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(new BasicStroke((float)this.internalBorderThickness, 1, 1));
            g2.drawPolygon(nXPoints, nYPoints, nPoints);
            g2.setStroke(oldStroke);
        }
        g2.fillPolygon(nXPoints, nYPoints, nPoints);
    }

    public void fillShape(Graphics2D g2, Shape shape) {
        this.setPaint(g2);
        if (this.internalBorderThickness != 0.0) {
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(new BasicStroke((float)this.internalBorderThickness, 0, 1));
            g2.draw(shape);
            g2.setStroke(oldStroke);
        }
        g2.fill(shape);
    }

    public void fillArc(Graphics2D g2D, Arc2D arc2D) {
        this.setPaint(g2D);
        g2D.fill(arc2D);
    }

    public void fillRect(Graphics2D g, int x, int y, int width, int height) {
        this.setPaint(g);
        RenderingHints oldHints = g.getRenderingHints();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.fillRect(x, y, width, height);
        g.setRenderingHints(oldHints);
    }

    private void setPaint(Graphics2D g) {
        if (this.intensity != 1.0) {
            if (this.paint instanceof Color) {
                Color color = (Color)this.paint;
                double fR = (double)color.getRed() * this.intensity;
                double fG = (double)color.getGreen() * this.intensity;
                double fB = (double)color.getBlue() * this.intensity;
                g.setColor(new Color(FP.round(fR), FP.round(fG), FP.round(fB)));
                return;
            }
            if (this.paint instanceof TexturePaint) {
                TexturePaint texture = (TexturePaint)this.paint;
                RescaleOp op = new RescaleOp((float)this.intensity, 0.0f, null);
                g.setPaint(new TexturePaint(op.filter(texture.getImage(), null), texture.getAnchorRect()));
                return;
            }
        }
        g.setPaint(this.paint);
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setIntensity(double intensity) {
        this.intensity = intensity;
    }

    public double getIntensity() {
        return this.intensity;
    }
}

