/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.border.BorderFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.border.IBorder;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Rectangle;

public class AnnotationBox {
    private final Perspective m_Perspective;
    private final IdentObj m_idBox;
    private final IBlackBox m_blackbox;
    private final Rectangle m_rBoundsVC;
    private final Rectangle m_clipRect;

    public static void calcBorderedBox(Perspective perspective, IdentObj idBox, Rectangle rBoundsVC, IBlackBox bb, Rectangle clipRect) {
        if (perspective == null || idBox == null || rBoundsVC == null) {
            assert (false);
            return;
        }
        AnnotationBox box = new AnnotationBox(perspective, idBox, rBoundsVC, bb, clipRect);
        box.calc();
    }

    public static void calcBorderedBox(Perspective perspective, IdentObj idBox, Rectangle rBoundsVC, boolean outerBorder) {
        Rectangle actualBoundsVC = new Rectangle(rBoundsVC);
        if (outerBorder) {
            int left = perspective.getLeftInset(idBox);
            int top = perspective.getTopInset(idBox);
            actualBoundsVC.x -= left;
            actualBoundsVC.y -= top;
            actualBoundsVC.width += left + perspective.getRightInset(idBox);
            actualBoundsVC.height += top + perspective.getBottomInset(idBox);
        }
        AnnotationBox.calcBorderedBox(perspective, idBox, actualBoundsVC, null, null);
    }

    private AnnotationBox(Perspective perspective, IdentObj idBox, Rectangle rBoundsVC, IBlackBox bb, Rectangle clipRect) {
        this.m_Perspective = perspective;
        this.m_idBox = idBox;
        this.m_rBoundsVC = rBoundsVC;
        this.m_blackbox = bb;
        this.m_clipRect = clipRect;
    }

    private void calc() {
        if (this.m_Perspective.getBorderType(this.m_idBox) != 0) {
            this.calcBackground();
            this.calcBorder();
        }
    }

    private void calcBorder() {
        IBorder border;
        if (this.m_Perspective.getBorderType(this.m_idBox) != 0 && (border = BorderFactory.createBorder(this.m_Perspective, this.m_idBox, this.m_rBoundsVC, this.m_blackbox)) != null) {
            border.calc();
        }
    }

    private void calcBackground() {
        IBlackBox blackbox = this.m_blackbox;
        blackbox = blackbox == null ? new BlackBoxObj(this.m_Perspective, this.m_idBox) : (IBlackBox)this.m_blackbox.clone(this.m_blackbox);
        blackbox.setTransparentBorderColor(true);
        DrawFactory.createRectangle(this.m_Perspective.getDetectiv(), this.m_idBox, this.m_rBoundsVC, blackbox, this.m_clipRect);
    }
}

