/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.data;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DataStorageFastDouble;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DataStoragePaged;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.IDataStorage;

public class DataStorageFactory {
    public static final int FASTDOUBLE = 0;
    public static final int PAGED = 1;

    public static IDataStorage getInstance(int type) {
        switch (type) {
            case 0: {
                return new DataStorageFastDouble();
            }
            case 1: {
                return new DataStoragePaged();
            }
        }
        throw new IllegalArgumentException("DataStorage type unknown");
    }

    public static IDataStorage getInstance(int type, IDataStorage ds) {
        IDataStorage dataStorage = DataStorageFactory.getInstance(type);
        switch (type) {
            case 0: {
                if (!(dataStorage instanceof DataStorageFastDouble)) break;
                dataStorage.copy(dataStorage);
                break;
            }
            case 1: {
                if (!(dataStorage instanceof DataStoragePaged)) break;
                dataStorage.copy(dataStorage);
                break;
            }
            default: {
                throw new IllegalArgumentException("DataStorage type unknown");
            }
        }
        return dataStorage;
    }
}

