/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.charting.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.MinMax;

public class MinMaxStep {
    protected final double m_dMin;
    protected final double m_dMax;
    protected final double m_dStep;

    public MinMaxStep(double dMin, double dMax, double dStep) throws IllegalArgumentException {
        if (dMin > dMax) {
            throw new IllegalArgumentException("dMin (" + dMin + " ) is > dMax (" + dMax + ")");
        }
        if (dStep < 0.0 || dStep == 0.0 && dMin != dMax) {
            throw new IllegalArgumentException("dStep (" + dStep + " ) is <= 0");
        }
        this.m_dMin = dMin;
        this.m_dMax = dMax;
        this.m_dStep = dStep;
    }

    public MinMaxStep(MinMax mm, double dStep) {
        double dMax;
        if (!mm.isValid()) {
            throw new IllegalArgumentException("MinMaxStep cannot be constructed from invalid MinMax " + mm);
        }
        double dMin = mm.getMin();
        if (dMin > (dMax = mm.getMax())) {
            throw new IllegalArgumentException("dMin (" + dMin + " ) is > dMax (" + dMax + ")");
        }
        if (dStep < 0.0 || dStep == 0.0 && dMin != dMax) {
            throw new IllegalArgumentException("dStep (" + dStep + " ) is <= 0");
        }
        this.m_dMin = dMin;
        this.m_dMax = dMax;
        this.m_dStep = dStep;
    }

    public double getMax() {
        return this.m_dMax;
    }

    public double getMin() {
        return this.m_dMin;
    }

    public double getStep() {
        return this.m_dStep;
    }

    public String toString() {
        return "MinMaxStep(" + this.m_dMin + ", " + this.m_dMax + ", " + this.m_dStep + ")";
    }
}

