/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataLabels {
    private Map<IdentObj, DataLabelInfo> m_DataLabels;
    private Perspective m_Perspective;

    public DataLabels(Perspective perspective) {
        this.m_Perspective = perspective;
        this.m_DataLabels = new HashMap<IdentObj, DataLabelInfo>();
    }

    private DataLabelInfo getDataLabelInfo(int s, int g) {
        DataLabelInfo dataLabelInfo = this.m_DataLabels.get(this.m_Perspective.getDataText(s, g));
        if (dataLabelInfo == null) {
            dataLabelInfo = new DataLabelInfo();
            dataLabelInfo.m_Series = s;
            dataLabelInfo.m_Group = g;
            this.m_DataLabels.put(this.m_Perspective.getDataText(s, g), dataLabelInfo);
        }
        return dataLabelInfo;
    }

    public List<String> getDataLabelTextList() {
        Collection<DataLabelInfo> collection = this.m_DataLabels.values();
        ArrayList<String> list = new ArrayList<String>(collection.size());
        Iterator<DataLabelInfo> i = collection.iterator();
        while (i.hasNext()) {
            list.add(i.next().m_Text);
        }
        return list;
    }

    public void setDataText(String text, int s, int g) {
        this.getDataLabelInfo((int)s, (int)g).m_Text = text;
    }

    public void setDataRectangle(Rectangle rectangle, int s, int g) {
        this.getDataLabelInfo((int)s, (int)g).m_Rectangle = rectangle;
    }

    public void setDataValue(double value, int s, int g) {
        this.getDataLabelInfo((int)s, (int)g).m_Value = value;
    }

    public boolean wantDataLabel(int s, int g) {
        return this.m_Perspective.getDisplay(this.m_Perspective.getDataText(s, g));
    }

    public Iterator<DataLabelInfo> iterator() {
        return this.m_DataLabels.values().iterator();
    }

    public class DataLabelInfo {
        public String m_Text;
        public double m_Value;
        public Rectangle m_Rectangle;
        public int m_Series;
        public int m_Group;
    }
}

