/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics;

import com.businessobjects.visualization.GraphicInstance;
import com.businessobjects.visualization.dataexchange.callbacks.IValuesGrid;
import com.businessobjects.visualization.dataexchange.data.DataAdapter;
import com.businessobjects.visualization.dataexchange.data.DatasetAdapter;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesGroupAdapter;
import com.businessobjects.visualization.dataexchange.definition.DatasetDescriptor;
import com.businessobjects.visualization.dataexchange.definition.MeasureValues;
import com.businessobjects.visualization.dataexchange.definition.MeasureValuesGroup;
import com.businessobjects.visualization.feed.Feed;
import com.businessobjects.visualization.pfjgraphics.DataHandler;

public class MeasureValuesHandler
extends DataHandler {
    private IValuesGrid valuesGrid;
    private boolean rowIsSeries;
    private int cardinality;
    private Feed feed;
    private int index;
    private String title;

    public MeasureValuesHandler(Feed axisFeed, boolean rowIsSeries, GraphicInstance graphicInstance, int index) {
        this.setDataContainer(axisFeed.getDataContainers()[0]);
        assert (axisFeed.getDataContainers().length == 1) : "There is more than one data container... must handle this case.";
        this.feed = axisFeed;
        this.rowIsSeries = rowIsSeries;
        this.valuesGrid = this.getMeasureCallBack(graphicInstance);
        this.cardinality = graphicInstance.getDataDescriptor().getDatasetDescriptor().getCardinality();
        this.index = index;
        this.title = this.getTitle(graphicInstance);
    }

    public int getIndex() {
        return this.index;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public String getFeedDefID() {
        return this.feed.getFeedDef().getId();
    }

    public int getNumDataRows() {
        return this.valuesGrid.getSeriesCount();
    }

    public boolean rowIsSeries() {
        return this.rowIsSeries;
    }

    public double[] getDataRow(int r) {
        return this.valuesGrid.getSerie(r, 0);
    }

    private IValuesGrid getMeasureCallBack(GraphicInstance gi) {
        MeasureValues mv = (MeasureValues)this.getDataContainer();
        int mgIndex = gi.getDataDescriptor().getDatasetDescriptor().getMeasureGroupIndex(mv);
        int mvIndex = gi.getDataDescriptor().getDatasetDescriptor().getValueGroupList()[mgIndex].getMeasureValuesIndex(mv);
        return gi.getDataAdapter().getDataset().getValuesGrid(mgIndex, mvIndex);
    }

    public MeasureValues getMeasureValues() {
        return (MeasureValues)this.getDataContainer();
    }

    String getTitle() {
        return this.title;
    }

    private String getTitle(GraphicInstance gi) {
        DatasetDescriptor datasetDescriptor = gi.getDataDescriptor().getDatasetDescriptor();
        DataAdapter dataAdapter = gi.getDataAdapter();
        DatasetAdapter datasetAdapter = dataAdapter.getDataset();
        MeasureValues measureValues = (MeasureValues)this.getDataContainer();
        int measureGroupIndex = datasetDescriptor.getMeasureGroupIndex(measureValues);
        MeasureValuesGroup measureValuesGroup = datasetDescriptor.getValueGroupList()[measureGroupIndex];
        int measureValuesIndex = measureValuesGroup.getMeasureValuesIndex(measureValues);
        MeasureValuesGroupAdapter[] measureValuesGroupAdapters = datasetAdapter.getValueGroupList();
        return measureValuesGroupAdapters[measureGroupIndex].getMeasureValuesList()[measureValuesIndex].getTitle();
    }
}

