/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.foundation.logging.log4j;

import com.businessobjects.foundation.logging.log4j.ILock;

class PropertyLock
implements ILock {
    private static final String LOCK_PREFIX = "bobj.logging.log4j.PropertyLock";
    private static final String LOCKED = "locked";
    private static final String UNLOCKED = "unlocked";
    private static final Object s_monitor = System.class;
    private String m_lockProp;
    private boolean m_held;

    public PropertyLock(String name) {
        this.m_lockProp = "bobj.logging.log4j.PropertyLock[" + name + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() {
        Object object = s_monitor;
        synchronized (object) {
            while (LOCKED == System.getProperty(this.m_lockProp, UNLOCKED)) {
                try {
                    s_monitor.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            System.setProperty(this.m_lockProp, LOCKED);
            this.m_held = true;
        }
    }

    public void dispose() {
        this.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = s_monitor;
        synchronized (object) {
            if (!this.m_held) {
                return;
            }
            s_monitor.notifyAll();
            System.setProperty(this.m_lockProp, UNLOCKED);
            this.m_held = false;
        }
    }
}

