/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.foundation.logging.log4j;

import com.businessobjects.foundation.logging.log4j.ComboLock;
import com.businessobjects.foundation.logging.log4j.ILock;
import com.businessobjects.foundation.logging.log4j.LockException;
import com.businessobjects.foundation.logging.log4j.LockProtectedRollingFileAppender;
import com.businessobjects.foundation.logging.log4j.PropertyLock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.helpers.QuietWriter;
import org.apache.log4j.spi.LoggingEvent;

public class LockProtectedRollingFileAppender
extends WriterAppender {
    private static String PID_PROPERTY = "businessobjects.logging.process";
    private static final String s_PID;
    private String m_fileName;
    private String m_baseName;
    private String m_ext;
    private boolean m_usePID;
    private String m_datePattern;
    private DateFormat m_dateFormat;
    private long m_maxFileSize = 0xA00000L;
    private int m_maxBackupIndex = 1;
    private LockType m_lockType = LockType.NONE;
    private ILock m_lock;

    public void setDatePattern(String datePattern) {
        this.m_datePattern = datePattern;
    }

    public void setFile(String fileName) {
        this.m_fileName = fileName;
    }

    public void setLockType(String lockType) {
        this.m_lockType = LockType.fromString(lockType);
    }

    public void setMaxFileSize(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.m_maxFileSize = OptionConverter.toFileSize((String)value, (long)0L);
    }

    public void setMaxBackupIndex(int maxBackupIndex) {
        this.m_maxBackupIndex = maxBackupIndex;
    }

    public void setUsePID(boolean usePID) {
        this.m_usePID = usePID;
    }

    public void activateOptions() {
        if (this.m_datePattern != null) {
            try {
                this.m_dateFormat = new SimpleDateFormat(this.m_datePattern, Locale.ENGLISH);
            }
            catch (IllegalArgumentException iae) {
                this.errorHandler.error("Date pattern is not recognized by SimpleDateFormat.");
            }
            this.m_dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        if (this.m_fileName != null) {
            int dotAt = this.m_fileName.lastIndexOf(46);
            if (dotAt > 0 && dotAt > this.m_fileName.lastIndexOf(File.separatorChar)) {
                this.m_baseName = this.m_fileName.substring(0, dotAt);
                this.m_ext = this.m_fileName.substring(dotAt);
            } else {
                this.m_baseName = this.m_fileName;
                this.m_ext = "";
            }
            if (this.m_usePID) {
                this.m_baseName = this.m_baseName + '_' + s_PID;
            }
            this.m_fileName = this.m_baseName + this.m_ext;
            File folder = new File(this.m_fileName).getParentFile();
            if (folder != null && !folder.exists() && !folder.mkdirs()) {
                LogLog.warn((String)("Failed to create log folder: " + folder.getPath()));
            }
            try {
                this.m_lock = this.m_lockType.createLock(this.m_fileName + ".lock");
            }
            catch (LockException le) {
                this.errorHandler.error("Failed to create lock.", (Exception)le, 0);
            }
        } else {
            LogLog.error((String)("Filename option is not set for [" + this.name + "]"));
        }
        super.activateOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.m_lock.dispose();
        }
        catch (LockException le) {
            LogLog.error((String)"Unable to dispose of lock.", (Throwable)le);
        }
        finally {
            super.close();
        }
    }

    protected boolean checkEntryConditions() {
        if (this.closed) {
            LogLog.warn((String)"Not allowed to write to a closed appender.");
            return false;
        }
        if (this.m_fileName == null) {
            this.errorHandler.error("No output file set for the appender named [" + this.name + "].");
            return false;
        }
        if (this.m_lock == null) {
            this.errorHandler.error("No lock set for the appender named [" + this.name + "].");
            return false;
        }
        if (this.layout == null) {
            this.errorHandler.error("No layout set for the appender named [" + this.name + "].");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void subAppend(LoggingEvent event) {
        if (!this.acquireLock()) {
            return;
        }
        try {
            if (!this.openLog()) {
                return;
            }
            try {
                super.subAppend(event);
            }
            finally {
                this.closeLog();
            }
            if (new File(this.m_fileName).length() > this.m_maxFileSize) {
                this.rollOver();
            }
        }
        finally {
            this.releaseLock();
        }
    }

    private boolean openLog() {
        try {
            this.qw = new QuietWriter((Writer)this.createWriter(new FileOutputStream(this.m_fileName, true)), this.errorHandler);
        }
        catch (IOException ioe) {
            this.errorHandler.error("Failed to open log file.", (Exception)ioe, 4);
            return false;
        }
        return true;
    }

    private void closeLog() {
        try {
            this.qw.close();
        }
        catch (IOException ioe) {
            this.errorHandler.error("Failed to close log file.", (Exception)ioe, 3);
        }
    }

    private boolean acquireLock() {
        try {
            this.m_lock.acquire();
        }
        catch (LockException le) {
            this.errorHandler.error("Failed to acquire a lock on the log.", (Exception)le, 0);
            return false;
        }
        return true;
    }

    private void releaseLock() {
        try {
            this.m_lock.release();
        }
        catch (LockException le) {
            this.errorHandler.error("Failed to release the lock on the log.", (Exception)le, 0);
        }
    }

    private void rollOver() {
        LogLog.debug((String)("maxBackupIndex=" + this.m_maxBackupIndex));
        if (this.m_maxBackupIndex > 0) {
            File target;
            String timeStamp = this.m_datePattern == null ? "" : this.m_dateFormat.format(new Date(System.currentTimeMillis()));
            File file = new File(this.getIndexedFileName(this.m_maxBackupIndex, timeStamp));
            if (file.exists()) {
                file.delete();
            }
            for (int i = this.m_maxBackupIndex - 1; i >= 1; --i) {
                file = new File(this.getIndexedFileName(i, timeStamp));
                if (!file.exists()) continue;
                target = new File(this.getIndexedFileName(i + 1, timeStamp));
                LogLog.debug((String)("Renaming file " + file + " to " + target));
                file.renameTo(target);
            }
            target = new File(this.getIndexedFileName(1, timeStamp));
            file = new File(this.m_fileName);
            LogLog.debug((String)("Renaming file " + this.m_fileName + " to " + target));
            file.renameTo(target);
        }
    }

    private String getIndexedFileName(int index, String timeStamp) {
        return this.m_baseName + timeStamp + '.' + index + this.m_ext;
    }

    static {
        String pid = System.getProperty(PID_PROPERTY);
        if (pid == null) {
            pid = Integer.toString(new Object().hashCode() >> 2 & 0xFF | (int)System.currentTimeMillis() & 0x7FFFFF00) + 'g';
        }
        s_PID = pid;
    }

    public static abstract class LockType {
        public static LockType INTER_PROC = new LockType("InterProc"){

            public ILock createLock(String name) throws LockException {
                try {
                    return new ComboLock(name);
                }
                catch (IOException ioe) {
                    throw new LockException(ioe);
                }
            }
        };
        public static LockType INTRA_PROC = new LockType("IntraProc"){

            public ILock createLock(String name) {
                return new PropertyLock(name);
            }
        };
        public static LockType NONE = new LockType("None"){

            public ILock createLock(String name) {
                return new ILock(this){
                    private final /* synthetic */ 3 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void acquire() {
                    }

                    public void dispose() {
                    }

                    public void release() {
                    }
                };
            }
        };
        String m_name;

        public static LockType fromString(String lockType) {
            if (lockType == null || lockType.equalsIgnoreCase(NONE.toString())) {
                return NONE;
            }
            if (lockType.equalsIgnoreCase(INTER_PROC.toString())) {
                return INTER_PROC;
            }
            if (lockType.equalsIgnoreCase(INTRA_PROC.toString())) {
                return INTRA_PROC;
            }
            throw new IllegalArgumentException(lockType);
        }

        protected LockType(String name) {
            this.m_name = name;
        }

        public abstract ILock createLock(String var1) throws LockException;

        public String toString() {
            return this.m_name;
        }
    }
}

