/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.XSAttributeI;
import oracle.jdbc.internal.XSAttribute;
import oracle.jdbc.internal.XSNamespace;
import oracle.sql.TIMESTAMPTZ;

class XSNamespaceI
extends XSNamespace {
    String namespaceName = null;
    byte[] namespaceNameBytes;
    XSAttributeI[] attributes = null;
    byte[] timestampBytes = null;
    long flag = 0L;
    byte[][] aclList = null;

    XSNamespaceI() {
    }

    public void setNamespaceName(String string) throws SQLException {
        this.namespaceName = string;
    }

    public void setTimestamp(TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        this.timestampBytes = tIMESTAMPTZ.toBytes();
    }

    private void setTimestamp(byte[] byArray) throws SQLException {
        this.timestampBytes = byArray;
    }

    public void setACLIdList(byte[][] byArray) throws SQLException {
        this.aclList = byArray;
    }

    public void setFlag(long l2) throws SQLException {
        this.flag = l2;
    }

    public void setAttributes(XSAttribute[] xSAttributeArray) throws SQLException {
        if (xSAttributeArray != null) {
            XSAttributeI[] xSAttributeIArray = new XSAttributeI[xSAttributeArray.length];
            for (int i2 = 0; i2 < xSAttributeArray.length; ++i2) {
                xSAttributeIArray[i2] = (XSAttributeI)xSAttributeArray[i2];
            }
            this.attributes = xSAttributeIArray;
        }
    }

    void doCharConversion(DBConversion dBConversion) throws SQLException {
        this.namespaceNameBytes = (byte[])(this.namespaceName != null ? dBConversion.StringToCharBytes(this.namespaceName) : null);
        if (this.attributes != null) {
            for (int i2 = 0; i2 < this.attributes.length; ++i2) {
                this.attributes[i2].doCharConversion(dBConversion);
            }
        }
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public TIMESTAMPTZ getTimestamp() {
        return new TIMESTAMPTZ(this.timestampBytes);
    }

    public long getFlag() {
        return this.flag;
    }

    public XSAttribute[] getAttributes() {
        return this.attributes;
    }

    public byte[][] getACLIdList() {
        return this.aclList;
    }

    void marshal(T4CMAREngine t4CMAREngine) throws IOException {
        if (this.namespaceNameBytes != null) {
            t4CMAREngine.marshalUB4(this.namespaceNameBytes.length);
            t4CMAREngine.marshalCLR(this.namespaceNameBytes, this.namespaceNameBytes.length);
        } else {
            t4CMAREngine.marshalUB4(0L);
        }
        if (this.timestampBytes != null) {
            t4CMAREngine.marshalUB4(this.timestampBytes.length);
            t4CMAREngine.marshalCLR(this.timestampBytes, this.timestampBytes.length);
        } else {
            t4CMAREngine.marshalUB4(0L);
        }
        t4CMAREngine.marshalUB4(this.flag);
        if (this.attributes != null) {
            t4CMAREngine.marshalUB4(this.attributes.length);
            t4CMAREngine.marshalUB1((short)28);
            for (int i2 = 0; i2 < this.attributes.length; ++i2) {
                this.attributes[i2].marshal(t4CMAREngine);
            }
        } else {
            t4CMAREngine.marshalUB4(0L);
        }
        if (this.aclList != null) {
            byte[] byArray = new byte[this.aclList.length * 16];
            for (int i3 = 0; i3 < this.aclList.length; ++i3) {
                System.arraycopy(this.aclList[i3], 0, byArray, 16 * i3, 16);
            }
            t4CMAREngine.marshalUB4(byArray.length);
            t4CMAREngine.marshalCLR(byArray, byArray.length);
        } else {
            t4CMAREngine.marshalUB4(0L);
        }
    }

    static XSNamespaceI unmarshal(T4CMAREngine t4CMAREngine) throws SQLException, IOException {
        Object object;
        int n2;
        byte[] byArray;
        int[] nArray = new int[1];
        String string = null;
        int n3 = (int)t4CMAREngine.unmarshalUB4();
        if (n3 > 0) {
            byArray = new byte[n3];
            t4CMAREngine.unmarshalCLR(byArray, 0, nArray);
            string = t4CMAREngine.conv.CharBytesToString(byArray, nArray[0]);
        }
        byArray = null;
        int n4 = (int)t4CMAREngine.unmarshalUB4();
        if (n4 > 0) {
            byArray = t4CMAREngine.unmarshalNBytes(n4);
        }
        long l2 = t4CMAREngine.unmarshalUB4();
        XSAttribute[] xSAttributeArray = null;
        int n5 = (int)t4CMAREngine.unmarshalUB4();
        xSAttributeArray = new XSAttribute[n5];
        if (n5 > 0) {
            t4CMAREngine.unmarshalUB1();
        }
        for (n2 = 0; n2 < n5; ++n2) {
            xSAttributeArray[n2] = XSAttributeI.unmarshal(t4CMAREngine);
        }
        n2 = (int)t4CMAREngine.unmarshalUB4();
        Object object2 = null;
        if (n2 > 0) {
            object = new byte[n2];
            t4CMAREngine.unmarshalCLR((byte[])object, 0, nArray);
            int n6 = n2 / 16;
            object2 = new byte[n6][];
            for (int i2 = 0; i2 < n6; ++i2) {
                object2[i2] = new byte[16];
                System.arraycopy(object, i2 * 16, object2[i2], 0, 16);
            }
        }
        object = new XSNamespaceI();
        ((XSNamespaceI)object).setNamespaceName(string);
        super.setTimestamp(byArray);
        ((XSNamespaceI)object).setFlag(l2);
        ((XSNamespaceI)object).setAttributes(xSAttributeArray);
        ((XSNamespaceI)object).setACLIdList((byte[][])object2);
        return object;
    }
}

