/*
 * Decompiled with CFR 0.152.
 */
package com.pietjonas.wmfwriter2d;

import com.pietjonas.wmfwriter2d.GraphicsState;
import com.pietjonas.wmfwriter2d.WMF;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.text.AttributedCharacterIterator;

public class WMFGraphics
extends Graphics {
    WMF wmf;
    Color foreground;
    Color background;
    Font font = new Font("Helvetica", 0, 12);
    int penstyle = 0;
    int penwidth = 1;
    int brushfillstyle = 0;
    int brushhatch = 0;
    int fontescapement = 0;
    Image brushpattern = null;
    int penhandle;
    int brushhandle;
    int fonthandle;
    Rectangle clip;
    Point origin = new Point(0, 0);
    GraphicsState state;

    public WMFGraphics(WMF wmf, int width, int height) {
        this(wmf, width, height, Color.black, Color.white);
    }

    public WMFGraphics(WMF wmf, int width, int height, Color foreground, Color background) {
        this.foreground = foreground;
        this.background = background;
        this.state = new GraphicsState();
        this.state.increaseCount();
        this.setWMF(wmf, width, height);
        this.reset();
    }

    WMFGraphics(WMF wmf, GraphicsState state, Color foreground, Color background, Font font, int penstyle, int penwidth, int brushfillstyle, int brushhatch, int fontescapement, Image brushpattern, Point origin, Rectangle clip) {
        this.wmf = wmf;
        this.state = state;
        state.increaseCount();
        this.foreground = foreground;
        this.background = background;
        this.font = font;
        this.penstyle = penstyle;
        this.penwidth = penwidth;
        this.brushfillstyle = brushfillstyle;
        this.brushhatch = brushhatch;
        this.fontescapement = fontescapement;
        this.brushpattern = brushpattern;
        this.origin = new Point(origin.x, origin.y);
        if (clip != null) {
            this.clip = new Rectangle(clip);
        } else {
            clip = null;
        }
        this.createWMFHandles();
        this.setGDIPen();
        this.setGDIHollowBrush();
        this.setGDIFont();
    }

    private void setup(int width, int height) {
        this.wmf.setMapMode(8);
        this.wmf.setWindowOrg(0, 0);
        this.wmf.setWindowExt(width, height);
        this.wmf.setTextAlign(24);
        this.wmf.setBKMode(1);
        this.wmf.setBKColor(this.background);
        this.wmf.setTextColor(this.foreground);
        this.wmf.setPolyFillMode(1);
        this.wmf.setStretchBltMode(3);
        this.wmf.setROP2(13);
        this.wmf.setTextCharacterExtra(0);
    }

    public void reset() {
        this.setPenStyle(0);
        this.setPenWidth(1);
        this.setBrushFillStyle(0);
        this.setBrushHatch(0);
        this.setFontEscapement(0);
    }

    public void restoreState() {
        if (this.state.getCount() > 1) {
            if (this.penhandle != this.state.getPen()) {
                this.wmf.selectObject(this.penhandle);
                this.state.setPen(this.penhandle);
            }
            if (this.brushhandle != this.state.getBrush()) {
                this.wmf.selectObject(this.brushhandle);
                this.state.setBrush(this.brushhandle);
            }
            if (this.fonthandle != this.state.getFont()) {
                this.wmf.selectObject(this.fonthandle);
                this.state.setFont(this.fonthandle);
            }
            if (this.clip != this.state.getClip()) {
                this.setClip(this.clip);
                this.state.setClip(this.clip);
            }
            if (!this.origin.equals(this.state.getOrigin())) {
                this.translate(this.origin.x, this.origin.y);
                this.state.setOrigin(this.origin);
            }
        }
    }

    public void setPenStyle(int style) {
        this.penstyle = style;
        this.setGDIPen();
    }

    public int getPenStyle() {
        return this.penstyle;
    }

    public void setPenWidth(int width) {
        this.penwidth = width;
        this.setGDIPen();
    }

    public int getPenWidth() {
        return this.penwidth;
    }

    public void setBrushFillStyle(int style) {
        this.brushfillstyle = style;
    }

    public int getBrushFillStyle() {
        return this.brushfillstyle;
    }

    public void setBrushHatch(int hatch) {
        this.brushhatch = hatch;
    }

    public int getBrushHatch() {
        return this.brushhatch;
    }

    public void setBrushPattern(Image pattern) {
        this.brushpattern = pattern;
    }

    public Image getBrushPattern() {
        return this.brushpattern;
    }

    public void setFontEscapement(int escapement) {
        this.fontescapement = escapement;
        this.setGDIFont();
    }

    public int getFontEscapement() {
        return this.fontescapement;
    }

    public void createWMFHandles() {
        this.penhandle = this.wmf.createPenIndirect(this.penstyle, this.penwidth, this.foreground);
        this.wmf.selectObject(this.penhandle);
        this.state.setPen(this.penhandle);
        this.brushhandle = this.wmf.createBrushIndirect(1, this.foreground, this.brushhatch);
        this.wmf.selectObject(this.brushhandle);
        this.state.setPen(this.brushhandle);
        this.fonthandle = this.wmf.createFont(this.font, this.fontescapement, false, false);
        this.wmf.selectObject(this.fonthandle);
        this.state.setPen(this.fonthandle);
    }

    public void setWMF(WMF newwmf, int width, int height) {
        this.wmf = newwmf;
        this.createWMFHandles();
        this.setup(width, height);
    }

    public WMF getWMF() {
        return this.wmf;
    }

    public int setGDIPen() {
        int oldpenhandle = this.penhandle;
        this.penhandle = this.wmf.createPenIndirect(this.penstyle, this.penwidth, this.foreground);
        this.wmf.selectObject(this.penhandle);
        this.wmf.deleteObject(oldpenhandle);
        this.state.setPen(this.penhandle);
        return this.penhandle;
    }

    public int setGDIHollowBrush() {
        int oldbrushhandle = this.brushhandle;
        this.brushhandle = this.wmf.createBrushIndirect(1, this.foreground, this.brushhatch);
        this.wmf.selectObject(this.brushhandle);
        this.wmf.deleteObject(oldbrushhandle);
        this.state.setBrush(this.brushhandle);
        return this.brushhandle;
    }

    public int setGDIFillBrush() {
        int oldbrushhandle;
        block7: {
            oldbrushhandle = this.brushhandle;
            if (this.brushfillstyle == 3) {
                if (this.brushpattern != null) {
                    int w = this.brushpattern.getWidth(null);
                    int h = this.brushpattern.getHeight(null);
                    int[] pix = new int[w * h];
                    PixelGrabber pg = new PixelGrabber(this.brushpattern, 0, 0, w, h, pix, 0, w);
                    try {
                        pg.grabPixels();
                        if ((pg.status() & 0x80) != 0) {
                            this.brushhandle = this.wmf.createBrushIndirect(0, this.foreground, this.brushhatch);
                            break block7;
                        }
                        this.brushhandle = this.wmf.createPatternBrush(pix, w, h);
                    }
                    catch (InterruptedException e) {
                        this.brushhandle = this.wmf.createBrushIndirect(0, this.foreground, this.brushhatch);
                    }
                } else {
                    this.brushhandle = this.wmf.createBrushIndirect(0, this.foreground, this.brushhatch);
                }
            } else {
                this.brushhandle = this.wmf.createBrushIndirect(this.brushfillstyle, this.foreground, this.brushhatch);
            }
        }
        this.wmf.selectObject(this.brushhandle);
        this.wmf.deleteObject(oldbrushhandle);
        this.state.setBrush(this.brushhandle);
        return this.brushhandle;
    }

    public int setGDIFont() {
        int oldfonthandle = this.fonthandle;
        this.fonthandle = this.wmf.createFont(this.font, this.fontescapement, false, false);
        this.wmf.selectObject(this.fonthandle);
        this.wmf.deleteObject(oldfonthandle);
        this.state.setFont(this.fonthandle);
        return this.fonthandle;
    }

    public void deleteGDIObjects() {
        this.wmf.deleteObject(this.penhandle);
        this.wmf.deleteObject(this.brushhandle);
        this.wmf.deleteObject(this.fonthandle);
    }

    public void GDIPolyPolygon(Polygon[] polys) {
        this.restoreState();
        this.setGDIFillBrush();
        this.wmf.polypolygon(polys);
        this.setGDIHollowBrush();
    }

    public void clearRect(int x, int y, int width, int height) {
        this.restoreState();
        Color old = this.foreground;
        this.setColor(this.background);
        this.fillRect(x, y, width, height);
        this.setColor(old);
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        System.err.println("copyArea not supported");
    }

    public Graphics create() {
        WMFGraphics g = new WMFGraphics(this.wmf, this.state, this.foreground, this.background, this.font, this.penstyle, this.penwidth, this.brushfillstyle, this.brushhatch, this.fontescapement, this.brushpattern, this.origin, this.clip);
        return g;
    }

    public void dispose() {
        this.state.decreaseCount();
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.restoreState();
        int xmiddle = x + width / 2;
        int ymiddle = y + height / 2;
        this.wmf.arc(x, y, x + width + 1, y + height + 1, xmiddle + (int)Math.round((double)width * Math.sin(Math.PI * 2 * (double)(startAngle + 90) / 360.0)), ymiddle + (int)Math.round((double)height * Math.cos(Math.PI * 2 * (double)(startAngle + 90) / 360.0)), xmiddle + (int)Math.round((double)width * Math.sin(Math.PI * 2 * (double)(startAngle + arcAngle + 90) / 360.0)), ymiddle + (int)Math.round((double)height * Math.cos(Math.PI * 2 * (double)(startAngle + arcAngle + 90) / 360.0)));
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        this.restoreState();
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        this.restoreState();
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        this.restoreState();
        return this.drawImage(img, x, y, x + width, y + height, 0, 0, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        this.restoreState();
        return this.drawImage(img, x, y, x + width, y + height, 0, 0, img.getWidth(observer), img.getHeight(observer), observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        this.restoreState();
        int w = img.getWidth(observer);
        int h = img.getHeight(observer);
        int[] pix = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, w, h, pix, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            return false;
        }
        if ((pg.status() & 0x80) != 0) {
            return false;
        }
        int dwidth = dx2 - dx1;
        int dheight = dy2 - dy1;
        int swidth = sx2 - sx1;
        int sheight = sy2 - sy1;
        int tmp = sy2;
        sy2 = h - sy1;
        sy1 = h - tmp;
        if (dwidth < 0 != swidth < 0) {
            this.flipHorizontal(pix, w, h);
            sx1 = swidth < 0 ? w - sx1 : w - sx2;
        }
        if (dwidth < 0) {
            dx1 = dx2;
            if (swidth < 0) {
                sx1 = sx2;
            }
            dwidth = -dwidth;
        }
        if (swidth < 0) {
            swidth = -swidth;
        }
        if (dheight < 0 != sheight < 0) {
            this.flipVertical(pix, w, h);
            sy1 = sheight < 0 ? h - sy1 : h - sy2;
        }
        if (dheight < 0) {
            dy1 = dy2;
            if (sheight < 0) {
                sy1 = sy2;
            }
            dheight = -dheight;
        }
        if (sheight < 0) {
            sheight = -sheight;
        }
        int backrgb = bgcolor.getRGB();
        for (int i = 0; i < pix.length; ++i) {
            if ((pix[i] & 0xFF000000) != 0) continue;
            pix[i] = backrgb;
        }
        this.wmf.stretchBlt(dx1, dy1, dwidth, dheight, sx1, sy1, swidth, sheight, 0xCC0020, pix, w, h);
        return true;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        this.restoreState();
        int w = img.getWidth(observer);
        int h = img.getHeight(observer);
        int[] pix = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, w, h, pix, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            return false;
        }
        if ((pg.status() & 0x80) != 0) {
            return false;
        }
        int dwidth = dx2 - dx1;
        int dheight = dy2 - dy1;
        int swidth = sx2 - sx1;
        int sheight = sy2 - sy1;
        int tmp = sy2;
        sy2 = h - sy1;
        sy1 = h - tmp;
        if (dwidth < 0 != swidth < 0) {
            this.flipHorizontal(pix, w, h);
            sx1 = swidth < 0 ? w - sx1 : w - sx2;
        }
        if (dwidth < 0) {
            dx1 = dx2;
            if (swidth < 0) {
                sx1 = sx2;
            }
            dwidth = -dwidth;
        }
        if (swidth < 0) {
            swidth = -swidth;
        }
        if (dheight < 0 != sheight < 0) {
            this.flipVertical(pix, w, h);
            sy1 = sheight < 0 ? h - sy1 : h - sy2;
        }
        if (dheight < 0) {
            dy1 = dy2;
            if (sheight < 0) {
                sy1 = sy2;
            }
            dheight = -dheight;
        }
        if (sheight < 0) {
            sheight = -sheight;
        }
        int[] mask = new int[pix.length];
        boolean needmask = false;
        for (int i = 0; i < pix.length; ++i) {
            if ((pix[i] & 0xFF000000) == 0) {
                mask[i] = -1;
                pix[i] = 0;
                needmask = true;
                continue;
            }
            mask[i] = 0;
        }
        if (needmask) {
            this.wmf.stretchBlt(dx1, dy1, dwidth, dheight, sx1, sy1, swidth, sheight, 8913094, mask, w, h);
            this.wmf.stretchBlt(dx1, dy1, dwidth, dheight, sx1, sy1, swidth, sheight, 15597702, pix, w, h);
        } else {
            this.wmf.stretchBlt(dx1, dy1, dwidth, dheight, sx1, sy1, swidth, sheight, 0xCC0020, pix, w, h);
        }
        return true;
    }

    private void flipHorizontal(int[] pix, int width, int height) {
        for (int i = 0; i < height; ++i) {
            int shift = i * height;
            for (int j = 0; j < width / 2; ++j) {
                int tmp = pix[shift + j];
                pix[shift + j] = pix[shift + width - 1 - j];
                pix[shift + width - 1 - j] = tmp;
            }
        }
    }

    private void flipVertical(int[] pix, int width, int height) {
        int[] line = new int[width];
        for (int i = 0; i < height / 2; ++i) {
            System.arraycopy(pix, i * width, line, 0, width);
            System.arraycopy(pix, (height - i - 1) * width, pix, i * width, width);
            System.arraycopy(line, 0, pix, (height - i - 1) * width, width);
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.restoreState();
        this.wmf.moveTo(x1, y1);
        this.wmf.lineTo(x2, y2);
        this.wmf.setPixel(x2, y2, this.getColor());
    }

    public void drawOval(int x, int y, int width, int height) {
        this.restoreState();
        this.wmf.ellipse(x, y, x + width + 1, y + height + 1);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.restoreState();
        this.wmf.polygon(xPoints, yPoints, nPoints);
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.restoreState();
        this.wmf.polyline(xPoints, yPoints, nPoints);
        this.wmf.setPixel(xPoints[nPoints - 1], yPoints[nPoints - 1], this.getColor());
    }

    public void drawRect(int x, int y, int width, int height) {
        this.restoreState();
        this.wmf.rectangle(x, y, x + width + 1, y + height + 1);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.restoreState();
        this.wmf.roundRect(x, y, x + width + 1, y + height + 1, arcWidth, arcHeight);
    }

    public void drawString(String str, int x, int y) {
        this.restoreState();
        this.wmf.textOut(x, y, str);
    }

    public void drawString(AttributedCharacterIterator text, int x, int y) {
        System.err.println("drawString(java.text.AttributedCharacterIterator,..) not supported");
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.restoreState();
        this.setGDIFillBrush();
        int xmiddle = x + width / 2;
        int ymiddle = y + height / 2;
        this.wmf.pie(x, y, x + width + 1, y + height + 1, xmiddle + (int)Math.round((double)width * Math.sin(Math.PI * 2 * (double)(startAngle + 90) / 360.0)), ymiddle + (int)Math.round((double)height * Math.cos(Math.PI * 2 * (double)(startAngle + 90) / 360.0)), xmiddle + (int)Math.round((double)width * Math.sin(Math.PI * 2 * (double)(startAngle + arcAngle + 90) / 360.0)), ymiddle + (int)Math.round((double)height * Math.cos(Math.PI * 2 * (double)(startAngle + arcAngle + 90) / 360.0)));
        this.setGDIHollowBrush();
    }

    public void fillOval(int x, int y, int width, int height) {
        this.restoreState();
        this.setGDIFillBrush();
        this.drawOval(x, y, width - 1, height - 1);
        this.setGDIHollowBrush();
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.restoreState();
        this.setGDIFillBrush();
        this.drawPolygon(xPoints, yPoints, nPoints);
        this.setGDIHollowBrush();
    }

    public void fillRect(int x, int y, int width, int height) {
        this.restoreState();
        this.setGDIFillBrush();
        this.drawRect(x, y, width - 1, height - 1);
        this.setGDIHollowBrush();
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.restoreState();
        this.setGDIFillBrush();
        this.drawRoundRect(x, y, width - 1, height - 1, arcWidth, arcHeight);
        this.setGDIHollowBrush();
    }

    public void clipRect(int x, int y, int width, int height) {
        this.restoreState();
        this.wmf.intersectClipRect(x, y, x + width + 1, y + height + 1);
        Rectangle r = new Rectangle(x, y, width, height);
        this.clip = this.clip != null ? this.clip.intersection(r) : r;
        this.state.setClip(this.clip);
    }

    public Shape getClip() {
        return this.getClipBounds();
    }

    public Rectangle getClipRect() {
        return this.getClipBounds();
    }

    public Rectangle getClipBounds() {
        if (this.clip != null) {
            return new Rectangle(this.clip);
        }
        return null;
    }

    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    public void setClip(Shape clipshape) {
        this.wmf.setClipRgn();
        this.clip = null;
        if (clipshape != null) {
            Rectangle r = clipshape.getBounds();
            this.clipRect(r.x, r.y, r.width, r.height);
        }
    }

    public Color getColor() {
        return this.foreground;
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics(Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    public void setColor(Color newcolor) {
        this.restoreState();
        this.foreground = newcolor;
        this.setGDIPen();
        this.wmf.setTextColor(this.foreground);
    }

    public void setFont(Font newfont) {
        this.restoreState();
        this.font = newfont;
        this.setGDIFont();
    }

    public void setPaintMode() {
        System.err.println("setPaintMode not supported");
    }

    public void setXORMode(Color c1) {
        System.err.println("setXORMode not supported");
    }

    public void translate(int x, int y) {
        this.origin.translate(x, y);
        this.wmf.setWindowOrg(-this.origin.x, -this.origin.y);
        this.state.setOrigin(this.origin);
    }
}

