/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.settings;

import com.businessobjects.visualization.graphic.VisuBool;
import com.businessobjects.visualization.graphic.VisuColor;
import com.businessobjects.visualization.graphic.VisuDouble;
import com.businessobjects.visualization.graphic.VisuGradient;
import com.businessobjects.visualization.graphic.VisuInteger;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuRGBA;
import com.businessobjects.visualization.graphic.VisuState;
import com.businessobjects.visualization.graphic.VisuString;
import com.businessobjects.visualization.pfjgraphics.settings.CVOMid;
import com.businessobjects.visualization.pfjgraphics.settings.SettingsTransform;
import java.awt.Color;
import org.apache.log4j.Logger;

public class IdentityTransform
extends SettingsTransform {
    static Logger logger = Logger.getLogger((String)"com.businessobjects.visualization.pfjgraphics.settings.IdentityTransform");

    double xform2CVOM(double val) {
        return val;
    }

    double xform2PFJ(double val) {
        return val;
    }

    String map2CVOM(int val) {
        logger.error((Object)("map2CVOM called for IdentityTransform: " + val));
        return Integer.toString(val);
    }

    int map2PFJ(String val) {
        logger.error((Object)("map2PFJ called for IdentityTransform: " + val));
        return Integer.parseInt(val);
    }

    boolean logicalOp(boolean val) {
        return val;
    }

    VisuObject convert(Double val) {
        return new VisuDouble(this.xform2CVOM(val));
    }

    Object convert(VisuDouble val) {
        return new Double(this.xform2PFJ(val.doubleValue()));
    }

    VisuObject convert(Integer val) {
        return new VisuInteger((int)this.xform2CVOM(val.intValue()));
    }

    Object convert(VisuInteger val) {
        return new Integer((int)this.xform2PFJ(val.intValue()));
    }

    public VisuObject toCVOM(Object obj, CVOMid.vType valueType) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Integer) {
            if (valueType == CVOMid.vType.STATE) {
                return new VisuState(this.map2CVOM((Integer)obj));
            }
            return this.convert((Integer)obj);
        }
        if (obj instanceof Boolean) {
            return this.logicalOp((Boolean)obj) ? VisuBool.TRUE : VisuBool.FALSE;
        }
        if (obj instanceof Double) {
            return this.convert((Double)obj);
        }
        if (obj instanceof Float) {
            return this.convert(Double.valueOf(((Float)obj).floatValue()));
        }
        if (obj instanceof String) {
            return new VisuString((String)obj);
        }
        if (obj instanceof Color) {
            Color c = (Color)obj;
            return new VisuColor(c.getRed(), c.getGreen(), c.getBlue(), 255 - c.getAlpha());
        }
        logger.error((Object)("toCVOM, Unknown Object: " + obj.toString()));
        return new VisuInteger(0);
    }

    public Object toPFJ(VisuObject vObj) {
        if (vObj == null) {
            return null;
        }
        switch (vObj.getType().value()) {
            case 1: {
                return this.convert((VisuInteger)vObj);
            }
            case 0: {
                return this.logicalOp(((VisuBool)vObj).booleanValue());
            }
            case 2: {
                return this.convert((VisuDouble)vObj);
            }
            case 3: {
                return ((VisuString)vObj).getXmlValue();
            }
            case 6: {
                return this.map2PFJ(((VisuState)vObj).getId());
            }
            case 9: {
                VisuRGBA vrgba = (VisuRGBA)vObj;
                return new Color(vrgba.getRed(), vrgba.getGreen(), vrgba.getBlue(), 255 - vrgba.getAlpha());
            }
            case 5: {
                switch (((VisuColor)vObj).getColorType().value()) {
                    case 0: 
                    case 3: {
                        VisuRGBA vc = (VisuRGBA)((VisuColor)vObj).getValue();
                        return new Color(vc.getRed(), vc.getGreen(), vc.getBlue(), 255 - vc.getAlpha());
                    }
                    case 1: {
                        int r = 0;
                        int g = 0;
                        int b = 0;
                        int a = 0;
                        int n = 0;
                        for (VisuRGBA colors : ((VisuGradient)((VisuColor)vObj).getValue()).getColors()) {
                            r += colors.getRed();
                            g += colors.getGreen();
                            b += colors.getBlue();
                            a += colors.getAlpha();
                            ++n;
                        }
                        n = Math.max(1, n);
                        return new Color(r / n, g / n, b / n, a / n);
                    }
                }
                logger.error((Object)("toPFJ, Unsupported VisuColor: " + vObj.toString()));
                return new Color(0);
            }
        }
        logger.error((Object)("toPFJ, Unknown VisuObject: " + vObj.toString()));
        return new Integer(10);
    }
}

