/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.place;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.LegendObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.place.PlaceUtilities;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.utility.RectangleUtil;
import java.awt.Rectangle;

public class PlaceDefaultElementsLegend {
    static final int PLACEPOSITION_AUTO = 0;
    static final int PLACEPOSITION_BOTTOM = 1;
    static final int PLACEPOSITION_FREEFLOAT = 3;
    static final int PLACEPOSITION_RIGHTCENTER = 4;
    public static final int PLACEPOSITION_RIGHT_TOP = 2;

    private PlaceDefaultElementsLegend() {
    }

    public static final void place(Perspective p, Rectangle rAvailableSpace) {
        if (PlaceDefaultElementsLegend.okToPlaceLegend(p)) {
            PlaceUtilities.legendCalc(p);
            Rectangle rLookLegend = p.getLegendRect();
            int placePosition = p.getLegendPosition();
            int reduceAmount = 0;
            int reduceArea = 1;
            switch (placePosition) {
                case 1: 
                case 9: 
                case 10: {
                    reduceAmount = rLookLegend.height;
                    reduceArea = 1;
                    rLookLegend.y = rAvailableSpace.y;
                    break;
                }
                case 4: 
                case 11: 
                case 12: {
                    reduceAmount = rLookLegend.height;
                    reduceArea = 4;
                    rLookLegend.y = rAvailableSpace.height + rAvailableSpace.y - rLookLegend.height;
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    reduceAmount = rLookLegend.width;
                    reduceArea = 2;
                    rLookLegend.x = rAvailableSpace.x + rAvailableSpace.width - rLookLegend.width;
                    break;
                }
                case 3: 
                case 7: 
                case 8: {
                    reduceAmount = rLookLegend.width;
                    reduceArea = 3;
                    rLookLegend.x = rAvailableSpace.x;
                    break;
                }
                case 0: {
                    int orientation = LegendObj.getLegendOrientation(p);
                    if (orientation == 1) {
                        reduceAmount = rLookLegend.height;
                        reduceArea = 1;
                        rLookLegend.y = rAvailableSpace.y;
                        break;
                    }
                    reduceAmount = rLookLegend.width;
                    reduceArea = 2;
                    rLookLegend.x = rAvailableSpace.x + rAvailableSpace.width - rLookLegend.width;
                    break;
                }
            }
            p.setLegendRect(rLookLegend);
            RectangleUtil.subtract(rAvailableSpace, reduceAmount + 500, reduceArea);
        }
    }

    static boolean okToPlaceLegend(Perspective p) {
        return p.getDisplay(Identity.LegendArea) && p.getJGraphType().hasLegend();
    }
}

