/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.place;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JGraphType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisUtils;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.place.PlaceDefaultElements;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.place.PlaceUtilities;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.utility.RectangleUtil;
import java.awt.Dimension;
import java.awt.Rectangle;

class PlaceDefaultElements2D {
    private PlaceDefaultElements2D() {
    }

    static final void place(Perspective perspective, Rectangle availableSpace_, Rectangle desiredFrame) {
        Rectangle availableSpace = new Rectangle(availableSpace_);
        availableSpace = PlaceDefaultElements2D.placeYTitles(perspective, availableSpace);
        availableSpace = PlaceDefaultElements2D.placeXorOTitle(perspective, availableSpace);
        if (perspective.getJGraphType().isOrientHorz()) {
            availableSpace = PlaceDefaultElements2D.placeXorOAxisLabels(perspective, availableSpace, desiredFrame);
            availableSpace = PlaceDefaultElements.placeYLabels(perspective, availableSpace, desiredFrame);
        } else {
            availableSpace = PlaceDefaultElements.placeYLabels(perspective, availableSpace, desiredFrame);
            availableSpace = PlaceDefaultElements2D.placeXorOAxisLabels(perspective, availableSpace, desiredFrame);
        }
        PlaceDefaultElements2D.centerTitles(perspective, availableSpace);
        PlaceUtilities.setChartFrame(perspective, PlaceUtilities.getPlaceResizeFrame(perspective, availableSpace, desiredFrame));
    }

    private static void centerTitles(Perspective p, Rectangle availableRect) {
        boolean isX1 = p.hasX1();
        boolean isY2 = p.getJGraphType().getAxisDescriptor().hasY2();
        IdentObj xId = Identity.O1Label;
        IdentObj yId = Identity.Y1Label;
        if (isX1) {
            xId = Identity.X1Label;
        }
        Rectangle xRect = p.getRect(xId);
        xRect.x = availableRect.x;
        xRect.width = availableRect.width;
        PlaceUtilities.setAxisTitleRectIfOK(p, xId, availableRect);
        if (!isY2) {
            Rectangle yRect = p.getRect(yId);
            yRect.y = availableRect.y;
            yRect.height = availableRect.height;
            PlaceUtilities.setAxisTitleRectIfOK(p, yId, availableRect);
        }
    }

    private static Rectangle placeXorOAxisLabels(Perspective p, Rectangle availableSpace, Rectangle desiredFrame) {
        IdentObj axisID;
        IdentObj labelID;
        Rectangle rContainingRectVC = new Rectangle(availableSpace);
        JGraphType type = p.getJGraphType();
        boolean isHoriz = type.isOrientHorz();
        if (p.hasX1() && p.getX1LabelDisplay()) {
            labelID = Identity.X1Label;
            axisID = Identity.X1Axis;
        } else if (p.hasO1() && p.getO1LabelDisplay()) {
            labelID = Identity.O1Label;
            axisID = Identity.O1Axis;
        } else {
            return rContainingRectVC;
        }
        IAxis axisObj = AxisUtils.getAxisObj(p, labelID.getObjectID());
        PlaceUtilities.axisCalc(p, labelID.getObjectID(), PlaceUtilities.getPlaceResizeFrame(p, availableSpace, desiredFrame));
        Rectangle labelBoundingBox = axisObj.getLabelBoundingBoxVC();
        if (labelBoundingBox == null) {
            return rContainingRectVC;
        }
        int axisSide = AxisUtils.getRectangleSide(p, axisID, isHoriz);
        if (isHoriz) {
            RectangleUtil.subtract(rContainingRectVC, labelBoundingBox.width + 50, axisSide, PlaceDefaultElements.MIN_FRAME_DIMENSION_VC);
        } else {
            RectangleUtil.subtract(rContainingRectVC, labelBoundingBox.height + 50, axisSide, PlaceDefaultElements.MIN_FRAME_DIMENSION_VC);
        }
        return rContainingRectVC;
    }

    private static Rectangle placeXorOTitle(Perspective p, Rectangle containingRectVC) {
        Rectangle rAvailableSpace = new Rectangle(containingRectVC);
        IdentObj titleID = null;
        IdentObj axisID = null;
        if (p.hasX1() && p.getX1TitleDisplay()) {
            titleID = Identity.X1Title;
            axisID = Identity.X1Axis;
        } else if (p.hasO1() && p.getO1TitleDisplay()) {
            titleID = Identity.O1Title;
            axisID = Identity.O1Axis;
        } else {
            return rAvailableSpace;
        }
        int side = AxisUtils.getRectangleSide(p, axisID, p.getJGraphType().isOrientHorz());
        PlaceDefaultElements2D.insertTitleSpace(p, rAvailableSpace, titleID, side);
        return rAvailableSpace;
    }

    static Rectangle placeYTitles(Perspective p, Rectangle containingRectVC) {
        Rectangle availableRect = new Rectangle(containingRectVC);
        boolean isHoriz = p.getJGraphType().isOrientHorz();
        IdentObj id = Identity.Y1Title;
        int side = AxisUtils.getRectangleSide(p, Identity.Y1Axis, !isHoriz);
        if (p.getDisplay(id)) {
            PlaceDefaultElements2D.insertTitleSpace(p, availableRect, id, side);
        }
        id = Identity.Y2Title;
        side = AxisUtils.getRectangleSide(p, Identity.Y2Axis, !isHoriz);
        if (p.getDisplay(id)) {
            PlaceDefaultElements2D.insertTitleSpace(p, availableRect, id, side);
        }
        return availableRect;
    }

    private static void insertTitleSpace(Perspective p, Rectangle availableRect, IdentObj id, int side) {
        if (RectangleUtil.hasSide(side, 3)) {
            side = 3;
        } else if (RectangleUtil.hasSide(side, 1)) {
            side = 1;
        }
        int wrapWidth = 0;
        wrapWidth = RectangleUtil.hasSide(side, 3) || RectangleUtil.hasSide(side, 2) ? availableRect.height : availableRect.width;
        if (p.getJGraphType().isDualY()) {
            wrapWidth /= 2;
        }
        PlaceUtilities.addWordWrapIfNeeded(p, id, wrapWidth);
        Dimension textDim = PlaceDefaultElements.getTitleDim(p, id, wrapWidth);
        if (textDim.height > 0) {
            int h = textDim.height + 400;
            RectangleUtil.subtract(availableRect, h, side);
        }
    }
}

