/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;

class GradientPaintExtContext
implements PaintContext {
    public static final double SMALL = (double)0.001f;
    double dgdX;
    double dgdY;
    double gc;
    int[] gradient;
    double[] I;
    private static final ColorModel xrgbmodel = new DirectColorModel(24, 0xFF0000, 65280, 255);
    private Raster saved;
    private ColorModel model;
    private boolean cyclic;

    public GradientPaintExtContext(Point2D inStart, Point2D inEnd, double[] I, Color[] colors, AffineTransform t, boolean cyclic) throws NoninvertibleTransformException {
        Point2D.Double start = new Point2D.Double();
        start.setLocation(inStart);
        Point2D.Double end = new Point2D.Double();
        end.setLocation(inEnd);
        this.cyclic = cyclic;
        if (cyclic) {
            int i;
            end = (Point2D.Double)end.clone();
            end.x += end.getX() - start.getX();
            end.y += end.getY() - start.getY();
            Color[] tmpColors = new Color[colors.length * 2 - 1];
            System.arraycopy(colors, 0, tmpColors, 0, colors.length);
            for (int i2 = 0; i2 < colors.length - 1; ++i2) {
                tmpColors[colors.length + i2] = colors[colors.length - i2 - 2];
            }
            double[] tmpI = new double[I.length * 2];
            for (i = 0; i < I.length; ++i) {
                tmpI[i] = I[i] / 2.0;
            }
            for (i = 0; i < I.length; ++i) {
                tmpI[I.length + i] = I[I.length - i - 1] / 2.0;
            }
            I = tmpI;
            colors = tmpColors;
        }
        this.I = I;
        AffineTransform tInv = t.createInverse();
        double[] m = new double[6];
        tInv.getMatrix(m);
        Point2D.Double startDS = new Point2D.Double();
        Point2D.Double endDS = new Point2D.Double();
        t.transform(start, startDS);
        t.transform(end, endDS);
        if (((Point2D)startDS).getX() > ((Point2D)endDS).getX()) {
            int i;
            Point2D.Double tmp = start;
            start = end;
            end = tmp;
            double[] tmpI = new double[I.length];
            Color[] tmpColors = new Color[colors.length];
            for (i = 0; i < tmpI.length; ++i) {
                tmpI[i] = I[tmpI.length - i - 1];
            }
            for (i = 0; i < tmpColors.length; ++i) {
                tmpColors[i] = colors[tmpColors.length - i - 1];
            }
            I = tmpI;
            colors = tmpColors;
        }
        double a00 = m[0];
        double a10 = m[1];
        double a01 = m[2];
        double a11 = m[3];
        double a02 = m[4];
        double a12 = m[5];
        double dx = end.getX() - start.getX();
        double dy = end.getY() - start.getY();
        double dSq = dx * dx + dy * dy;
        this.dgdX = a00 * dx / dSq + a10 * dy / dSq;
        this.dgdY = a01 * dx / dSq + a11 * dy / dSq;
        this.gc = (a02 - start.getX()) * dx / dSq + (a12 - start.getY()) * dy / dSq;
        this.createGradients(I, colors);
    }

    public void createGradients(double[] I, Color[] colors) {
        int n = I.length;
        double Imin = 1.0;
        double len = 0.0;
        for (int i = 0; i < n; ++i) {
            len = I[i];
            if (len < (double)0.001f) continue;
            Imin = Imin > len ? len : Imin;
        }
        int transparencyTest = -16777216;
        int[][] gradients = new int[n][];
        int gradientsTot = 1;
        int rgb1 = 0;
        int rgb2 = 0;
        for (int i = 0; i < n; ++i) {
            len = I[i];
            if (len == 0.0) {
                gradients[i] = new int[0];
                continue;
            }
            int nGradients = (int)(I[i] / Imin * 255.0);
            gradientsTot += nGradients;
            gradients[i] = new int[nGradients];
            double stepSize = 1.0 / (double)nGradients;
            rgb1 = colors[i].getRGB();
            rgb2 = colors[i + 1].getRGB();
            int a1 = rgb1 >> 24 & 0xFF;
            int r1 = rgb1 >> 16 & 0xFF;
            int g1 = rgb1 >> 8 & 0xFF;
            int b1 = rgb1 & 0xFF;
            int da = (rgb2 >> 24 & 0xFF) - a1;
            int dr = (rgb2 >> 16 & 0xFF) - r1;
            int dg = (rgb2 >> 8 & 0xFF) - g1;
            int db = (rgb2 & 0xFF) - b1;
            transparencyTest &= rgb1;
            transparencyTest &= rgb2;
            for (int j = 0; j < nGradients; ++j) {
                int rgb;
                gradients[i][j] = rgb = (int)((double)a1 + (double)(j * da) * stepSize) << 24 | (int)((double)r1 + (double)(j * dr) * stepSize) << 16 | (int)((double)g1 + (double)(j * dg) * stepSize) << 8 | (int)((double)b1 + (double)(j * db) * stepSize);
            }
        }
        this.gradient = new int[gradientsTot];
        int curOffset = 0;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(gradients[i], 0, this.gradient, curOffset, gradients[i].length);
            curOffset += gradients[i].length;
        }
        this.gradient[this.gradient.length - 1] = colors[colors.length - 1].getRGB();
        int gradientMaxIndex = this.gradient.length - 1;
        this.dgdX *= (double)gradientMaxIndex;
        this.dgdY *= (double)gradientMaxIndex;
        this.gc *= (double)gradientMaxIndex;
        this.model = transparencyTest >>> 24 == 255 ? xrgbmodel : ColorModel.getRGBdefault();
    }

    public void dispose() {
        this.saved = null;
    }

    public ColorModel getColorModel() {
        return this.model;
    }

    public Raster getRaster(int x, int y, int w, int h) {
        Raster raster = this.saved;
        if (raster == null || raster.getWidth() < w || raster.getHeight() < h) {
            this.saved = raster = this.getColorModel().createCompatibleWritableRaster(w, h);
        }
        DataBufferInt rasterDB = (DataBufferInt)raster.getDataBuffer();
        int[] pixels = rasterDB.getBankData()[0];
        int off = rasterDB.getOffset();
        int scanlineStride = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
        int adjust = scanlineStride - w;
        if (!this.cyclic) {
            this.fillRaster(pixels, off, adjust, w, h, x, y);
        } else {
            this.fillCyclicRaster(pixels, off, adjust, w, h, x, y);
        }
        return raster;
    }

    void fillCyclicRaster(int[] pixels, int off, int adjust, int w, int h, double X, double Y) {
        double gs = 0.0;
        double g = 0.0;
        int rowLimit = off + w;
        double gradientMaxIndex = this.gradient.length - 1;
        for (int i = 0; i < h; ++i) {
            gs = this.dgdX * X + this.dgdY * (Y + (double)i) + this.gc;
            if ((gs %= gradientMaxIndex) < 0.0) {
                gs = gradientMaxIndex + gs;
            }
            g = gs;
            while (off < rowLimit) {
                while (g <= gradientMaxIndex && off < rowLimit) {
                    pixels[off++] = this.gradient[(int)g];
                    g += this.dgdX;
                }
                g %= gradientMaxIndex;
            }
            rowLimit = (off += adjust) + w;
        }
    }

    void fillRaster(int[] pixels, int off, int adjust, int w, int h, double X, double Y) {
        double gs = 0.0;
        double ge = 0.0;
        double g = 0.0;
        int rgb = 0;
        int rowLimit = off + w;
        double gradientMaxIndex = this.gradient.length - 1;
        for (int i = 0; i < h; ++i) {
            gs = this.dgdX * X + this.dgdY * (Y + (double)i) + this.gc;
            ge = gs + this.dgdX * (double)w;
            if (gs >= gradientMaxIndex) {
                rgb = this.gradient[(int)gradientMaxIndex];
                while (off < rowLimit) {
                    pixels[off++] = rgb;
                }
            } else if (ge <= 0.0) {
                rgb = this.gradient[0];
                while (off < rowLimit) {
                    pixels[off++] = rgb;
                }
            } else {
                rgb = this.gradient[0];
                for (g = gs; g <= 0.0 && off < rowLimit; g += this.dgdX) {
                    pixels[off++] = rgb;
                }
                while (g <= gradientMaxIndex && off < rowLimit) {
                    pixels[off++] = this.gradient[(int)g];
                    g += this.dgdX;
                }
                rgb = this.gradient[(int)gradientMaxIndex];
                while (off < rowLimit) {
                    pixels[off++] = rgb;
                }
            }
            rowLimit = (off += adjust) + w;
        }
    }
}

