/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.geom;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxRenderer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.FillGradientObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.apache.log4j.Logger;

public class GradientRenderer1
implements BlackBoxRenderer {
    private static final Logger logger = Logger.getLogger((String)"GradientRenderer1");
    private Paint m_filling = null;
    private final boolean m_bHardcodedGradient = false;
    private double m_fMinHeight = 0.0;
    private double m_fMaxHeight = 0.0;
    private boolean m_bEqualHeight = false;
    private double m_fIntensity = 0.0;
    private final Point2D.Double m_startPoint = new Point2D.Double();
    private final Point2D.Double m_endPoint = new Point2D.Double();
    private final FillGradientObj m_FillGradientObj = null;

    public GradientRenderer1(Point2D[] triangle, double[] fHeights, FillGradientObj fillGradientObj, double fIntensity) throws NoninvertibleTransformException {
        if (fHeights == null || fHeights.length < 3 || triangle == null || triangle.length < 3) {
            throw new NoninvertibleTransformException("Illegal arguments");
        }
        this.m_fIntensity = fIntensity;
        int[] index = new int[3];
        GradientRenderer1.doIndex(index, fHeights);
        this.m_fMinHeight = fHeights[index[0]];
        this.m_fMaxHeight = fHeights[index[2]];
        this.m_bEqualHeight = FP.equal(this.m_fMinHeight, this.m_fMaxHeight);
        if (!this.m_bEqualHeight) {
            Point2D vv0 = triangle[index[0]];
            Point2D vv1 = triangle[index[1]];
            Point2D vv2 = triangle[index[2]];
            double fH1 = fHeights[index[1]];
            this.m_bEqualHeight = GradientRenderer1.calcGradientPoints(vv0, vv1, vv2, this.m_fMinHeight, fH1, this.m_fMaxHeight, this.m_startPoint, this.m_endPoint);
        }
        this.updateFilling(fillGradientObj);
    }

    public Paint getPaintFilling() {
        return this.m_filling;
    }

    public void updateFrom(IBlackBox bb) {
        if (bb == null) {
            return;
        }
        FillGradientObj fillGradientObj = null;
        fillGradientObj = bb.getFillGradientObj();
        if (fillGradientObj == null) {
            return;
        }
        if (fillGradientObj.equals(this.m_FillGradientObj)) {
            return;
        }
        this.updateFilling(fillGradientObj);
    }

    private void updateFilling(FillGradientObj fillGradientObj) {
        if (fillGradientObj == null) {
            return;
        }
        if (this.m_bEqualHeight) {
            this.m_filling = fillGradientObj.getColorAt(this.m_fMinHeight);
        } else {
            Point2D.Double ptStart = new Point2D.Double(this.m_startPoint.x, this.m_startPoint.y);
            Point2D.Double ptEnd = new Point2D.Double(this.m_endPoint.x, this.m_endPoint.y);
            FillGradientObj newFill = fillGradientObj.restrictColorStripe(ptStart, this.m_fMinHeight, ptEnd, this.m_fMaxHeight);
            this.m_filling = newFill.createGradientPaint(this.m_fIntensity);
        }
    }

    public Dimension2D getMargins() {
        return new Dimension();
    }

    public void render(Graphics2D g, Shape shape) {
        if (this.m_filling == null) {
            return;
        }
        g.setPaint(this.m_filling);
        g.fill(shape);
        g.draw(shape);
    }

    public static boolean calcGradientPoints(Point2D vv0, Point2D vv1, Point2D vv2, double fH0, double fH1, double fH2, Point2D.Double startP, Point2D.Double endP) throws NoninvertibleTransformException {
        double nY1;
        double Z2;
        double X1 = vv1.getX() - vv0.getX();
        double X2 = vv2.getX() - vv0.getX();
        double Y1 = vv1.getY() - vv0.getY();
        double Z1 = fH1 - fH0;
        double Y2 = vv2.getY() - vv0.getY();
        double nX1 = Z1 * Y2 - (Z2 = fH2 - fH0) * Y1;
        double norm2 = nX1 * nX1 + (nY1 = Z2 * X1 - Z1 * X2) * nY1;
        if (!FP.nonzero(norm2)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Triangle has one height level.");
            }
            return true;
        }
        startP.x = vv0.getX();
        startP.y = vv0.getY();
        double ss1 = (nX1 * X2 + nY1 * Y2) / norm2;
        endP.x = startP.getX() + ss1 * nX1;
        endP.y = startP.getY() + ss1 * nY1;
        return false;
    }

    public static boolean doIndex(int[] index, double[] d) {
        if (d[0] <= d[1]) {
            if (d[1] <= d[2]) {
                index[0] = 0;
                index[1] = 1;
                index[2] = 2;
                return true;
            }
            if (d[0] <= d[2]) {
                index[0] = 0;
                index[1] = 2;
                index[2] = 1;
                return false;
            }
            index[0] = 2;
            index[1] = 0;
            index[2] = 1;
            return true;
        }
        if (d[2] <= d[1]) {
            index[0] = 2;
            index[1] = 1;
            index[2] = 0;
            return false;
        }
        if (d[0] <= d[2]) {
            index[0] = 1;
            index[1] = 0;
            index[2] = 2;
            return false;
        }
        index[0] = 1;
        index[1] = 2;
        index[2] = 0;
        return true;
    }
}

