/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.ICurveFit;

class FitQuadratic
implements ICurveFit {
    private static final int NUM_COEFFS = 3;

    FitQuadratic() {
    }

    public double compute(double x, double[] a) {
        assert (a.length >= 4);
        double y = a[1] + a[2] * x + a[3] * x * x;
        return y;
    }

    public void eval(double x, double[] a) {
        assert (a.length >= 4);
        a[1] = 1.0;
        a[2] = x;
        a[3] = x * x;
    }

    public int numCoeffs() {
        return 3;
    }

    public double transformY(double y) {
        return y;
    }

    public double invTransformCoeff(int ia, double a) {
        return a;
    }

    public String createEquation(String[] strCoeffs, boolean bHighOrderFirst) {
        assert (strCoeffs.length >= 4);
        String strTerm1 = strCoeffs[1];
        String strTerm2 = strCoeffs[2] + "x";
        String strTerm3 = strCoeffs[3] + "x^2";
        if (bHighOrderFirst) {
            return "y = " + strTerm3 + " + " + strTerm2 + " + " + strTerm1;
        }
        return "y = " + strTerm1 + " + " + strTerm2 + " + " + strTerm3;
    }
}

