/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IDataProcessor;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.ITrendlineEngine;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AverageEngine
implements ITrendlineEngine {
    private double mean;
    private boolean isValid = false;

    AverageEngine() {
    }

    @Override
    public void processDataValues(List<Point2D> data) {
        double sum = 0.0;
        int validDataCount = 0;
        for (Point2D pt : data) {
            if (pt == null) continue;
            sum += pt.getY();
            ++validDataCount;
        }
        if (validDataCount > 0) {
            this.isValid = true;
            this.mean = sum / (double)validDataCount;
        }
    }

    @Override
    public List<Point> generateCurve(int seriesId, IDataProcessor dataProcessor) {
        if (!this.isValid) {
            return Collections.EMPTY_LIST;
        }
        if (!dataProcessor.isYValueWithinAxis(seriesId, this.mean)) {
            return Collections.EMPTY_LIST;
        }
        int x1 = dataProcessor.getXAxisMinCoord();
        int x2 = dataProcessor.getXAxisMaxCoord();
        int y1 = dataProcessor.getYAxisCoord(seriesId, this.mean);
        ArrayList<Point> vcPts = new ArrayList<Point>();
        vcPts.add(new Point(x1, y1));
        vcPts.add(new Point(x2, y1));
        return vcPts;
    }

    @Override
    public String getEquationText(Format format) {
        return "";
    }

    @Override
    public String getCorrelationText(Format format) {
        return "";
    }

    @Override
    public void setSmoothingFactor(int smoothFactor) {
    }
}

