/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.Access;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.AnnotationBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.FontInfoObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextStyleObjFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JGraphType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.Axis2DObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisLabelGroupFormatter;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisUtils;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.utility.RectangleUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AxisObj
implements IAxis {
    private static final Logger logger = Logger.getLogger((String)"com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisObj");
    Perspective m_Perspective;
    Access m_Access;
    AxisTemplate m_template;
    private boolean m_bAscending;
    private int m_numSeries;
    int m_numGroups;
    private int m_nAxisObjectID;
    private boolean m_bDrawGrids;
    boolean m_bLabelStagger;
    double m_fAxisLengthRel;
    double m_fAxisPositionRel;
    boolean m_bDelayCalcLabels;
    private int m_nAutoSkip;
    private int m_nLabelBegin;
    private int m_nSkipFactor = 0;
    private boolean m_bSkippedLabels;
    private int m_axisLabelTextSizeVC;
    JGraphType m_gt;
    Rectangle m_labelBoundingBoxVC;
    List<Rectangle> m_LabelRectListVC = null;
    int m_maxLabelSize = -1;
    private double[] m_nParetoSeriesMaximums;
    private double[] m_nParetoSeriesMinimums;
    List<Integer> m_O1NestedPositions = new ArrayList<Integer>();
    Format m_DataTextFormat;
    Format m_LabelFormat;
    static final double ROOT_TWO = Math.sqrt(2.0);

    public AxisObj(Perspective perspective, Access access, AxisTemplate template, boolean ascending, int nAxisOffset, int nAxisSize) {
        this.m_Perspective = perspective;
        this.m_gt = this.m_Perspective.getJGraphType();
        this.m_Access = access;
        this.m_template = template;
        this.m_bAscending = ascending;
        this.m_numSeries = access.getNumNonIgnoredSeries();
        this.m_numGroups = access.getNumGroups();
        this.m_nParetoSeriesMaximums = new double[this.m_numSeries];
        this.m_nParetoSeriesMinimums = new double[this.m_numSeries];
        this.m_nAxisObjectID = this.m_template.getAxis().getObjectID();
        this.m_fAxisLengthRel = (double)nAxisSize / 100.0;
        this.m_fAxisPositionRel = (double)nAxisOffset / 100.0;
        this.m_bDelayCalcLabels = false;
        this.m_bDrawGrids = true;
        this.m_axisLabelTextSizeVC = this.m_Perspective.getAxisTextAutofitMin();
        if (this.m_axisLabelTextSizeVC <= 10) {
            this.m_axisLabelTextSizeVC = 10;
        }
        this.m_DataTextFormat = this.m_Perspective.getDataTextFormat(this.m_template.getAxis());
        this.m_LabelFormat = this.m_Perspective.getTextFormat(this.m_template.getLabel());
    }

    @Override
    public void calc() {
        if (!this.m_bDelayCalcLabels && !this.m_Perspective.getSuppressLabelDrawing()) {
            try {
                this.calcLabels();
            }
            catch (Throwable e) {
                logger.warn((Object)("Exception during label draw, id = " + this.m_template.getLabel()), e);
            }
        }
        if (this.m_bDrawGrids) {
            this.calcGrids();
        }
    }

    @Override
    public void calcUserLines() {
        for (int i = 0; i < 4; ++i) {
            IdentObj id = this.m_Perspective.getUserLine(i);
            if (!this.m_Perspective.getDisplay(id) || this.m_template.getAxisObjID() != this.m_Perspective.getUserLineAxis(id)) continue;
            this.calcUserLine(id);
        }
    }

    void calcUserLine(IdentObj lineId) {
    }

    @Override
    public Rectangle getLabelBoundingBoxVC() {
        return this.m_labelBoundingBoxVC;
    }

    @Override
    public void calcGrids() {
        boolean bPdeCalc = this.m_Perspective.getPDECalc();
        if (this.m_bDrawGrids && !bPdeCalc) {
            if (this.getMinorGridDisplay(this.m_template)) {
                this.calcMinorGrids();
            }
            if (!this.getMinorTickDisplay(this.m_template) || this.m_template.getAxisObjID() != 8) {
                // empty if block
            }
            if (this.getMajorGridDisplay(this.m_template)) {
                this.calcMajorGrids();
            }
            if (!this.getMajorTickDisplay(this.m_template) || this.m_template.getAxisObjID() != 8) {
                // empty if block
            }
        }
    }

    void calcMajorGrids() {
        BlackBoxObj blackbox = new BlackBoxObj(this.m_Perspective, this.m_template.getMajor());
        IdentObj id = this.m_template.getMajor();
        int nMajorGridLines = this.getNumMajorGrids();
        for (int i = 0; i < nMajorGridLines; ++i) {
            boolean bIgnoreGridSkip;
            boolean bExpressGrid = true;
            if ((this.m_nAutoSkip == 1 || this.m_nAutoSkip == 2) && this.m_bSkippedLabels) {
                bExpressGrid = i >= this.m_nLabelBegin && (i - this.m_nLabelBegin) % (this.m_nSkipFactor + 1) == 0;
            }
            if (bIgnoreGridSkip = this.m_Perspective.getIgnoreGridSkip()) {
                bExpressGrid = true;
            }
            if (!bExpressGrid) continue;
            IdentObj newID = id;
            this.calcMajorGridLine(newID, this.getMajorGridPos(i), blackbox);
        }
    }

    void calcMinorGrids() {
        BlackBoxObj blackbox = new BlackBoxObj(this.m_Perspective, this.m_template.getMinor());
        int nMisc = -3;
        double fPos = 0.0;
        int nMinorGridLines = this.getNumMinorGrids();
        int nMajorGridLines = this.getNumMajorGrids();
        IdentObj id = this.m_template.getMinor();
        for (int nMajor = -1; nMajor <= nMajorGridLines; ++nMajor) {
            for (int nMinor = 0; nMinor < nMinorGridLines; ++nMinor) {
                IdentObj newID = id.changeMisc(nMisc++);
                fPos = this.getMinorGridPos(nMajor, nMinor);
                if (!(fPos > 0.0) || !(fPos < 1.0)) continue;
                this.calcMinorGridLine(newID, fPos, blackbox);
            }
        }
    }

    void calcMajorTicks() {
        int nMajorGridLines;
        boolean excludeMinValue = this.m_Perspective.getExcludeMinLabel(this.m_template.getMajorTick());
        boolean excludeMaxValue = this.m_Perspective.getExcludeMaxLabel(this.m_template.getMajorTick());
        int min = 0;
        int max = 0;
        if (excludeMinValue) {
            ++min;
        }
        max = nMajorGridLines = this.getNumMajorGrids();
        if (excludeMaxValue) {
            --max;
        }
        for (int i = min; i < max; ++i) {
            boolean bIgnoreGridSkip;
            boolean bExpressGrid = true;
            if ((this.m_nAutoSkip == 1 || this.m_nAutoSkip == 2) && this.m_bSkippedLabels) {
                bExpressGrid = i >= this.m_nLabelBegin && (i - this.m_nLabelBegin) % (this.m_nSkipFactor + 1) == 0;
            }
            if (bIgnoreGridSkip = this.m_Perspective.getIgnoreTickSkip()) {
                bExpressGrid = true;
            }
            if (!bExpressGrid) continue;
            this.calcMajorTickLine(this.getMajorGridPos(i));
        }
    }

    void calcMinorTicks() {
        double fPos = 0.0;
        int nMinorGridLines = this.getNumMinorGrids();
        int nMajorGridLines = this.getNumMajorGrids();
        for (int nMajor = -1; nMajor <= nMajorGridLines; ++nMajor) {
            for (int nMinor = 0; nMinor < nMinorGridLines; ++nMinor) {
                fPos = this.getMinorGridPos(nMajor, nMinor);
                if (!(fPos > 0.0) || !(fPos < 1.0)) continue;
                this.calcMinorTickLine(fPos);
            }
        }
    }

    @Override
    public void calcLabels() {
        int nNumLabels;
        if (this.m_Perspective.getDisplay(this.m_template.getLabel()) && (nNumLabels = this.getNumLabels()) > 0) {
            this.drawRegularLabels();
        }
    }

    void drawRegularLabels() {
        int nSide = this.getAxisSide();
        IdentObj idLabel = this.m_template.getLabel();
        int nAutoSkip = this.m_Perspective.getAutoSkip(idLabel);
        int nSkipCount = this.m_Perspective.getSkipCount(idLabel);
        int nNumLabels = this.getNumLabels();
        List<String> strVectLabels = this.getLabels();
        ArrayList<Rectangle> rVectLabels = new ArrayList<Rectangle>(nNumLabels);
        List<Double> fVectRelLabelPos = this.getRelLabelPos(nNumLabels);
        ITextStyle textStyle = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, idLabel);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, idLabel);
        AxisLabelGroupFormatter axisLabelGroupFormatter = new AxisLabelGroupFormatter(this, strVectLabels, fVectRelLabelPos, textStyle);
        axisLabelGroupFormatter.autoFormat();
        nSkipCount = axisLabelGroupFormatter.getActualSkipCount();
        if (nSkipCount > 0) {
            nAutoSkip = 2;
        } else if (nSkipCount == 0) {
            nAutoSkip = 0;
        }
        switch (nAutoSkip) {
            case 2: {
                this.m_bSkippedLabels = true;
                this.calcLabelsManualSkip(nSide, nNumLabels, fVectRelLabelPos, textStyle, nAutoSkip, blackBox, nSkipCount);
                break;
            }
            case 1: {
                this.m_bSkippedLabels = this.calcLabelsAutoSkip(nSide, nNumLabels, fVectRelLabelPos, textStyle, nAutoSkip, blackBox);
                break;
            }
            default: {
                this.m_bSkippedLabels = false;
                this.calcLabelsNoSkip(nSide, nNumLabels, fVectRelLabelPos, textStyle, nAutoSkip, blackBox, rVectLabels, strVectLabels);
            }
        }
    }

    Dimension calcMaxLabelDimensionVC(int nSide, int nNumLabels, int skipCount, boolean stagger, List<Double> fVectRelLabelPos) {
        throw new RuntimeException("Derived axis class must implement function.");
    }

    private void calcLabelsNoSkip(int nSide, int nNumLabels, List<Double> fVectRelLabelPos, ITextStyle textStyle, int nAutoSkip, BlackBoxObj blackBox, List<Rectangle> rVectLabels, List<String> strVectLabels) {
        int nLabelBegin = 0;
        int nSkipFactor = 0;
        List<IdentObj> nVectIdents = this.getLabelIdents();
        if ((nSide == 0 || nSide == 2) && this.isAxisLabelVisible(0)) {
            this.calcLabelsOneSide(0, nNumLabels, rVectLabels, fVectRelLabelPos, blackBox, nAutoSkip, nLabelBegin, nSkipFactor, textStyle, strVectLabels, nVectIdents);
        }
        if ((nSide == 1 || nSide == 2) && this.isAxisLabelVisible(1)) {
            this.calcLabelsOneSide(1, nNumLabels, rVectLabels, fVectRelLabelPos, blackBox, nAutoSkip, nLabelBegin, nSkipFactor, textStyle, strVectLabels, nVectIdents);
        }
    }

    private boolean calcLabelsAutoSkip(int nSide, int nNumLabels, List<Double> fVectRelLabelPos, ITextStyle textStyle, int nAutoSkip, BlackBoxObj blackBox) {
        boolean bSkippedLabels = false;
        if ((nSide == 0 || nSide == 2) && this.isAxisLabelVisible(0)) {
            bSkippedLabels = this instanceof Axis2DObj ? (this.isO1Axis() && this.isVertical() ? this.calcLabelsAutoSkipFrameHeight(0, nNumLabels, fVectRelLabelPos, textStyle, nAutoSkip, blackBox) : this.calcLabelsAutoSkipFrameWidth(0, nNumLabels, fVectRelLabelPos, textStyle, nAutoSkip, blackBox)) : this.calcLabelsAutoSkip3D(0, nNumLabels, fVectRelLabelPos, textStyle, nAutoSkip, blackBox);
        }
        if ((nSide == 1 || nSide == 2) && this.isAxisLabelVisible(1)) {
            bSkippedLabels = this instanceof Axis2DObj ? (this.isO1Axis() && this.isVertical() ? this.calcLabelsAutoSkipFrameHeight(1, nNumLabels, fVectRelLabelPos, textStyle, nAutoSkip, blackBox) : this.calcLabelsAutoSkipFrameWidth(1, nNumLabels, fVectRelLabelPos, textStyle, nAutoSkip, blackBox)) : this.calcLabelsAutoSkip3D(1, nNumLabels, fVectRelLabelPos, textStyle, nAutoSkip, blackBox);
        }
        return bSkippedLabels;
    }

    private boolean calcLabelsAutoSkip3D(int nSide, int nNumLabels, List<Double> nVectLabelPos, ITextStyle textStyle, int nAutoSkip, BlackBoxObj blackBox) {
        boolean bSkippedLabels = false;
        ArrayList<Rectangle> rVectLabels = new ArrayList<Rectangle>(nNumLabels);
        List<String> sVectLabels = this.getLabels();
        List<IdentObj> nVectIdents = this.getLabelIdents();
        ArrayList<String> sVectSkipLabels = new ArrayList<String>(nNumLabels);
        ArrayList<IdentObj> sVectSkipIdents = new ArrayList<IdentObj>(nNumLabels);
        ArrayList<Double> nVectSkipLabelPos = new ArrayList<Double>(nNumLabels);
        int nLabelBegin = 0;
        int nSkipFactor = 0;
        int nSkipLabels = 0;
        int nTextLargerThanBox = 0;
        int nAutoSkipMax = 25;
        boolean bOldTestLabelCalc = this.m_Perspective.getTestLabelCalc();
        this.m_Perspective.setTestLabelCalc(true);
        int nStopLoop = 0;
        while (nStopLoop < nAutoSkipMax) {
            boolean bLabelRotated;
            int j;
            ++nStopLoop;
            sVectSkipLabels.clear();
            sVectSkipIdents.clear();
            nVectSkipLabelPos.clear();
            nSkipLabels = 0;
            for (j = 0; j < nNumLabels; ++j) {
                sVectSkipLabels.add(sVectLabels.get(j));
                sVectSkipIdents.add(nVectIdents.get(j));
                nVectSkipLabelPos.add(nVectLabelPos.get(j));
                ++nSkipLabels;
            }
            nTextLargerThanBox = this.calcLabelsOneSide(nSide, nSkipLabels, rVectLabels, nVectSkipLabelPos, blackBox, nAutoSkip, nLabelBegin, nSkipFactor, textStyle, sVectSkipLabels, sVectSkipIdents);
            if (nTextLargerThanBox != 0) {
                nLabelBegin = this.m_Perspective.getSkipBegin(this.m_template.getLabel());
                if (nLabelBegin < 0) {
                    nLabelBegin = 0;
                }
                if (nLabelBegin > nNumLabels - 1) {
                    nLabelBegin = nNumLabels - 1;
                }
                if (nSkipFactor == 0) {
                    nLabelBegin = 0;
                }
                if (nLabelBegin > nSkipFactor) {
                    nLabelBegin = 0;
                }
                bSkippedLabels = true;
                sVectSkipLabels.clear();
                sVectSkipIdents.clear();
                nVectSkipLabelPos.clear();
                nSkipLabels = 0;
                for (j = 0; j < nNumLabels; ++j) {
                    if (j < nLabelBegin || (j - nLabelBegin) % (nSkipFactor + 1) != 0) continue;
                    sVectSkipLabels.add(sVectLabels.get(j));
                    sVectSkipIdents.add(nVectIdents.get(j));
                    nVectSkipLabelPos.add(nVectLabelPos.get(j));
                    ++nSkipLabels;
                }
                nTextLargerThanBox = this.calcLabelsOneSide(nSide, nSkipLabels, rVectLabels, nVectSkipLabelPos, blackBox, nAutoSkip, nLabelBegin, nSkipFactor, textStyle, sVectSkipLabels, sVectSkipIdents);
            }
            boolean bl = bLabelRotated = textStyle.getRotationSetting() != 0;
            if (this.isVertical() ? (bLabelRotated ? nTextLargerThanBox != 2 && nTextLargerThanBox != 3 : nTextLargerThanBox != 1 && nTextLargerThanBox != 3) : (bLabelRotated ? nTextLargerThanBox != 1 && nTextLargerThanBox != 3 : nTextLargerThanBox != 2 && nTextLargerThanBox != 3)) break;
            ++nSkipFactor;
        }
        this.m_Perspective.setTestLabelCalc(bOldTestLabelCalc);
        this.calcLabelsOneSide(nSide, nSkipLabels, rVectLabels, nVectSkipLabelPos, blackBox, nAutoSkip, nLabelBegin, nSkipFactor, textStyle, sVectSkipLabels, sVectSkipIdents);
        return bSkippedLabels;
    }

    private boolean calcLabelsAutoSkipFrameWidth(int nSide, int nNumLabels, List<Double> nVectLabelPos, ITextStyle textStyle, int nAutoSkip, BlackBoxObj blackBox) {
        boolean bSkippedLabels = false;
        Rectangle rFrame = ((Axis2DObj)this).getFrameRect();
        boolean bLabelRotated = textStyle.getRotationSetting() != 0;
        Dimension dimMaxVC = new Dimension(rFrame.width / nNumLabels, rFrame.height);
        Dimension dimMaxDC = this.m_Perspective.getVC().virtToDest(dimMaxVC);
        List<String> strVectLabels = this.getLabels();
        Dimension dimLabelDC = this.findLargestLabelFastest(nNumLabels, dimMaxDC, strVectLabels, textStyle);
        int nLabelSizeDC = bLabelRotated ? dimLabelDC.height : dimLabelDC.width;
        int nLabelSpaceTotalDC = nLabelSizeDC * nNumLabels;
        int nLabelBegin = this.m_Perspective.getSkipBegin(this.m_template.getLabel());
        int nTotalSpaceAvail = this.m_Perspective.getVC().virtToDestWidth(rFrame.width);
        int nSkipFactor = this.calcSkipFactor(nLabelSizeDC, nNumLabels, nLabelBegin, nLabelSpaceTotalDC, nTotalSpaceAvail);
        this.skipAndDrawLabels(nSide, nNumLabels, nVectLabelPos, textStyle, nAutoSkip, blackBox, strVectLabels, nLabelBegin, nSkipFactor);
        if (nSkipFactor > 0) {
            bSkippedLabels = true;
        }
        return bSkippedLabels;
    }

    private boolean calcLabelsAutoSkipFrameHeight(int nSide, int nNumLabels, List<Double> nVectLabelPos, ITextStyle textStyle, int nAutoSkip, BlackBoxObj blackBox) {
        boolean bSkippedLabels = false;
        Rectangle rFrame = ((Axis2DObj)this).getFrameRect();
        boolean bLabelRotated = textStyle.getRotationSetting() != 0;
        Dimension dimMaxVC = new Dimension(rFrame.height / nNumLabels, rFrame.width);
        Dimension dimMaxDC = this.m_Perspective.getVC().virtToDest(dimMaxVC);
        List<String> strVectLabels = this.getLabels();
        Dimension dimLabelDC = this.findLargestLabelFastest(nNumLabels, dimMaxDC, strVectLabels, textStyle);
        int nLabelSizeDC = bLabelRotated ? dimLabelDC.width : dimLabelDC.height;
        int nLabelSpaceTotalDC = nLabelSizeDC * nNumLabels;
        int nLabelBegin = this.m_Perspective.getSkipBegin(this.m_template.getLabel());
        int nTotalSpaceAvail = this.m_Perspective.getVC().virtToDestWidth(rFrame.height);
        int nSkipFactor = this.calcSkipFactor(nLabelSizeDC, nNumLabels, nLabelBegin, nLabelSpaceTotalDC, nTotalSpaceAvail);
        this.skipAndDrawLabels(nSide, nNumLabels, nVectLabelPos, textStyle, nAutoSkip, blackBox, strVectLabels, nLabelBegin, nSkipFactor);
        if (nSkipFactor > 0) {
            bSkippedLabels = true;
        }
        return bSkippedLabels;
    }

    int calcSkipCount(Dimension maxLabelDimension, Dimension availableSpaceOneLabel, int rotation) {
        int availableSpaceSingleLabel;
        boolean isVertical = this.isVertical();
        int n = availableSpaceSingleLabel = isVertical ? availableSpaceOneLabel.height : availableSpaceOneLabel.width;
        if (availableSpaceSingleLabel <= 0) {
            return 0;
        }
        int singleLabelSpace = rotation == 3 ? (int)Math.ceil(ROOT_TWO * (double)maxLabelDimension.height) : (rotation == 1 || rotation == 2 ? (isVertical ? maxLabelDimension.width : maxLabelDimension.height) : (isVertical ? maxLabelDimension.height : maxLabelDimension.width));
        int skipCount = singleLabelSpace / availableSpaceSingleLabel;
        if (singleLabelSpace % availableSpaceSingleLabel == 0 && singleLabelSpace >= availableSpaceSingleLabel) {
            --skipCount;
        }
        return skipCount;
    }

    private int calcSkipFactor(int nLabelSize, int nNumLabels, int nLabelBegin, int nLabelSpaceTotal, int nTotalSpaceAvail) {
        int nSkipFactor = 0;
        if (nLabelSpaceTotal > nTotalSpaceAvail) {
            if (nLabelSize >= nTotalSpaceAvail) {
                nSkipFactor = nNumLabels - nLabelBegin;
            } else {
                int nNumLabelsShown;
                nSkipFactor = 0;
                do {
                    nLabelSpaceTotal = 0;
                    nNumLabelsShown = (nNumLabels + ++nSkipFactor) / (nSkipFactor + 1);
                    for (int i = 0; i < nNumLabels; ++i) {
                        int nSpace = i >= nLabelBegin && (i - nLabelBegin) % (nSkipFactor + 1) == 0 ? nLabelSize : 0;
                        nLabelSpaceTotal += nSpace;
                    }
                } while (nLabelSpaceTotal > nTotalSpaceAvail && nNumLabelsShown >= 2);
            }
        }
        return nSkipFactor;
    }

    private void skipAndDrawLabels(int nSide, int nNumLabels, List<Double> nVectLabelPos, ITextStyle textStyle, int nAutoSkip, BlackBoxObj blackBox, List<String> strVectLabels, int nLabelBegin, int nSkipFactor) {
        int nSkipLabels = 0;
        List<IdentObj> nVectIdents = this.getLabelIdents();
        ArrayList<Rectangle> rVectLabels = new ArrayList<Rectangle>(nNumLabels);
        ArrayList<Double> nVectSkipLabelPos = new ArrayList<Double>(nNumLabels);
        ArrayList<String> sVectSkipLabels = new ArrayList<String>(nNumLabels);
        ArrayList<IdentObj> sVectSkipIdents = new ArrayList<IdentObj>(nNumLabels);
        for (int j = 0; j < nNumLabels; ++j) {
            if (j < nLabelBegin || (j - nLabelBegin) % (nSkipFactor + 1) != 0) continue;
            sVectSkipLabels.add(strVectLabels.get(j));
            sVectSkipIdents.add(nVectIdents.get(j));
            nVectSkipLabelPos.add(nVectLabelPos.get(j));
            ++nSkipLabels;
        }
        this.calcLabelsOneSide(nSide, nSkipLabels, rVectLabels, nVectSkipLabelPos, blackBox, nAutoSkip, nLabelBegin, nSkipFactor, textStyle, sVectSkipLabels, sVectSkipIdents);
    }

    private void calcLabelsManualSkip(int nSide, int nNumLabels, List<Double> nVectLabelPos, ITextStyle textStyle, int nAutoSkip, BlackBoxObj blackBox, int nSkipFactor) {
        ArrayList<Rectangle> rVectLabels = new ArrayList<Rectangle>(nNumLabels);
        List<String> sVectLabels = this.getLabels();
        List<IdentObj> nVectIndents = this.getLabelIdents();
        ArrayList<String> sVectSkipLabels = new ArrayList<String>(nNumLabels);
        ArrayList<IdentObj> nVectSkipIdents = new ArrayList<IdentObj>(nNumLabels);
        ArrayList<Double> nVectSkipLabelPos = new ArrayList<Double>(nNumLabels);
        int nSkipLabels = 0;
        int nLabelBegin = this.m_Perspective.getSkipBegin(this.m_template.getLabel());
        if (nLabelBegin < 0) {
            nLabelBegin = 0;
        }
        if (nLabelBegin > nNumLabels - 1) {
            nLabelBegin = nNumLabels - 1;
        }
        if (nSkipFactor < 0) {
            nSkipFactor = 0;
        }
        if (nSkipFactor == 0) {
            nLabelBegin = 0;
        }
        if (nLabelBegin > nSkipFactor) {
            nLabelBegin = 0;
        }
        int nMod = nSkipFactor + 1;
        for (int j = 0; j < nNumLabels; ++j) {
            if (j < nLabelBegin || (j - nLabelBegin) % nMod != 0) continue;
            sVectSkipLabels.add(sVectLabels.get(j));
            nVectSkipLabelPos.add(nVectLabelPos.get(j));
            ++nSkipLabels;
            if (nVectIndents == null) {
                nVectSkipIdents.add(null);
                continue;
            }
            nVectSkipIdents.add(nVectIndents.get(j));
        }
        if ((nSide == 0 || nSide == 2) && this.isAxisLabelVisible(0)) {
            this.calcLabelsOneSide(0, nSkipLabels, rVectLabels, nVectSkipLabelPos, blackBox, nAutoSkip, nLabelBegin, nSkipFactor, textStyle, sVectSkipLabels, nVectSkipIdents);
        }
        if ((nSide == 1 || nSide == 2) && this.isAxisLabelVisible(1)) {
            this.calcLabelsOneSide(1, nSkipLabels, rVectLabels, nVectSkipLabelPos, blackBox, nAutoSkip, nLabelBegin, nSkipFactor, textStyle, sVectSkipLabels, nVectSkipIdents);
        }
    }

    private int calcLabelsOneSide(int nSide, int nNumLabels, List<Rectangle> rVectLabels, List<Double> fVectRelLabelPos, BlackBoxObj blackBox, int nAutoSkip, int nLabelBegin, int nSkipFactor, ITextStyle textStyle, List<String> sVectLabels, List<IdentObj> vectIDObj) {
        boolean bLabelRotated = textStyle.getRotationSetting() != 0;
        Rectangle rTitleVC = null;
        ArrayList<Integer> nVectAlign = new ArrayList<Integer>(nNumLabels);
        boolean bTitleRectAssigned = false;
        if (this.m_Perspective.getDisplay(this.m_template.getTitle())) {
            rTitleVC = new Rectangle(0, 0, 0, 0);
        }
        this.getLabelAndTitlePos(nSide, nNumLabels, rVectLabels, fVectRelLabelPos, nVectAlign, rTitleVC, bLabelRotated, nAutoSkip, nLabelBegin, nSkipFactor, textStyle);
        Dimension dimLabelSampleVC = TextUtil.getLargestLabelVC(rVectLabels);
        Dimension dimMaxStartingLabelDC = this.m_Perspective.getVC().virtToDest(dimLabelSampleVC);
        if (nAutoSkip == 1 || nAutoSkip == 2) {
            this.m_nAutoSkip = nAutoSkip;
            this.m_nLabelBegin = nLabelBegin;
            if (nSkipFactor > this.m_nSkipFactor) {
                this.m_nSkipFactor = nSkipFactor;
            }
        }
        this.alignLabelsOneSide(nSide, nNumLabels, dimMaxStartingLabelDC, rVectLabels, sVectLabels, nVectAlign, textStyle);
        int horizAlignment = this.calcHorizontalTextAlignment(textStyle.getRotationSetting(), nSide, this.isVertical());
        if (horizAlignment >= 0) {
            textStyle.setHorizAlign(horizAlignment);
        }
        this.m_LabelRectListVC = new ArrayList<Rectangle>(rVectLabels);
        if (!this.m_Perspective.getPDECalc()) {
            if (!this.isVertical()) {
                this.drawAxisLabels(nNumLabels, rVectLabels, sVectLabels, vectIDObj, textStyle, blackBox, nSide);
            }
            String strTitle = this.m_Perspective.getTextString(this.m_template.getTitle());
            int drawnAxis = this.getAxisSide();
            boolean shouldDrawAxis = drawnAxis == nSide || drawnAxis == 2 && nSide == 0;
            shouldDrawAxis &= rTitleVC != null && !rTitleVC.isEmpty();
            if (shouldDrawAxis &= strTitle.length() > 0) {
                this.drawAxisTitle(nSide, bTitleRectAssigned, rTitleVC, rVectLabels);
            }
            if (this.isVertical()) {
                this.drawAxisLabels(nNumLabels, rVectLabels, sVectLabels, vectIDObj, textStyle, blackBox, nSide);
            }
        }
        return 0;
    }

    int calcHorizontalTextAlignment(int rotation, int side, boolean isVertical) {
        logger.warn((Object)"Classes that derive from AxisObj should implement calcHorizontalTextAlignment.");
        return -1;
    }

    ITextStyle getTitleTextStyle(int nSide, IdentObj idTitle) {
        FontInfoObj fontInfo = TextStyleObjFactory.newFontInfoObj(this.m_Perspective, idTitle);
        int nTitleRotationSetting = this.getTitleRotation(this.m_template, nSide);
        fontInfo.setRotationSetting(nTitleRotationSetting);
        ITextStyle titleTextStyle = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, fontInfo);
        return titleTextStyle;
    }

    private void drawAxisTitle(int nSide, boolean bTitleRectAssigned, Rectangle rTitleVC, List<Rectangle> rLabels) {
        IdentObj idTitle = this.m_template.getTitle();
        String strTitle = this.m_Perspective.getTextString(idTitle);
        if (!bTitleRectAssigned) {
            this.adjustTitlePosPass1(nSide, rLabels, rTitleVC);
        }
        ITextStyle titleTextStyle = this.getTitleTextStyle(nSide, idTitle);
        Dimension dimTitleVC = new Dimension(rTitleVC.width, rTitleVC.height);
        if ((this.m_gt.is3DType() || this.m_gt.isPolar() || this.m_gt.isRadarType()) && strTitle.length() > 0) {
            dimTitleVC = TextUtil.getTextDimensionVC(this.m_Perspective, idTitle, strTitle);
        }
        if (!bTitleRectAssigned) {
            this.adjustTitlePosPass2(idTitle, nSide, rTitleVC, dimTitleVC);
        }
        if (!this.m_Perspective.getTestLabelCalc() && this.doDisplayOnCalc()) {
            IdentObj idBox = this.m_template.getTitleBox();
            AnnotationBox.calcBorderedBox(this.m_Perspective, idBox, rTitleVC, null, null);
            BlackBoxObj titleBlackBox = new BlackBoxObj(this.m_Perspective, idTitle);
            DrawFactory.createLabel(this.m_Perspective.getDetectiv(), idTitle, strTitle, rTitleVC, titleTextStyle, titleBlackBox, null);
        }
    }

    void alignLabelsOneSide(int nSide, int nNumLabels, Dimension dimWrappingLabelDC, List<Rectangle> rVectLabels, List<String> sVectLabels, List<Integer> nVectAlign, ITextStyle textStyle) {
        int rotation = textStyle.getRotationSetting();
        for (int i = 0; i < nNumLabels; ++i) {
            Rectangle rLabel = rVectLabels.get(i);
            if (this.skipFirstOrLastLabel(i, nNumLabels)) {
                rLabel.setFrame(0.0, 0.0, 0.0, 0.0);
                continue;
            }
            Dimension textSizeDC = textStyle.getTextSizeDC(sVectLabels.get(i), textStyle.getFontSizeDC(this.m_Perspective.getVC()), dimWrappingLabelDC, null, textStyle.getWordWrap());
            Point tiltAdjustmentVC = this.calc45DegreeTiltAdjustmentVC(textSizeDC.height, rotation);
            this.adjustForRotation(textSizeDC, rotation);
            Dimension textSizeVC = this.m_Perspective.getVC().destToVirt(textSizeDC);
            int align = nVectAlign.get(i);
            switch (align) {
                case 1: {
                    rLabel.y += (rLabel.height - textSizeVC.height) / 2;
                    break;
                }
                case 12: {
                    rLabel.y = rLabel.y + rLabel.height / 2 - tiltAdjustmentVC.y;
                    break;
                }
                case 2: {
                    rLabel.y = rLabel.y + rLabel.height - textSizeVC.height;
                    break;
                }
                case 3: {
                    rLabel.x += (rLabel.width - textSizeVC.width) / 2;
                    rLabel.y = rLabel.y + rLabel.height - textSizeVC.height;
                    break;
                }
                case 4: {
                    rLabel.x = rLabel.x + rLabel.width - textSizeVC.width;
                    rLabel.y = rLabel.y + rLabel.height - textSizeVC.height;
                    break;
                }
                case 9: {
                    rLabel.x = rLabel.x + rLabel.width / 2 - textSizeVC.width + tiltAdjustmentVC.x;
                    rLabel.y = rLabel.y + rLabel.height - textSizeVC.height;
                    break;
                }
                case 5: {
                    rLabel.x = rLabel.x + rLabel.width - textSizeVC.width;
                    rLabel.y += (rLabel.height - textSizeVC.height) / 2;
                    break;
                }
                case 11: {
                    rLabel.x = rLabel.x + rLabel.width - textSizeVC.width;
                    rLabel.y = rLabel.y - textSizeVC.height + rLabel.height / 2 + tiltAdjustmentVC.y;
                    break;
                }
                case 6: {
                    rLabel.x = rLabel.x + rLabel.width - textSizeVC.width;
                    break;
                }
                case 10: {
                    rLabel.x += rLabel.width / 2 - tiltAdjustmentVC.x;
                    break;
                }
                case 7: {
                    rLabel.x += (rLabel.width - textSizeVC.width) / 2;
                    break;
                }
            }
            rLabel.width = textSizeVC.width;
            rLabel.height = textSizeVC.height;
            this.m_axisLabelTextSizeVC = textStyle.getFontSizeVC(this.m_Perspective.getVC());
        }
        this.adjustLabelPos(nSide, rVectLabels);
        this.m_labelBoundingBoxVC = RectangleUtil.calcBoundingRectangle(rVectLabels);
    }

    private void adjustForRotation(Dimension dimLargestLabelDC, int rotation) {
        switch (rotation) {
            case 1: 
            case 2: {
                int temp = dimLargestLabelDC.height;
                dimLargestLabelDC.height = dimLargestLabelDC.width;
                dimLargestLabelDC.width = temp;
                break;
            }
            case 3: {
                int max;
                double fontHeight = this.m_Perspective.getFontSize(this.m_template.getLabel());
                int tilt = (int)(fontHeight * 0.7071067811865475) / 2;
                dimLargestLabelDC.height = max = (int)((double)Math.max(dimLargestLabelDC.width, dimLargestLabelDC.height) * 0.7071067811865475) + tilt;
                dimLargestLabelDC.width = max;
            }
        }
    }

    private Point calc45DegreeTiltAdjustmentVC(int textHeightDC, int rotation) {
        Point tiltPoint = new Point(0, 0);
        if (rotation == 3) {
            int tiltAdjustment = (int)((double)textHeightDC / ROOT_TWO / 2.0);
            tiltPoint.x = this.m_Perspective.getVC().destToVirtWidth(tiltAdjustment);
            tiltPoint.y = this.m_Perspective.getVC().destToVirtHeight(tiltAdjustment);
        }
        return tiltPoint;
    }

    private int getSkipFactor(List<Rectangle> rVectLabels) {
        int numLabelsToDraw;
        int nIntersectionCount;
        int skipFactor = 0;
        int slopFactor = -2;
        if (this.m_Perspective.getTextRotation(this.m_template.getLabel()) == 3 || this.m_Perspective.getLabelStagger(this.m_template.getLabel())) {
            return 0;
        }
        int nLabelCount = rVectLabels.size();
        Rectangle rLastLabelVC = new Rectangle(rVectLabels.get(nLabelCount - 1));
        Rectangle rLastLabelDC = this.m_Perspective.getVC().virtToDest(rLastLabelVC);
        int nIntersectionCountBackward = 0;
        if (rLastLabelDC.height < 10) {
            slopFactor = -1;
        } else if (rLastLabelDC.height < 18) {
            slopFactor = -2;
        } else if (rLastLabelDC.height < 24) {
            slopFactor = -3;
        } else if (rLastLabelDC.height < 30) {
            slopFactor = -4;
        }
        rLastLabelDC.grow(slopFactor, slopFactor);
        for (int i = nLabelCount - 2; i > 0; --i) {
            Rectangle rVC = rVectLabels.get(i);
            Rectangle rDC = this.m_Perspective.getVC().virtToDest(rVC);
            rDC.grow(slopFactor, slopFactor);
            if (!rLastLabelDC.intersects(rDC)) break;
            ++nIntersectionCountBackward;
        }
        Rectangle rFirstLabelVC = new Rectangle(rVectLabels.get(0));
        Rectangle rFirstLabelDC = this.m_Perspective.getVC().virtToDest(rFirstLabelVC);
        int nIntersectionCountForward = 0;
        rLastLabelDC.grow(slopFactor, slopFactor);
        for (int i = 1; i < nLabelCount - 1; ++i) {
            Rectangle rVC = rVectLabels.get(i);
            Rectangle rDC = this.m_Perspective.getVC().virtToDest(rVC);
            rDC.grow(slopFactor, slopFactor);
            if (!rFirstLabelDC.intersects(rDC)) break;
            ++nIntersectionCountForward;
        }
        if ((nIntersectionCount = Math.max(nIntersectionCountForward, nIntersectionCountBackward)) > 0) {
            skipFactor = nIntersectionCount + 1;
        }
        int maxAxisLabels = 30;
        int n = numLabelsToDraw = skipFactor == 0 ? nLabelCount : nLabelCount / skipFactor;
        if (numLabelsToDraw > maxAxisLabels && skipFactor < numLabelsToDraw / maxAxisLabels) {
            skipFactor = numLabelsToDraw / maxAxisLabels;
        }
        return skipFactor;
    }

    private void drawAxisLabels(int nNumLabels, List<Rectangle> rVectLabels, List<String> sVectLabels, List<IdentObj> vectIDObj, ITextStyle textStyle, BlackBoxObj blackBox, int nSide) {
        if (this.m_nAutoSkip == 1 || this.m_nAutoSkip == 2) {
            this.m_nSkipFactor = this.getSkipFactor(rVectLabels);
        }
        if (this.m_nSkipFactor == 1) {
            ++this.m_nSkipFactor;
        }
        for (int i = 0; i < nNumLabels; ++i) {
            IdentObj newID;
            boolean bSkipLabel = this.skipFirstOrLastLabel(i, nNumLabels);
            if (bSkipLabel || this.m_nSkipFactor != 0 && i > this.m_nLabelBegin && i % this.m_nSkipFactor != 0) continue;
            Rectangle rLabel = rVectLabels.get(i);
            if (vectIDObj != null && vectIDObj.get(i) != null) {
                IdentObj idFromVector = vectIDObj.get(i);
                int s = idFromVector.getSeriesID();
                int gg = idFromVector.getGroupID();
                newID = new IdentObj(this.m_template.getLabel().getObjectID(), s, gg);
                if (s == -3 && gg == -3) {
                    newID = newID.changeMisc(i);
                }
            } else {
                newID = this.m_template.getLabel();
                newID = newID.changeMisc(i);
            }
            if (this.m_Perspective.getTestLabelCalc() || !this.doDisplayOnCalc()) continue;
            BlackBoxObj bbMaybeFormatted = blackBox;
            AnnotationBox.calcBorderedBox(this.m_Perspective, this.m_template.getLabelBox(), rLabel, true);
            DrawFactory.createLabel(this.m_Perspective.getDetectiv(), newID, sVectLabels.get(i), rLabel, textStyle, bbMaybeFormatted, null);
        }
    }

    private boolean skipFirstOrLastLabel(int i, int nNumLabels) {
        boolean bSkip = false;
        if (i == 0 && this.m_Perspective.getExcludeMinLabel(this.m_template.getLabel())) {
            bSkip = true;
        }
        if (i == nNumLabels - 1 && this.m_Perspective.getExcludeMaxLabel(this.m_template.getLabel())) {
            bSkip = true;
        }
        return bSkip;
    }

    List<Double> getRelLabelPos(int nNumLabels) {
        ArrayList<Double> nVectLabelPos = new ArrayList<Double>(nNumLabels);
        for (int i = 0; i < nNumLabels; ++i) {
            nVectLabelPos.add(new Double(this.getLabelRelPos(i)));
        }
        return nVectLabelPos;
    }

    public List<Rectangle> getLabelRects() {
        return this.m_LabelRectListVC;
    }

    @Override
    public int getAxisTextLabelSizeVC() {
        return this.m_axisLabelTextSizeVC;
    }

    @Override
    public int getAxisObjID() {
        return this.m_template.getAxisObjID();
    }

    public AxisTemplate getAxisTemplate() {
        return this.m_template;
    }

    @Override
    public IdentObj getAxisIdentObj() {
        return this.m_template.getAxis();
    }

    @Override
    public int getMaxLabelSize() {
        return this.m_maxLabelSize;
    }

    @Override
    public final boolean isAscending() {
        return this.m_bAscending;
    }

    @Override
    public final boolean isDescending() {
        return !this.m_bAscending;
    }

    private boolean isO1Axis() {
        boolean bO1Axis = this.m_nAxisObjectID == 2001;
        return bO1Axis;
    }

    public void setDrawGrids(boolean bDrawGrids) {
        this.m_bDrawGrids = bDrawGrids;
    }

    Dimension findLargestLabelFastest(int nNumLabels, Dimension dimWrappingMaxDC, List<String> sVectLabels, ITextStyle textStyle) {
        Dimension dimLargestLabelDC = new Dimension(300, 300);
        if (nNumLabels > 0) {
            dimLargestLabelDC = TextUtil.getDimLargestWidthLabelDC(this.m_Perspective.getVC(), sVectLabels, dimWrappingMaxDC, textStyle);
        }
        return dimLargestLabelDC;
    }

    @Override
    public Rectangle getAxisRect() {
        Rectangle r = new Rectangle();
        boolean is3D = this.m_Perspective.getJGraphType().is3DType();
        if (is3D) {
            JChart_3D chart3D = (JChart_3D)this.m_Perspective.getGraphObject();
            switch (this.m_template.getAxisObjID()) {
                case 5: {
                    r = chart3D.getFloor().getProjectedVertices().getBounds();
                    Rectangle temp = chart3D.getRightWall().getProjectedVertices().getBounds();
                    r.x = temp.x;
                    r.width -= temp.x;
                    break;
                }
                case 6: {
                    r = chart3D.getFloor().getProjectedVertices().getBounds();
                    Rectangle temp = chart3D.getRightWall().getProjectedVertices().getBounds();
                    r.width = temp.x - r.width;
                    break;
                }
                case 0: {
                    r = chart3D.getLeftWall().getProjectedVertices().getBounds();
                }
            }
        } else {
            r.x = AxisUtils.getAxisLength(this.m_Perspective, this.m_template, false);
            r.y = AxisUtils.getAxisLength(this.m_Perspective, this.m_template, true);
            if (this.isVertical()) {
                r.height = AxisUtils.getAxisLength(this.m_Perspective, this.m_template, this.isVertical());
                r.width = 1;
            } else {
                r.width = AxisUtils.getAxisLength(this.m_Perspective, this.m_template, this.isVertical());
                r.height = 1;
            }
        }
        return r;
    }

    public void setParetoSeriesMaximum(int nSeries, double fValue) {
        this.m_nParetoSeriesMaximums[nSeries] = fValue;
    }

    public double getParetoSeriesMaximum(int nSeries) {
        return this.m_nParetoSeriesMaximums[nSeries];
    }

    public void setParetoSeriesMinimum(int nSeries, double fValue) {
        this.m_nParetoSeriesMinimums[nSeries] = fValue;
    }

    public double getParetoSeriesMinimum(int nSeries) {
        return this.m_nParetoSeriesMinimums[nSeries];
    }

    public void setLabelStagger(boolean val) {
        this.m_bLabelStagger = val;
    }

    abstract void adjustTitlePosPass1(int var1, List<Rectangle> var2, Rectangle var3);

    abstract void adjustTitlePosPass2(IdentObj var1, int var2, Rectangle var3, Dimension var4);

    abstract boolean isAxisLabelVisible(int var1);

    abstract boolean doDisplayOnCalc();

    void adjustLabelPos(int nSide, List<Rectangle> labelRects) {
    }

    abstract void calcMajorGridLine(IdentObj var1, double var2, IBlackBox var4);

    abstract void calcMinorGridLine(IdentObj var1, double var2, IBlackBox var4);

    abstract void calcMajorTickLine(double var1);

    abstract void calcMinorTickLine(double var1);

    abstract void getLabelAndTitlePos(int var1, int var2, List<Rectangle> var3, List<Double> var4, List<Integer> var5, Rectangle var6, boolean var7, int var8, int var9, int var10, ITextStyle var11);

    abstract double getLabelRelPos(int var1);

    abstract List<IdentObj> getLabelIdents();

    abstract boolean getMajorGridDisplay(AxisTemplate var1);

    abstract boolean getMinorGridDisplay(AxisTemplate var1);

    abstract double getMinorGridPos(int var1, int var2);

    abstract boolean getMajorTickDisplay(AxisTemplate var1);

    abstract boolean getMinorTickDisplay(AxisTemplate var1);

    abstract void calcOrdinalScale();

    abstract int getNumLabels();

    abstract int getNumMinorGrids();

    abstract int getTitleRotation(AxisTemplate var1, int var2);

    @Override
    public Format getDataTextFormat() {
        return this.m_DataTextFormat;
    }

    @Override
    public Format getLabelFormat() {
        return this.m_LabelFormat;
    }
}

