/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.border;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.GraphicsUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.RoundRectangleShape;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.border.BorderInfoObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.border.IBorder;
import java.awt.Polygon;
import java.awt.Rectangle;

class DoubleLineBorder
implements IBorder {
    protected BorderInfoObj m_borderInfo;
    protected Perspective m_Perspective;

    DoubleLineBorder(Perspective perspective, BorderInfoObj borderInfo) {
        this.m_Perspective = perspective;
        this.m_borderInfo = borderInfo;
    }

    public void calc() {
        IBlackBox outsideBlackBox = this.m_borderInfo.copyFromBlackBox(this.m_Perspective);
        IBlackBox insideBlackBox = this.m_borderInfo.copyFromBlackBox(this.m_Perspective);
        Polygon outsidePolygon = new Polygon();
        Polygon insidePolygon = new Polygon();
        outsideBlackBox.setTransparentFillColor(true);
        insideBlackBox.setTransparentFillColor(true);
        outsideBlackBox.setTransparentBorderColor(false);
        insideBlackBox.setTransparentBorderColor(false);
        Rectangle rOutside = new Rectangle(this.m_borderInfo.m_rBoundsVC);
        Rectangle rInside = new Rectangle(this.m_borderInfo.m_rBoundsVC);
        rInside.height -= this.m_borderInfo.m_Inset.bottom + this.m_borderInfo.m_Inset.top;
        rInside.width -= this.m_borderInfo.m_Inset.right + this.m_borderInfo.m_Inset.left;
        rInside.x += this.m_borderInfo.m_Inset.left;
        rInside.y += this.m_borderInfo.m_Inset.bottom;
        float xArc = this.m_borderInfo.m_nCornerArcWidth;
        float yArc = this.m_borderInfo.m_nCornerArcHeight;
        RoundRectangleShape outsideBorder = new RoundRectangleShape(rOutside, xArc, yArc, this.m_borderInfo.m_Inset);
        float iwidth = rInside.width;
        float iheight = rInside.height;
        float owidth = rOutside.width;
        float oheight = rOutside.height;
        float xRatio = iwidth / owidth;
        float yRatio = iheight / oheight;
        RoundRectangleShape insideBorder = new RoundRectangleShape(rInside, xArc *= xRatio, yArc *= yRatio, this.m_borderInfo.m_Inset);
        outsidePolygon = GraphicsUtil.toPolygon(outsideBorder);
        insidePolygon = GraphicsUtil.toPolygon(insideBorder);
        DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), this.m_borderInfo.m_idBorder, outsidePolygon, outsideBlackBox, null, 1.0);
        DrawFactory.createPolygon(this.m_Perspective.getDetectiv(), this.m_borderInfo.m_idBorder, insidePolygon, insideBlackBox, null, 1.0);
    }
}

