/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.VC;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DetObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IDrawContainer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;

class DetPolygon
extends DetObj {
    private Polygon m_polygon;
    private double colorIntensity;

    DetPolygon(IDrawContainer container, IdentObj id, Polygon poly, IBlackBox blackBox, double fIntensity) {
        super(container, id, blackBox, null);
        this.m_polygon = poly;
        this.colorIntensity = fIntensity;
        assert (this.m_polygon.npoints > 0);
        assert (this.colorIntensity >= 0.0 && this.colorIntensity <= 1.0);
    }

    DetPolygon(IDrawContainer container, IdentObj id, Polygon poly, IBlackBox blackBox, Rectangle clipRect) {
        this(container, id, poly, blackBox, clipRect, 1.0);
    }

    DetPolygon(IDrawContainer container, IdentObj id, Polygon poly, IBlackBox blackBox, Rectangle clipRect, double fIntensity) {
        super(container, id, blackBox, clipRect);
        this.m_polygon = poly;
        this.colorIntensity = fIntensity;
        assert (this.m_polygon.npoints > 0);
        assert (this.colorIntensity >= 0.0 && this.colorIntensity <= 1.0);
    }

    public void hilite(Graphics2D g, VC vc) {
        Polygon dest = vc.virtToDest(this.m_polygon);
        g.setXORMode(Color.yellow);
        g.drawPolygon(dest);
        g.setPaintMode();
    }

    public void paintIt(Graphics2D g, VC vc) {
        Polygon pDest = vc.virtToDest(this.m_polygon);
        double oldIntensity = this.blackBox.getIntensity();
        this.blackBox.setIntensity(this.colorIntensity);
        this.blackBox.paintPolygon(g, pDest);
        this.blackBox.setIntensity(oldIntensity);
    }

    public Shape getShape() {
        return this.m_polygon;
    }
}

