/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.common.value;

import com.crystaldecisions12.reports.common.value.FormulaValue;
import com.crystaldecisions12.reports.common.value.FormulaValueType;
import com.crystaldecisions12.reports.common.value.RangeValue;
import com.crystaldecisions12.reports.common.value.ValueType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ArrayValue
extends FormulaValue {
    private final FormulaValue[] goto;
    private final ValueType else;
    private static final FormulaValue[] long = new FormulaValue[0];
    public static final ArrayValue emptyNumberArray = new ArrayValue(long, FormulaValueType.number, false);
    public static final ArrayValue emptyCurrencyArray = new ArrayValue(long, FormulaValueType.currency, false);
    public static final ArrayValue emptyBooleanArray = new ArrayValue(long, FormulaValueType.bool, false);
    public static final ArrayValue emptyDateArray = new ArrayValue(long, FormulaValueType.date, false);
    public static final ArrayValue emptyTimeArray = new ArrayValue(long, FormulaValueType.time, false);
    public static final ArrayValue emptyDateTimeArray = new ArrayValue(long, FormulaValueType.dateTime, false);
    public static final ArrayValue emptyStringArray = new ArrayValue(long, FormulaValueType.string, false);
    public static final ArrayValue emptyNumberRangeArray = new ArrayValue(long, FormulaValueType.numberRange, false);
    public static final ArrayValue emptyCurrencyRangeArray = new ArrayValue(long, FormulaValueType.currencyRange, false);
    public static final ArrayValue emptyDateRangeArray = new ArrayValue(long, FormulaValueType.dateRange, false);
    public static final ArrayValue emptyTimeRangeArray = new ArrayValue(long, FormulaValueType.timeRange, false);
    public static final ArrayValue emptyDateTimeRangeArray = new ArrayValue(long, FormulaValueType.dateTimeRange, false);
    public static final ArrayValue emptyStringRangeArray = new ArrayValue(long, FormulaValueType.stringRange, false);

    private ArrayValue(FormulaValue[] formulaValueArray, FormulaValueType formulaValueType, boolean bl2) {
        this.goto = formulaValueArray;
        if (formulaValueType.isArray()) {
            throw new IllegalArgumentException("Arrays are not permitted in an ArrayValue.");
        }
        if (bl2 && !formulaValueType.isRange()) {
            if (formulaValueType == FormulaValueType.bool) {
                throw new IllegalArgumentException("There are no boolean range values");
            }
            formulaValueType = formulaValueType.getRangeFormulaValueType();
        }
        if (this.goto.length > 0) {
            if (formulaValueType.getBaseFormulaValueType() == FormulaValueType.unknown) {
                throw new IllegalArgumentException("An array value cannot be of unknown type");
            }
            ValueType valueType = formulaValueType.toValueType();
            for (int i2 = 0; i2 < this.goto.length; ++i2) {
                if (this.goto[i2] == null) continue;
                ValueType valueType2 = this.goto[i2].getValueType();
                if (bl2 && !valueType2.else()) {
                    this.goto[i2] = RangeValue.fromSingleValue(this.goto[i2]);
                    valueType2 = this.goto[i2].getValueType();
                }
                if (valueType2 == valueType) continue;
                throw new IllegalArgumentException("All Values must have the same ValueType.");
            }
        }
        this.else = formulaValueType.toValueType().void();
    }

    private static ArrayValue a(FormulaValue[] formulaValueArray, FormulaValueType formulaValueType, boolean bl2) {
        if (formulaValueArray == null) {
            return null;
        }
        if (formulaValueArray.length == 0) {
            if (bl2) {
                if (formulaValueType == FormulaValueType.bool) {
                    throw new IllegalArgumentException("There are no boolean range values");
                }
                formulaValueType = formulaValueType.getRangeFormulaValueType();
            }
            switch (formulaValueType.value()) {
                case 6: {
                    return emptyNumberArray;
                }
                case 7: {
                    return emptyCurrencyArray;
                }
                case 8: {
                    return emptyBooleanArray;
                }
                case 9: {
                    return emptyDateArray;
                }
                case 10: {
                    return emptyTimeArray;
                }
                case 15: {
                    return emptyDateTimeArray;
                }
                case 11: {
                    return emptyStringArray;
                }
                case 4102: {
                    return emptyNumberRangeArray;
                }
                case 4103: {
                    return emptyCurrencyRangeArray;
                }
                case 4105: {
                    return emptyDateRangeArray;
                }
                case 4106: {
                    return emptyTimeRangeArray;
                }
                case 4111: {
                    return emptyDateTimeRangeArray;
                }
                case 4107: {
                    return emptyStringRangeArray;
                }
            }
        }
        return new ArrayValue(formulaValueArray, formulaValueType, bl2);
    }

    private static FormulaValue[] if(FormulaValue[] formulaValueArray) {
        if (formulaValueArray == null) {
            return null;
        }
        if (formulaValueArray.length == 0) {
            return formulaValueArray;
        }
        return (FormulaValue[])formulaValueArray.clone();
    }

    private static FormulaValue[] a(List list) {
        if (list == null) {
            return null;
        }
        int n2 = list.size();
        if (n2 == 0) {
            return long;
        }
        FormulaValue[] formulaValueArray = new FormulaValue[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Object e10 = list.get(i2);
            if (e10 != null && !(e10 instanceof FormulaValue)) {
                throw new IllegalArgumentException("All values in the list must be 'FormulaValue' objects.");
            }
            formulaValueArray[i2] = (FormulaValue)e10;
        }
        return formulaValueArray;
    }

    private static FormulaValueType a(FormulaValue[] formulaValueArray) {
        FormulaValueType formulaValueType = FormulaValueType.unknown;
        if (formulaValueArray != null) {
            for (int i2 = 0; i2 < formulaValueArray.length; ++i2) {
                if (formulaValueArray[i2] == null) continue;
                formulaValueType = formulaValueArray[i2].getFormulaValueType();
                break;
            }
        }
        return formulaValueType;
    }

    public static ArrayValue fromArray(FormulaValue[] formulaValueArray) {
        return ArrayValue.a(ArrayValue.if(formulaValueArray), ArrayValue.a(formulaValueArray), false);
    }

    public static ArrayValue fromArray(FormulaValue[] formulaValueArray, FormulaValueType formulaValueType) {
        return ArrayValue.a(ArrayValue.if(formulaValueArray), formulaValueType, false);
    }

    public static ArrayValue fromMixedRangeArray(FormulaValue[] formulaValueArray) {
        return ArrayValue.a(ArrayValue.if(formulaValueArray), ArrayValue.a(formulaValueArray), true);
    }

    public static ArrayValue fromMixedRangeArray(FormulaValue[] formulaValueArray, FormulaValueType formulaValueType) {
        return ArrayValue.a(ArrayValue.if(formulaValueArray), formulaValueType, true);
    }

    public static ArrayValue fromSingleValue(FormulaValue formulaValue) {
        return ArrayValue.a(new FormulaValue[]{formulaValue}, formulaValue.getFormulaValueType(), false);
    }

    public static ArrayValue fromSingleValue(FormulaValue formulaValue, FormulaValueType formulaValueType) {
        return ArrayValue.a(new FormulaValue[]{formulaValue}, formulaValueType, false);
    }

    private static ArrayValue a(List list, boolean bl2) {
        FormulaValue[] formulaValueArray = ArrayValue.a(list);
        return ArrayValue.a(formulaValueArray, ArrayValue.a(formulaValueArray), bl2);
    }

    public static ArrayValue fromList(List list) {
        return ArrayValue.a(list, false);
    }

    private static ArrayValue a(List list, FormulaValueType formulaValueType, boolean bl2) {
        return ArrayValue.a(ArrayValue.a(list), formulaValueType, bl2);
    }

    public static ArrayValue fromList(List list, FormulaValueType formulaValueType) {
        return ArrayValue.a(list, formulaValueType, false);
    }

    public static ArrayValue fromMixedRangeList(List list) {
        return ArrayValue.a(list, true);
    }

    public static ArrayValue fromMixedRangeList(List list, FormulaValueType formulaValueType) {
        return ArrayValue.a(list, formulaValueType, true);
    }

    public FormulaValue coerceToNumber() {
        return this.a(FormulaValueType.number);
    }

    public FormulaValue coerceToCurrency() {
        return this.a(FormulaValueType.currency);
    }

    public FormulaValue coerceToBoolean() {
        return this.a(FormulaValueType.bool);
    }

    public FormulaValue coerceToDate() {
        return this.a(FormulaValueType.date);
    }

    public FormulaValue coerceToTime() {
        return this.a(FormulaValueType.time);
    }

    public FormulaValue coerceToDateTime() {
        return this.a(FormulaValueType.dateTime);
    }

    public FormulaValue coerceToString() {
        return this.a(FormulaValueType.string);
    }

    private FormulaValue a(FormulaValueType formulaValueType) {
        int n2;
        FormulaValueType formulaValueType2 = this.getFormulaValueType();
        FormulaValueType formulaValueType3 = formulaValueType2.getBaseFormulaValueType();
        if (formulaValueType3 == formulaValueType) {
            return this;
        }
        FormulaValueType formulaValueType4 = formulaValueType;
        if (formulaValueType2.isRange()) {
            formulaValueType4 = formulaValueType4.getRangeFormulaValueType();
        }
        if ((n2 = this.getLength()) == 0) {
            return ArrayValue.a(long, formulaValueType4, false);
        }
        FormulaValue[] formulaValueArray = new FormulaValue[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.get(i2) == null) continue;
            formulaValueArray[i2] = ArrayValue.coerce(this.get(i2), formulaValueType4);
            if (formulaValueArray[i2] != null) continue;
            return null;
        }
        return ArrayValue.a(formulaValueArray, formulaValueType4, false);
    }

    public FormulaValue coerceToRange() {
        if (this.getValueType().else()) {
            return this;
        }
        return ArrayValue.a(this.getArray(), this.getFormulaValueType().getNonArrayFormulaValueType(), true);
    }

    public FormulaValue coerceToArray() {
        return this;
    }

    public FormulaValue[] getArray() {
        return ArrayValue.if(this.goto);
    }

    public List getList() {
        ArrayList<FormulaValue> arrayList = new ArrayList<FormulaValue>();
        for (int i2 = 0; i2 < this.getLength(); ++i2) {
            arrayList.add(this.get(i2));
        }
        return arrayList;
    }

    public int getLength() {
        return this.goto.length;
    }

    public FormulaValue get(int n2) {
        return this.goto[n2];
    }

    public ValueType getValueType() {
        return this.else;
    }

    public FormulaValueType getElementFormulaValueType() {
        return this.getFormulaValueType().getNonArrayFormulaValueType();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass() || ((ArrayValue)object).getLength() != this.getLength()) {
            return false;
        }
        for (int i2 = 0; i2 < this.getLength(); ++i2) {
            if (!(this.get(i2) == null ? ((ArrayValue)object).get(i2) != null : !this.get(i2).equals(((ArrayValue)object).get(i2)))) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object object, Comparator comparator) {
        if (object == this) {
            return 0;
        }
        ArrayValue arrayValue = (ArrayValue)object;
        if (this.getValueType() != arrayValue.getValueType()) {
            throw new ClassCastException("Can't compare ArrayValues with different valueTypes");
        }
        int n2 = ArrayValue.a(this.getLength(), arrayValue.getLength());
        if (n2 != 0) {
            return n2;
        }
        for (int i2 = 0; i2 < this.getLength(); ++i2) {
            n2 = ArrayValue.a(this.get(i2) == null ? 0 : 1, arrayValue.get(i2) == null ? 0 : 1);
            if (n2 != 0) {
                return n2;
            }
            if (this.get(i2) == null && arrayValue.get(i2) == null || (n2 = this.get(i2).compareTo(arrayValue.get(i2), comparator)) == 0) continue;
            return n2;
        }
        return 0;
    }

    public int hashCode() {
        int n2 = 17;
        for (int i2 = 0; i2 < this.getLength(); ++i2) {
            n2 = 37 * n2 + (this.get(i2) == null ? 0 : this.get(i2).hashCode());
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("a(");
        for (int i2 = 0; i2 < this.getLength(); ++i2) {
            if (i2 > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(this.get(i2));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

