/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.formulas.functions.math;

import com.crystaldecisions.reports.common.value.CurrencyValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.FormulaValueType;
import com.crystaldecisions.reports.common.value.NumberValue;
import com.crystaldecisions.reports.common.value.NumericValue;
import com.crystaldecisions.reports.formulas.FormulaEnvironment;
import com.crystaldecisions.reports.formulas.FormulaFunctionArgumentDefinition;
import com.crystaldecisions.reports.formulas.FormulaFunctionArgumentException;
import com.crystaldecisions.reports.formulas.FormulaFunctionBase;
import com.crystaldecisions.reports.formulas.FormulaFunctionCallException;
import com.crystaldecisions.reports.formulas.FormulaFunctionDefinition;
import com.crystaldecisions.reports.formulas.FormulaResources;
import com.crystaldecisions.reports.formulas.FormulaValueReference;
import com.crystaldecisions.reports.formulas.functions.CommonArguments;
import com.crystaldecisions.reports.formulas.functions.FormulaFunctionFactory;

public class RemainderFunctionFactory
implements FormulaFunctionFactory {
    private static RemainderFunctionFactory eG = new RemainderFunctionFactory();
    private static final FormulaFunctionArgumentDefinition[][] eH = new FormulaFunctionArgumentDefinition[][]{{CommonArguments.num, CommonArguments.denom}, {CommonArguments.numCurr, CommonArguments.denom}, {CommonArguments.num, CommonArguments.denomCurr}, {CommonArguments.numCurr, CommonArguments.denomCurr}};
    private static final FormulaFunctionDefinition[] eI = new FormulaFunctionDefinition[]{new a(eH[0]), new a(eH[1]), new a(eH[2]), new a(eH[3])};

    private RemainderFunctionFactory() {
    }

    public static RemainderFunctionFactory az() {
        return eG;
    }

    public FormulaFunctionDefinition getFunctionInstance(int n2) {
        return eI[n2];
    }

    public int getNFunctionInstances() {
        return eI.length;
    }

    private static class a
    extends FormulaFunctionBase {
        public a(FormulaFunctionArgumentDefinition[] formulaFunctionArgumentDefinitionArray) {
            super("Remainder", "remainder", formulaFunctionArgumentDefinitionArray);
        }

        public FormulaValueType validate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            NumericValue numericValue;
            if (formulaValueReferenceArray[1].getFormulaValue() != null && (numericValue = (NumericValue)formulaValueReferenceArray[1].getFormulaValue()).getDouble() == 0.0) {
                throw new FormulaFunctionArgumentException("JRC00002461", "", FormulaResources.a(), "DivisionByZero", 1);
            }
            return formulaValueReferenceArray[0].getFormulaValueType();
        }

        public FormulaValue evaluate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            boolean bl2;
            this.validate(formulaValueReferenceArray, formulaEnvironment);
            NumericValue numericValue = (NumericValue)formulaValueReferenceArray[0].getFormulaValue();
            NumericValue numericValue2 = (NumericValue)formulaValueReferenceArray[1].getFormulaValue();
            double d10 = numericValue.getScaledDouble() % numericValue2.getScaledDouble();
            FormulaValueType formulaValueType = formulaValueReferenceArray[0].getFormulaValue().getFormulaValueType();
            FormulaValueType formulaValueType2 = formulaValueReferenceArray[0].getFormulaValue().getFormulaValueType();
            boolean bl3 = bl2 = formulaValueType == FormulaValueType.currency || formulaValueType2 == FormulaValueType.currency;
            if (bl2) {
                return CurrencyValue.fromScaledDouble((double)d10);
            }
            return NumberValue.fromScaledDouble((double)d10);
        }
    }
}

