/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common;

import com.crystaldecisions.reports.common.SaveLoadException;
import com.crystaldecisions.reports.common.TwipSize;
import com.crystaldecisions.reports.common.archive.ArchiveException;
import com.crystaldecisions.reports.common.archive.IInputArchive;
import com.crystaldecisions.reports.common.archive.IOutputArchive;
import com.crystaldecisions.reports.common.archive.ITslvInputRecordArchive;
import com.crystaldecisions.reports.common.archive.ITslvOutputRecordArchive;

public final class TwipPoint {
    public static final TwipPoint ZERO_POSITION = new TwipPoint(0, 0);
    public final int x;
    public final int y;

    public TwipPoint(int n2, int n3) {
        this.x = n2;
        this.y = n3;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TwipPoint twipPoint = (TwipPoint)object;
        return this.x == twipPoint.x && this.y == twipPoint.y;
    }

    public int hashCode() {
        return 17 * this.x + this.y;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TwipPoint:<x=");
        stringBuilder.append(this.x);
        stringBuilder.append("><y=");
        stringBuilder.append(this.y);
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    public TwipPoint addOffset(TwipSize twipSize) {
        return new TwipPoint(this.x + twipSize.cx, this.y + twipSize.cy);
    }

    public TwipPoint addOffset(int n2, int n3) {
        if (n2 == 0 && n3 == 0) {
            return this;
        }
        return new TwipPoint(this.x + n2, this.y + n3);
    }

    public TwipPoint addXOffset(int n2) {
        if (n2 == 0) {
            return this;
        }
        return new TwipPoint(this.x + n2, this.y);
    }

    public TwipPoint addYOffset(int n2) {
        if (n2 == 0) {
            return this;
        }
        return new TwipPoint(this.x, this.y + n2);
    }

    public void saveContentsIn(IOutputArchive iOutputArchive) throws SaveLoadException, ArchiveException {
        iOutputArchive.storeInt32(this.x);
        iOutputArchive.storeInt32(this.y);
    }

    public static TwipPoint LoadFrom(IInputArchive iInputArchive) throws ArchiveException, SaveLoadException {
        int n2 = iInputArchive.loadInt32();
        int n3 = iInputArchive.loadInt32();
        return new TwipPoint(n2, n3);
    }

    public void store(ITslvOutputRecordArchive iTslvOutputRecordArchive) throws SaveLoadException, ArchiveException {
        iTslvOutputRecordArchive.storeInt32Compressed(this.x);
        iTslvOutputRecordArchive.storeInt32Compressed(this.y);
    }

    public static TwipPoint Load(ITslvInputRecordArchive iTslvInputRecordArchive) throws SaveLoadException, ArchiveException {
        int n2 = iTslvInputRecordArchive.loadInt32Compressed();
        int n3 = iTslvInputRecordArchive.loadInt32Compressed();
        return new TwipPoint(n2, n3);
    }
}

