/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.enterpriserepositoryservice;

import com.businessobjects.sdk.enterpriserepositoryservice.EnterpriseRepositoryAgent;
import com.businessobjects.sdk.enterpriserepositoryservice.ReportSDKEnterpriseException;
import com.businessobjects.sdk.enterpriserepositoryservice.RepositoryInfo;
import com.businessobjects.sdk.enterpriserepositoryservice.RepositoryObjectType;
import com.crystaldecisions.reports.common.asserts.CrystalAssert;
import com.crystaldecisions.reports.enterpriserepository.EnterpriseException;
import com.crystaldecisions.reports.enterpriserepository.EnterpriseRepositoryAgentBase;
import com.crystaldecisions.reports.enterpriserepository.EnterpriseRepositoryURI;
import com.crystaldecisions.reports.enterpriserepository.IRepositoryPlugin;
import com.crystaldecisions.sdk.occa.report.application.IReportClientDocument;
import com.crystaldecisions.sdk.occa.report.application.ISubreportClientDocument;
import com.crystaldecisions.sdk.occa.report.application.ReportClientDocument;
import com.crystaldecisions.sdk.occa.report.data.CustomFunctions;
import com.crystaldecisions.sdk.occa.report.data.ICustomFunction;
import com.crystaldecisions.sdk.occa.report.definition.Areas;
import com.crystaldecisions.sdk.occa.report.definition.IPictureObject;
import com.crystaldecisions.sdk.occa.report.definition.IReportObject;
import com.crystaldecisions.sdk.occa.report.definition.ITextObject;
import com.crystaldecisions.sdk.occa.report.definition.ReportDefinition;
import com.crystaldecisions.sdk.occa.report.definition.Sections;
import com.crystaldecisions.sdk.occa.report.lib.ControllableList;
import com.crystaldecisions.sdk.occa.report.lib.IClone;
import com.crystaldecisions.sdk.occa.report.lib.IRepositoryObjectInternal;
import com.crystaldecisions.sdk.occa.report.lib.IStrings;
import com.crystaldecisions.sdk.occa.report.lib.ReportSDKException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeneralRepositoryObjectServices {
    protected EnterpriseRepositoryAgent a = null;

    static GeneralRepositoryObjectServices a(EnterpriseRepositoryAgent enterpriseRepositoryAgent) {
        return new GeneralRepositoryObjectServices(enterpriseRepositoryAgent);
    }

    protected GeneralRepositoryObjectServices(EnterpriseRepositoryAgent enterpriseRepositoryAgent) {
        this.a = enterpriseRepositoryAgent;
    }

    public static final Map<RepositoryObjectType, Map<String, String>> GetManagedObjectCUIDs(ReportClientDocument reportClientDocument) throws ReportSDKException {
        Map<RepositoryObjectType, List<RepositoryInfo>> map = GeneralRepositoryObjectServices.a(reportClientDocument);
        HashMap<RepositoryObjectType, Map<String, String>> hashMap = new HashMap<RepositoryObjectType, Map<String, String>>();
        List<RepositoryInfo> list = map.get((Object)RepositoryObjectType.TextObject);
        hashMap.put(RepositoryObjectType.TextObject, GeneralRepositoryObjectServices.a(list));
        List<RepositoryInfo> list2 = map.get((Object)RepositoryObjectType.PictureObject);
        hashMap.put(RepositoryObjectType.PictureObject, GeneralRepositoryObjectServices.a(list2));
        List<RepositoryInfo> list3 = map.get((Object)RepositoryObjectType.CustomFunction);
        hashMap.put(RepositoryObjectType.CustomFunction, GeneralRepositoryObjectServices.a(list3));
        return hashMap;
    }

    private static Map<String, String> a(List<RepositoryInfo> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (RepositoryInfo repositoryInfo : list) {
            String string = repositoryInfo.getObjectCUID();
            String string2 = repositoryInfo.getObjectNameInReport();
            hashMap.put(string2, string);
        }
        return hashMap;
    }

    private static Map<RepositoryObjectType, List<RepositoryInfo>> a(ReportClientDocument reportClientDocument) throws ReportSDKException {
        HashMap<RepositoryObjectType, List<RepositoryInfo>> hashMap = new HashMap<RepositoryObjectType, List<RepositoryInfo>>();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        hashMap.put(RepositoryObjectType.TextObject, arrayList);
        hashMap.put(RepositoryObjectType.PictureObject, arrayList2);
        hashMap.put(RepositoryObjectType.CustomFunction, arrayList3);
        GeneralRepositoryObjectServices.a(reportClientDocument, hashMap);
        IStrings iStrings = reportClientDocument.getSubreportController().getSubreportNames();
        Iterator iterator = iStrings.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = string = (String)iterator.next();
            ISubreportClientDocument iSubreportClientDocument = reportClientDocument.getSubreportController().getSubreport(string2);
            GeneralRepositoryObjectServices.a(iSubreportClientDocument, hashMap);
        }
        return hashMap;
    }

    private static void a(IReportClientDocument iReportClientDocument, Map<RepositoryObjectType, List<RepositoryInfo>> map) throws ReportSDKException {
        Object object;
        IClone iClone2;
        List<RepositoryInfo> list = map.get((Object)RepositoryObjectType.TextObject);
        List<RepositoryInfo> list2 = map.get((Object)RepositoryObjectType.PictureObject);
        List<RepositoryInfo> list3 = map.get((Object)RepositoryObjectType.CustomFunction);
        ReportDefinition reportDefinition = iReportClientDocument.getReportDefController().getReportDefinition();
        Areas areas = reportDefinition.getAreas();
        for (IClone iClone2 : areas) {
            Sections sections = iClone2.getSections();
            for (Object object2 : sections) {
                object = object2.getReportObjects();
                Iterator iterator = ((ControllableList)object).iterator();
                while (iterator.hasNext()) {
                    String string;
                    IReportObject iReportObject = (IReportObject)iterator.next();
                    if (!(iReportObject instanceof IRepositoryObjectInternal) || (string = GeneralRepositoryObjectServices.a((IRepositoryObjectInternal)((Object)iReportObject))) == null) continue;
                    String string2 = iReportObject.getName();
                    RepositoryInfo repositoryInfo = null;
                    if (iReportObject instanceof ITextObject) {
                        repositoryInfo = new RepositoryInfo(string2, RepositoryObjectType.TextObject);
                        list.add(repositoryInfo);
                    } else if (iReportObject instanceof IPictureObject) {
                        repositoryInfo = new RepositoryInfo(string2, RepositoryObjectType.PictureObject);
                        list2.add(repositoryInfo);
                    } else {
                        CrystalAssert.ASSERT((boolean)false);
                        throw new RuntimeException("repository link should not exist in this type of report object" + iReportObject.getClass().toString());
                    }
                    repositoryInfo.if(((IRepositoryObjectInternal)((Object)iReportObject)).getLinkedURI());
                    repositoryInfo.a(string);
                }
            }
        }
        iClone2 = iReportClientDocument.getCustomFunctionController().getCustomFunctions();
        for (int i2 = 0; i2 < ((ArrayList)((Object)iClone2)).size(); ++i2) {
            Object object2;
            ICustomFunction iCustomFunction = ((CustomFunctions)iClone2).getCustomFunction(i2);
            object2 = GeneralRepositoryObjectServices.a((IRepositoryObjectInternal)((Object)iCustomFunction));
            if (object2 == null) continue;
            object = new RepositoryInfo(iCustomFunction.getName(), RepositoryObjectType.CustomFunction);
            list3.add((RepositoryInfo)object);
            ((RepositoryInfo)object).if(((IRepositoryObjectInternal)((Object)iCustomFunction)).getLinkedURI());
            ((RepositoryInfo)object).a((String)object2);
        }
    }

    protected static String a(IRepositoryObjectInternal iRepositoryObjectInternal) throws ReportSDKException {
        String string = iRepositoryObjectInternal.getLinkedURI();
        if (string == null || string.length() == 0) {
            return null;
        }
        EnterpriseRepositoryURI enterpriseRepositoryURI = null;
        try {
            enterpriseRepositoryURI = new EnterpriseRepositoryURI(string);
            return EnterpriseRepositoryAgentBase.a(enterpriseRepositoryURI);
        }
        catch (EnterpriseException enterpriseException) {
            throw new ReportSDKEnterpriseException(-2147467259, "", (Throwable)((Object)enterpriseException));
        }
    }

    public final Map<RepositoryObjectType, List<RepositoryInfo>> getRepositoryObjectInfo(ReportClientDocument reportClientDocument) throws ReportSDKException {
        Map<RepositoryObjectType, List<RepositoryInfo>> map = GeneralRepositoryObjectServices.a(reportClientDocument);
        this.a(map.get((Object)RepositoryObjectType.TextObject), ITextObject.class);
        this.a(map.get((Object)RepositoryObjectType.PictureObject), IPictureObject.class);
        this.a(map.get((Object)RepositoryObjectType.CustomFunction), ICustomFunction.class);
        return map;
    }

    private <T> void a(List<RepositoryInfo> list, Class<T> clazz) throws ReportSDKException {
        if (list.size() == 0) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (RepositoryInfo object : list) {
            hashSet.add(object.getObjectCUID());
        }
        Object object = null;
        try {
            object = this.a.if(hashSet, clazz);
            if (object == null) {
                return;
            }
            for (RepositoryInfo repositoryInfo : list) {
                String string = repositoryInfo.getObjectCUID();
                if (!object.containsKey(string)) continue;
                IRepositoryPlugin iRepositoryPlugin = (IRepositoryPlugin)object.get(string);
                repositoryInfo.a(true);
                repositoryInfo.for(iRepositoryPlugin.void());
                repositoryInfo.do(iRepositoryPlugin.for());
                repositoryInfo.int(iRepositoryPlugin.char());
            }
        }
        catch (EnterpriseException enterpriseException) {
            throw new ReportSDKEnterpriseException(-2147467259, "", (Throwable)((Object)enterpriseException));
        }
    }

    public void refreshAll(ReportClientDocument reportClientDocument) throws ReportSDKException {
        reportClientDocument.refreshRepositoryObjects();
    }
}

