/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.filemanagement;

public final class RawData {
    public static final int BYTE_SIZE = 1;
    public static final int SHORT_SIZE = 2;
    public static final int INT_SIZE = 4;
    public static final int LONG_SIZE = 8;
    public static final int FLOAT_SIZE = 4;
    public static final int DOUBLE_SIZE = 8;
    public static final int CHAR_SIZE = 2;
    public static final int MAX_UNSIGNED_BYTE_VALUE = 255;
    public static final int MAX_UNSIGNED_SHORT_VALUE = 65535;
    public static final long MAX_UNSIGNED_INT_VALUE = -1L;

    private RawData() {
    }

    public static int Int8sFromData(byte[] byArray, int n) {
        return byArray[n];
    }

    public static int Int8uFromData(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    public static int Int16sFromData(byte[] byArray, int n) {
        return byArray[n + 1] & 0xFF | byArray[n] << 8;
    }

    public static int Int16uFromData(byte[] byArray, int n) {
        return byArray[n + 1] & 0xFF | (byArray[n] & 0xFF) << 8;
    }

    public static int Int32sFromData(byte[] byArray, int n) {
        return byArray[n + 3] & 0xFF | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 1] & 0xFF) << 16 | byArray[n] << 24;
    }

    public static long Int32uFromData(byte[] byArray, int n) {
        return (long)RawData.Int32sFromData(byArray, n) & 0xFFFFFFFFL;
    }

    public static long Int64sFromData(byte[] byArray, int n) {
        int n2 = byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        int n3 = byArray[n + 4] << 24 | (byArray[n + 5] & 0xFF) << 16 | (byArray[n + 6] & 0xFF) << 8 | byArray[n + 7] & 0xFF;
        return (long)n2 << 32 | (long)n3 & 0xFFFFFFFFL;
    }

    public static char charFromData(byte[] byArray, int n) {
        return (char)(byArray[n + 1] & 0xFF | byArray[n] << 8);
    }

    public static float FloatFromData(byte[] byArray, int n) {
        return Float.intBitsToFloat(RawData.Int32sFromData(byArray, n));
    }

    public static double DoubleFromData(byte[] byArray, int n) {
        return Double.longBitsToDouble(RawData.Int64sFromData(byArray, n));
    }

    public static void Int8ToData(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
    }

    public static void Int16ToData(int n, byte[] byArray, int n2) {
        byArray[n2 + 1] = (byte)n;
        byArray[n2] = (byte)(n >> 8);
    }

    public static void Int32ToData(int n, byte[] byArray, int n2) {
        byArray[n2 + 3] = (byte)n;
        byArray[n2 + 2] = (byte)(n >> 8);
        byArray[n2 + 1] = (byte)(n >> 16);
        byArray[n2] = (byte)(n >> 24);
    }

    public static void Int32uToData(long l, byte[] byArray, int n) {
        RawData.Int32ToData((int)l, byArray, n);
    }

    public static void Int64ToData(long l, byte[] byArray, int n) {
        int n2 = (int)l;
        int n3 = (int)(l >> 32);
        byArray[n] = (byte)(n3 >> 24);
        byArray[n + 1] = (byte)(n3 >> 16);
        byArray[n + 2] = (byte)(n3 >> 8);
        byArray[n + 3] = (byte)n3;
        byArray[n + 4] = (byte)(n2 >> 24);
        byArray[n + 5] = (byte)(n2 >> 16);
        byArray[n + 6] = (byte)(n2 >> 8);
        byArray[n + 7] = (byte)n2;
    }

    public static void charToData(char c, byte[] byArray, int n) {
        byArray[n + 1] = (byte)c;
        byArray[n] = (byte)(c >> 8);
    }

    public static void FloatToData(float f, byte[] byArray, int n) {
        RawData.Int32ToData(Float.floatToIntBits(f), byArray, n);
    }

    public static void DoubleToData(double d, byte[] byArray, int n) {
        RawData.Int64ToData(Double.doubleToLongBits(d), byArray, n);
    }
}

