/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.engine;

import com.crystaldecisions.common.keycode.KeyDecoderV2;
import com.crystaldecisions.common.keycode.KeycodeDecoderFactory;
import com.crystaldecisions.common.keycode.KeycodeException;
import com.crystaldecisions.reports.common.engine.Engine;
import com.crystaldecisions.reports.common.engine.config.ConfigurationObserver;
import com.crystaldecisions.reports.common.engine.config.ObservableConfiguration;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class KeycodeManager
implements ConfigurationObserver {
    private static final Logger else = Logger.getLogger((String)"com.crystaldecisions.reports.common");
    public static final int MIN_PRODUCT_VERSION = 110;
    public static final int MAX_PRODUCT_VERSION = 120;
    private static final String do = "KC.ProductVersion";
    private static final String for = "KC.OldProductEnum";
    private static final String a = "JRC.EnableJRC";
    private static final String new = "KC.LicCount";
    private static final String char = "JRC.Throttling";
    private static final String try = "JRC.Watermark";
    private static final int if = 2048;
    private static final int goto = 240;
    private Engine case;
    private String byte;
    private KeycodeInformation int;

    KeycodeManager(Engine engine) {
        this.case = engine;
    }

    void initialize() {
        this.case.getConfigurationManager().addObserver(this);
        this.a();
    }

    public String getActiveKeycode() {
        return this.byte;
    }

    public KeycodeInformation getActiveKeycodeInformation() {
        return this.int;
    }

    private void a() {
        String[] stringArray = this.case.getConfigurationManager().getStringArray("keycode");
        if (stringArray == null || stringArray.length == 0) {
            else.warn((Object)"No keycodes found");
        } else {
            this.a(stringArray);
        }
    }

    public String getKeyPrefix() {
        return "keycode";
    }

    public void configurationChanged(ObservableConfiguration observableConfiguration) {
        this.a();
    }

    private void a(String[] stringArray) {
        KeyDecoderV2 keyDecoderV2 = KeycodeDecoderFactory.getKeycodeDecoderV2();
        int n = 0;
        this.byte = null;
        this.int = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                keyDecoderV2.SetKey(string);
            }
            catch (KeycodeException keycodeException) {
                else.warn((Object)("Keycode ending with " + this.a(string) + " is not valid."), (Throwable)keycodeException);
            }
            KeycodeInformation keycodeInformation = this.a(keyDecoderV2);
            int n2 = this.a(keycodeInformation, this.a(string));
            if (n >= n2) continue;
            n = n2;
            this.byte = string;
            this.int = keycodeInformation;
        }
    }

    private int a(KeycodeInformation keycodeInformation, String string) {
        if (keycodeInformation.if < 110 || 120 < keycodeInformation.if) {
            else.warn((Object)("Keycode ending with " + string + " does not appear to be valid for this version of the Java Reporting Component"));
            return 0;
        }
        if (!keycodeInformation.do) {
            else.warn((Object)("Keycode ending with " + string + " does not enable the Java Reporting Component"));
            return 0;
        }
        if (keycodeInformation.for) {
            else.warn((Object)("Keycode ending with " + string + " is expired"));
            return 0;
        }
        int n = keycodeInformation.new;
        if (n == 0) {
            n = 1000;
        }
        return (keycodeInformation.a ? 0 : 100000) + n * 10 + (keycodeInformation.int ? 1 : 0);
    }

    private String a(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length() - 4;
        return "'" + string.substring(n <= 0 ? 0 : n) + "'";
    }

    private static int a(KeyDecoderV2 keyDecoderV2, String string) {
        try {
            return (int)keyDecoderV2.GetProperty(string);
        }
        catch (KeycodeException keycodeException) {
            return -1;
        }
    }

    private KeycodeInformation a(KeyDecoderV2 keyDecoderV2) {
        int n;
        boolean bl;
        int n2;
        int n3;
        int n4 = KeycodeManager.a(keyDecoderV2, do);
        boolean bl2 = false;
        if (n4 < 115) {
            n3 = KeycodeManager.a(keyDecoderV2, for);
            if (n3 == 34 || n3 == 6 || n3 == 27) {
                bl2 = true;
            }
        } else if (KeycodeManager.a(keyDecoderV2, a) > 0) {
            bl2 = true;
        }
        try {
            n3 = keyDecoderV2.IsExpired() ? 1 : 0;
        }
        catch (KeycodeException keycodeException) {
            n3 = 0;
        }
        if (n4 < 115) {
            n2 = KeycodeManager.a(keyDecoderV2, new);
            bl = (n2 & 0x800) != 0;
            n = (n2 & 0xF0) >> 4;
        } else {
            bl = true;
            n2 = KeycodeManager.a(keyDecoderV2, char);
            n = n2 < 0 ? 1 : n2;
        }
        n2 = n4 >= 115 && KeycodeManager.a(keyDecoderV2, try) != 0 ? 1 : 0;
        return new KeycodeInformation(n4, n, bl2, n3 != 0, bl, n2 != 0);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public final class KeycodeInformation {
        private final int if;
        private final int new;
        private final boolean do;
        private final boolean for;
        private final boolean int;
        private final boolean a;

        public KeycodeInformation(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.if = n;
            this.new = n2;
            this.do = bl;
            this.for = bl2;
            this.int = bl3;
            this.a = bl4;
        }

        public int getConcurrentRequests() {
            return this.new;
        }

        public boolean isExpired() {
            return this.for;
        }

        public boolean isJrcEnabled() {
            return this.do;
        }

        public int getProductVersion() {
            return this.if;
        }

        public boolean isUnlimitedRetry() {
            return this.int;
        }

        public boolean isWatermarked() {
            return this.a;
        }
    }
}

