/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common;

public class MaskBase {
    static final String MASK_VALUE_PASSWORD = "Password";
    static final String MASK_VALUE_PASSWORD2 = "*";
    static final char MASK_NUMERIC = '0';
    static final char MASK_NUMERICOPT = '9';
    static final char MASK_NUMERICSYMOPT = '#';
    static final char MASK_ALPHA = 'L';
    static final char MASK_ALPHAOPT = '?';
    static final char MASK_ALPHANUM = 'A';
    static final char MASK_ALPHANUMOPT = 'a';
    static final char MASK_ASCII = '&';
    static final char MASK_ASCIIOPT = 'C';
    static final char MASK_DIR_UPPERCASE = '>';
    static final char MASK_DIR_LOWERCASE = '<';
    static final char MASK_DIR_LITERAL = '\\';
    static final char PLUS_SIGN = '+';
    static final char MINUS_SIGN = '-';
    static final char DEFAULT_BLANK = '_';

    public static boolean isPasswordMask(String string) {
        return string != null && (string.compareToIgnoreCase(MASK_VALUE_PASSWORD) == 0 || string.compareTo(MASK_VALUE_PASSWORD2) == 0);
    }

    public static boolean isValidString(String string, String string2) {
        return MaskBase.getValidString(string, string2) != null;
    }

    public static String getValidString(String string, String string2) {
        char c;
        int n;
        if (MaskBase.isPasswordMask(string) || string.length() == 0) {
            return string2;
        }
        int n2 = string.length();
        int n3 = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n3);
        if (n2 < n3) {
            return null;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n = 0; n < n3; ++n) {
            char c2;
            c = string2.charAt(n);
            if (n4 >= n2) {
                return null;
            }
            char c3 = string.charAt(n4++);
            while (c3 == '>' || c3 == '<') {
                if (c3 == '>') {
                    ++n5;
                    n6 = 0;
                }
                if (c3 == '<') {
                    ++n6;
                    n5 = 0;
                }
                if (n4 >= n2) break;
                c3 = string.charAt(n4++);
            }
            if (c3 == '\\') {
                if (n4 >= n2) {
                    return null;
                }
                if ((c2 = string.charAt(n4++)) != c) {
                    return null;
                }
                stringBuilder.append(c);
                continue;
            }
            c2 = '\u0000';
            boolean bl = n == 0;
            switch (c3) {
                case '0': {
                    c2 = (char)(Character.isDigit(c) ? 1 : 0);
                    break;
                }
                case '9': {
                    c2 = Character.isDigit(c) || Character.isSpaceChar(c) || !bl && c == '_' ? (char)'\u0001' : '\u0000';
                    break;
                }
                case '#': {
                    c2 = Character.isDigit(c) || Character.isSpaceChar(c) || c == '+' || c == '-' || !bl && c == '_' ? (char)'\u0001' : '\u0000';
                    break;
                }
                case 'L': {
                    if (!Character.isLetter(c)) break;
                    c2 = '\u0001';
                    if (n5 > 0) {
                        c = Character.toUpperCase(c);
                    }
                    if (n6 <= 0) break;
                    c = Character.toLowerCase(c);
                    break;
                }
                case '?': {
                    if (Character.isLetter(c)) {
                        c2 = '\u0001';
                        if (n5 > 0) {
                            c = Character.toUpperCase(c);
                        }
                        if (n6 > 0) {
                            c = Character.toLowerCase(c);
                        }
                    }
                    c2 = c2 != '\u0000' || !bl && c == '_' ? (char)'\u0001' : '\u0000';
                    break;
                }
                case 'A': {
                    if (Character.isLetter(c)) {
                        c2 = '\u0001';
                        if (n5 > 0) {
                            c = Character.toUpperCase(c);
                        }
                        if (n6 > 0) {
                            c = Character.toLowerCase(c);
                        }
                    }
                    c2 = c2 != '\u0000' || Character.isDigit(c) ? (char)'\u0001' : '\u0000';
                    break;
                }
                case 'a': {
                    if (Character.isLetter(c)) {
                        c2 = '\u0001';
                        if (n5 > 0) {
                            c = Character.toUpperCase(c);
                        }
                        if (n6 > 0) {
                            c = Character.toLowerCase(c);
                        }
                    }
                    c2 = c2 != '\u0000' || Character.isDigit(c) || !bl && c == '_' ? (char)'\u0001' : '\u0000';
                    break;
                }
                case '&': {
                    c2 = Character.isDefined(c) || Character.isSpaceChar(c) ? (char)'\u0001' : '\u0000';
                    break;
                }
                case 'C': {
                    c2 = Character.isDefined(c) || Character.isSpaceChar(c) || !bl && c == '_' ? (char)'\u0001' : '\u0000';
                    break;
                }
                default: {
                    char c4 = c2 = c == c3 ? (char)'\u0001' : '\u0000';
                }
            }
            if (c2 == '\u0000') {
                return null;
            }
            stringBuilder.append(c);
        }
        for (n = n4; n < n2; ++n) {
            c = string.charAt(n);
            if (c != '0' && c != 'L' && c != 'A' && c != '&' && (c != '\\' || n + 1 >= n2)) continue;
            return null;
        }
        return stringBuilder.toString();
    }
}

