/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;

public class OracleSerialBlob
implements Blob,
Serializable,
Cloneable {
    private byte[] buffer;
    private long length;
    private boolean isFreed = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleSerialBlob(byte[] bytes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bytes));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.length = bytes.length;
            this.buffer = new byte[(int)this.length];
            int i2 = 0;
            while ((long)i2 < this.length) {
                this.buffer[i2] = bytes[i2];
                ++i2;
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSerialBlob.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OracleSerialBlob(Blob blob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(blob));
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.length = blob.length();
            this.buffer = new byte[(int)this.length];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(blob.getBinaryStream());
            try {
                try {
                    int bytesRead = 0;
                    int offset = 0;
                    do {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            Object var6_10;
                            try {
                                OracleSerialBlob.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleSerialBlob.OracleSerialBlob(Blob)" + ", inside do-while loop, bytesRead=" + bytesRead + ", offset=" + offset);
                                var6_10 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                var6_10 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        bytesRead = bufferedInputStream.read(this.buffer, offset, (int)(this.length - (long)offset));
                        offset += bytesRead;
                    } while (bytesRead > 0);
                }
                catch (IOException ioexception) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSerialBlob.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 346 + ioexception.getMessage());
                            Object var8_24 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var8_25 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 346, ioexception.getMessage());
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                Object var10_12 = null;
                try {
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                catch (IOException ioexception) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleSerialBlob.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 346 + ioexception.getMessage());
                            Object var13_16 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var13_17 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 346, ioexception.getMessage());
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {}
                catch (IOException ioexception) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {}
                        catch (Throwable throwable2) {
                            Object var13_19 = null;
                            OracleLog.recursiveExit();
                            throw throwable2;
                        }
                        OracleSerialBlob.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 346 + ioexception.getMessage());
                        Object var13_18 = null;
                        OracleLog.recursiveExit();
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 346, ioexception.getMessage());
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (bufferedInputStream == null) throw throwable;
                bufferedInputStream.close();
                throw throwable;
            }
            Object var15_28 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var15_29 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable3) {
                Object var17_33 = null;
                OracleLog.recursiveExit();
                throw throwable3;
            }
            OracleSerialBlob.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var17_32 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleSerialBlob.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var17_30 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var17_31 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getBinaryStream() throws SQLException {
        ByteArrayInputStream byteArrayInputStream;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    byteArrayInputStream = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.isFreed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSerialBlob.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            ByteArrayInputStream __result__ = new ByteArrayInputStream(this.buffer);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            byteArrayInputStream = __result__;
            Object var8_12 = null;
            if (!TRACE) return byteArrayInputStream;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleSerialBlob.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return byteArrayInputStream;
        try {
            OracleSerialBlob.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_14 = null;
            OracleLog.recursiveExit();
            return byteArrayInputStream;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(long pos, int len) throws SQLException {
        byte[] byArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pos) + ", " + OracleLog.argument(len));
                    byArray = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleSerialBlob.getBytes(" + pos + ", " + len + "), length=" + this.length);
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.isFreed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSerialBlob.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                        Object var9_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            byte[] b2 = null;
            if (--pos < 0L || (long)len > this.length || pos + (long)len > this.length) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSerialBlob.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        Object var11_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            b2 = new byte[len];
            System.arraycopy(this.buffer, (int)pos, b2, 0, len);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + b2);
                    Object var13_17 = null;
                }
                catch (Throwable throwable) {
                    Object var13_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byArray = b2;
            Object var15_20 = null;
        }
        catch (Throwable throwable) {
            Object var15_21 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var17_24 = null;
                }
                catch (Throwable throwable2) {
                    Object var17_25 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSerialBlob.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var17_22 = null;
            }
            catch (Throwable throwable) {
                Object var17_23 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.isFreed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSerialBlob.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                        Object var4_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.length);
                    Object var6_9 = null;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = this.length;
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSerialBlob.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long position(byte[] ac, long l) throws SQLException {
        block33: {
            if (OracleSerialBlob.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(ac) + ", " + OracleLog.argument(l));
                    var5_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable var4_6) {
                    var5_4 = null;
                    OracleLog.recursiveExit();
                    throw var4_6;
                }
            }
            if (OracleSerialBlob.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleSerialBlob.position(ac, l): length=" + this.length);
                    var7_11 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable var6_13) {
                    var7_12 = null;
                    OracleLog.recursiveExit();
                    throw var6_13;
                }
            }
            if (this.isFreed) {
                if (OracleSerialBlob.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSerialBlob.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                        var9_15 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable var8_18) {
                        var9_16 = null;
                        OracleLog.recursiveExit();
                        throw var8_18;
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (l < 1L) {
                if (OracleSerialBlob.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSerialBlob.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "position()");
                        var11_21 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable var10_24) {
                        var11_22 = null;
                        OracleLog.recursiveExit();
                        throw var10_24;
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (l > this.length || l + (long)ac.length - 1L > this.length) {
                if (OracleSerialBlob.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSerialBlob.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -1L);
                        var13_25 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable var12_27) {
                        var13_26 = null;
                        OracleLog.recursiveExit();
                        throw var12_27;
                    }
                }
                __ex__ = -1L;
                var19_29 = null;
                if (OracleSerialBlob.TRACE == false) return __ex__;
                if (OracleLog.recursiveEnter() == false) return __ex__;
                OracleSerialBlob.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var21_33 = null;
                OracleLog.recursiveExit();
                return __ex__;
            }
            i = (int)(l - 1L);
            flag = false;
            l2 = ac.length;
            break block33;
            catch (Throwable var20_41) {
                var21_34 = null;
                OracleLog.recursiveExit();
                throw var20_41;
            }
        }
        while ((long)i < this.length) {
            j = 0;
            l1 = i + 1;
            k = i;
            while ((long)j < l2 && (long)k < this.length && ac[j] == this.buffer[k]) {
                ++k;
                if ((long)(++j) != l2) continue;
                if (OracleSerialBlob.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSerialBlob.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + l1);
                        var15_45 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable var14_47) {
                        var15_46 = null;
                        OracleLog.recursiveExit();
                        throw var14_47;
                    }
                }
                var12_28 = l1;
                var19_30 = null;
                if (OracleSerialBlob.TRACE == false) return var12_28;
                if (OracleLog.recursiveEnter() == false) return var12_28;
                ** try [egrp 8[TRYBLOCK] [18 : 830->885)] { 
lbl119:
                // 1 sources

                OracleSerialBlob.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var21_35 = null;
                OracleLog.recursiveExit();
                return var12_28;
            }
            ++i;
        }
        if (OracleSerialBlob.TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSerialBlob.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -1L);
                var17_48 = null;
                OracleLog.recursiveExit();
            }
            catch (Throwable var16_50) {
                var17_49 = null;
                OracleLog.recursiveExit();
                throw var16_50;
            }
        }
        var8_20 = -1L;
        var19_31 = null;
        if (OracleSerialBlob.TRACE == false) return var8_20;
        if (OracleLog.recursiveEnter() == false) return var8_20;
        ** try [egrp 8[TRYBLOCK] [18 : 830->885)] { 
lbl-1000:
        // 1 sources

        {
            catch (Throwable var20_43) {
                var21_38 = null;
                OracleLog.recursiveExit();
                throw var20_43;
            }
        }
lbl149:
        // 1 sources

        OracleSerialBlob.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        var21_37 = null;
        OracleLog.recursiveExit();
        return var8_20;
        catch (Throwable var18_51) {
            var19_32 = null;
            if (OracleSerialBlob.TRACE == false) throw var18_51;
            if (OracleLog.recursiveEnter() == false) throw var18_51;
            try {}
            catch (Throwable var20_44) {
                var21_40 = null;
                OracleLog.recursiveExit();
                throw var20_44;
            }
            OracleSerialBlob.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var21_39 = null;
            OracleLog.recursiveExit();
            throw var18_51;
lbl170:
            // 1 sources

            catch (Throwable var20_42) {
                var21_36 = null;
                OracleLog.recursiveExit();
                throw var20_42;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(Blob blob, long l2) throws SQLException {
        long l3;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(l2));
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.isFreed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSerialBlob.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                        Object var7_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            long __result__ = this.position(blob.getBytes(1L, (int)blob.length()), l2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var9_12 = null;
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l3 = __result__;
            Object var11_15 = null;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSerialBlob.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var13_17 = null;
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pos) + ", " + OracleLog.argument(bytes));
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.isFreed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSerialBlob.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                        Object var7_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                    Object var9_11 = null;
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleSerialBlob.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var13_16 = null;
            }
            catch (Throwable throwable2) {
                Object var13_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pos) + ", " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(len));
                    Object var7_5 = null;
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.isFreed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSerialBlob.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                        Object var9_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                    Object var11_13 = null;
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var15_18 = null;
                }
                catch (Throwable throwable2) {
                    Object var15_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream setBinaryStream(long pos) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(pos));
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.isFreed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSerialBlob.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                    Object var8_10 = null;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(long len) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(len));
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.isFreed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSerialBlob.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 192);
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                    Object var8_10 = null;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        OracleConnection oracleConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleConnection = null;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSerialBlob.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSerialBlob.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleConnection;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.rowset");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.rowset.OracleSerialBlob"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

