/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;

public final class UnpickleContext {
    byte[] image;
    int absoluteOffset;
    int beginOffset;
    int markedOffset;
    Vector patches;
    long[] ldsOffsets;
    boolean[] nullIndicators;
    boolean bigEndian;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public UnpickleContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnpickleContext(byte[] image, int begin_offset, boolean[] null_bytes, long[] lds_offset_array, boolean big_endian) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(image) + ", " + OracleLog.argument(begin_offset) + ", " + OracleLog.argument(null_bytes) + ", " + OracleLog.argument(lds_offset_array) + ", " + OracleLog.argument(big_endian));
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.image = image;
            this.beginOffset = begin_offset;
            this.absoluteOffset = begin_offset;
            this.bigEndian = big_endian;
            this.nullIndicators = null_bytes;
            this.patches = null;
            this.ldsOffsets = lds_offset_array;
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UnpickleContext.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte readByte() throws SQLException {
        try {
            byte by;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            try {
                byte __result__ = this.image[this.absoluteOffset];
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                by = __result__;
                Object var6_9 = null;
                ++this.absoluteOffset;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                ++this.absoluteOffset;
                throw throwable;
            }
            Object var8_11 = null;
            if (!TRACE) return by;
            if (!OracleLog.recursiveEnter()) return by;
            try {
                UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_13 = null;
                OracleLog.recursiveExit();
                return by;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
        }
        catch (Throwable throwable2) {
            Object var8_12 = null;
            if (!TRACE) throw throwable2;
            if (!OracleLog.recursiveEnter()) throw throwable2;
            try {}
            catch (Throwable throwable3) {
                Object var10_16 = null;
                OracleLog.recursiveExit();
                throw throwable3;
            }
            UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_15 = null;
            OracleLog.recursiveExit();
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readVarNumBytes() throws SQLException {
        byte[] byArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    byArray = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] varNumBytes = new byte[this.image[this.absoluteOffset] & 0xFF];
            try {
                System.arraycopy(this.image, this.absoluteOffset + 1, varNumBytes, 0, varNumBytes.length);
                Object var4_5 = null;
                this.absoluteOffset += 22;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.absoluteOffset += 22;
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + varNumBytes);
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byArray = varNumBytes;
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readPtrBytes() throws SQLException {
        byte[] byArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    byArray = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] bytes = new byte[(this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF) + 2];
            System.arraycopy(this.image, this.absoluteOffset, bytes, 0, bytes.length);
            this.absoluteOffset += bytes.length;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bytes);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byArray = bytes;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void skipPtrBytes() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.absoluteOffset += (this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF) + 2;
            Object var4_4 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_8 = null;
            }
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] readBytes(int n2) throws SQLException {
        try {
            byte[] byArray;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(n2));
                    byArray = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            try {
                byte[] bytes = new byte[n2];
                System.arraycopy(this.image, this.absoluteOffset, bytes, 0, n2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bytes);
                        Object var5_6 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                byArray = bytes;
                Object var7_9 = null;
                this.absoluteOffset += n2;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.absoluteOffset += n2;
                throw throwable;
            }
            Object var9_11 = null;
            if (!TRACE) return byArray;
            if (!OracleLog.recursiveEnter()) return byArray;
            try {
                UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_13 = null;
                OracleLog.recursiveExit();
                return byArray;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
        }
        catch (Throwable throwable2) {
            Object var9_12 = null;
            if (!TRACE) throw throwable2;
            if (!OracleLog.recursiveEnter()) throw throwable2;
            try {}
            catch (Throwable throwable3) {
                Object var11_16 = null;
                OracleLog.recursiveExit();
                throw throwable3;
            }
            UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_15 = null;
            OracleLog.recursiveExit();
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public long readLong() throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        long __result__ = (((this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF)) * 256 + (this.image[this.absoluteOffset + 2] & 0xFF)) * 256 + (this.image[this.absoluteOffset + 3] & 0xFF);
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        long l2 = __result__;
        {
            Object var6_9 = null;
            this.absoluteOffset += 4;
        }
        Object var8_11 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l2;
        {
            catch (Throwable throwable) {
                try {
                    Object var6_10 = null;
                    this.absoluteOffset += 4;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    Object var8_12 = null;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var10_15 = null;
                        }
                        catch (Throwable throwable3) {
                            Object var10_16 = null;
                            OracleLog.recursiveExit();
                            throw throwable3;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short readShort() throws SQLException {
        try {
            short s2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            try {
                short __result__ = (short)((this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF));
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                s2 = __result__;
                Object var6_9 = null;
                this.absoluteOffset += 2;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                this.absoluteOffset += 2;
                throw throwable;
            }
            Object var8_11 = null;
            if (!TRACE) return s2;
            if (!OracleLog.recursiveEnter()) return s2;
            try {
                UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_13 = null;
                OracleLog.recursiveExit();
                return s2;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
        }
        catch (Throwable throwable2) {
            Object var8_12 = null;
            if (!TRACE) throw throwable2;
            if (!OracleLog.recursiveEnter()) throw throwable2;
            try {}
            catch (Throwable throwable3) {
                Object var10_16 = null;
                OracleLog.recursiveExit();
                throw throwable3;
            }
            UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_15 = null;
            OracleLog.recursiveExit();
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readLengthBytes() throws SQLException {
        byte[] byArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            long variable_length = this.readLong();
            byte[] __result__ = this.readBytes((int)variable_length);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byArray = __result__;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void skipLengthBytes() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            long variable_length = this.readLong();
            this.absoluteOffset = (int)((long)this.absoluteOffset + variable_length);
            Object var4_5 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_9 = null;
            }
            catch (Throwable throwable2) {
                Object var6_10 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipTo(long offset) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(offset));
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (offset > (long)(this.absoluteOffset - this.beginOffset)) {
                this.absoluteOffset = this.beginOffset + (int)offset;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipTo(int offset) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(offset));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (offset > this.absoluteOffset - this.beginOffset) {
                this.absoluteOffset = this.beginOffset + offset;
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.markedOffset = this.absoluteOffset;
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void reset() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.absoluteOffset = this.markedOffset;
            Object var4_4 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void markAndSkip() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.markedOffset = this.absoluteOffset + 4;
            this.absoluteOffset = this.beginOffset + (int)this.readLong();
            Object var4_4 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_8 = null;
            }
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAndSkip(long offset) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(offset));
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.markedOffset = this.absoluteOffset;
            this.absoluteOffset = this.beginOffset + (int)offset;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipBytes(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(n2));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (n2 >= 0) {
                this.absoluteOffset += n2;
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean isNull(int idx) {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(idx));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean __result__ = this.nullIndicators[idx];
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int absoluteOffset() throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.absoluteOffset);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = this.absoluteOffset;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int offset() throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int __result__ = this.absoluteOffset - this.beginOffset;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] image() throws SQLException {
        byte[] byArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.image);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byArray = this.image;
            Object var6_8 = null;
            if (!TRACE) return byArray;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_12 = null;
            }
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return byArray;
        try {
            UnpickleContext.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return byArray;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.UnpickleContext"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

