/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClassRef;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CKvaldfList;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.util.RepConversion;
import oracle.net.ano.AuthenticationService;
import oracle.net.nt.TcpsNTAdapter;
import oracle.security.o3logon.O3LoginClientHelper;
import oracle.security.o5logon.O5Logon;
import oracle.sql.ZONEIDMAP;
import oracle.sql.converter.CharacterSetMetaData;

final class T4CTTIoauthenticate
extends T4CTTIfun {
    byte[] terminal;
    byte[] enableTempLobRefCnt;
    byte[] machine;
    byte[] sysUserName;
    byte[] processID;
    byte[] programName;
    byte[] encryptedSK;
    byte[] internalName;
    byte[] externalName;
    byte[] alterSession;
    byte[] aclValue;
    byte[] clientname;
    byte[] editionName = null;
    byte[] driverName;
    String ressourceManagerId;
    boolean bUseO5Logon;
    int verifierType;
    static final int ZTVT_ORCL_7 = 2361;
    static final int ZTVT_SSH1 = 6949;
    static final int ZTVT_NTV = 7809;
    static final int ZTVT_SMD5 = 59694;
    static final int ZTVT_MD5 = 40674;
    static final int ZTVT_SH1 = 45394;
    byte[] salt;
    byte[] encryptedKB;
    boolean isSessionTZ = true;
    static final int SERVER_VERSION_81 = 8100;
    static final int KPZ_LOGON = 1;
    static final int KPZ_CPW = 2;
    static final int KPZ_SRVAUTH = 4;
    static final int KPZ_ENCRYPTED_PASSWD = 256;
    static final int KPZ_LOGON_MIGRATE = 16;
    static final int KPZ_LOGON_SYSDBA = 32;
    static final int KPZ_LOGON_SYSOPER = 64;
    static final int KPZ_LOGON_PRELIMAUTH = 128;
    static final int KPZ_PASSWD_ENCRYPTED = 256;
    static final int KPZ_LOGON_DBCONC = 512;
    static final int KPZ_PROXY_AUTH = 1024;
    static final int KPZ_SESSION_CACHE = 2048;
    static final int KPZ_PASSWD_IS_VFR = 4096;
    static final int KPZ_LOGON_SYSASM = 0x400000;
    static final int KPZ_SESSION_QCACHE = 0x800000;
    static final int KPZ_LOGON_SYSBKP = 0x1000000;
    static final int KPZ_LOGON_SYSDGD = 0x2000000;
    static final int KPZ_LOGON_SYSKMT = 0x4000000;
    static final String AUTH_TERMINAL = "AUTH_TERMINAL";
    static final String AUTH_PROGRAM_NM = "AUTH_PROGRAM_NM";
    static final String AUTH_MACHINE = "AUTH_MACHINE";
    static final String AUTH_PID = "AUTH_PID";
    static final String AUTH_SID = "AUTH_SID";
    static final String AUTH_SESSKEY = "AUTH_SESSKEY";
    static final String AUTH_VFR_DATA = "AUTH_VFR_DATA";
    static final String AUTH_PASSWORD = "AUTH_PASSWORD";
    static final String AUTH_INTERNALNAME = "AUTH_INTERNALNAME_";
    static final String AUTH_EXTERNALNAME = "AUTH_EXTERNALNAME_";
    static final String AUTH_ACL = "AUTH_ACL";
    static final String AUTH_ALTER_SESSION = "AUTH_ALTER_SESSION";
    static final String AUTH_INITIAL_CLIENT_ROLE = "INITIAL_CLIENT_ROLE";
    static final String AUTH_VERSION_SQL = "AUTH_VERSION_SQL";
    static final String AUTH_VERSION_NO = "AUTH_VERSION_NO";
    static final String AUTH_XACTION_TRAITS = "AUTH_XACTION_TRAITS";
    static final String AUTH_VERSION_STATUS = "AUTH_VERSION_STATUS";
    static final String AUTH_SERIAL_NUM = "AUTH_SERIAL_NUM";
    static final String AUTH_SESSION_ID = "AUTH_SESSION_ID";
    static final String AUTH_CLIENT_CERTIFICATE = "AUTH_CLIENT_CERTIFICATE";
    static final String AUTH_PROXY_CLIENT_NAME = "PROXY_CLIENT_NAME";
    static final String AUTH_CLIENT_DN = "AUTH_CLIENT_DISTINGUISHED_NAME";
    static final String AUTH_INSTANCENAME = "AUTH_INSTANCENAME";
    static final String AUTH_DBNAME = "AUTH_DBNAME";
    static final String AUTH_INSTANCE_NO = "AUTH_INSTANCE_NO";
    static final String AUTH_SC_SERVER_HOST = "AUTH_SC_SERVER_HOST";
    static final String AUTH_SC_INSTANCE_NAME = "AUTH_SC_INSTANCE_NAME";
    static final String AUTH_SC_INSTANCE_ID = "AUTH_SC_INSTANCE_ID";
    static final String AUTH_SC_INSTANCE_START_TIME = "AUTH_SC_INSTANCE_START_TIME";
    static final String AUTH_SC_DBUNIQUE_NAME = "AUTH_SC_DBUNIQUE_NAME";
    static final String AUTH_SC_SERVICE_NAME = "AUTH_SC_SERVICE_NAME";
    static final String AUTH_SC_SVC_FLAGS = "AUTH_SC_SVC_FLAGS";
    static final String AUTH_SESSION_CLIENT_CSET = "SESSION_CLIENT_CHARSET";
    static final String AUTH_SESSION_CLIENT_LTYPE = "SESSION_CLIENT_LIB_TYPE";
    static final String AUTH_SESSION_CLIENT_DRVNM = "SESSION_CLIENT_DRIVER_NAME";
    static final String AUTH_SESSION_CLIENT_VSN = "SESSION_CLIENT_VERSION";
    static final String AUTH_NLS_LXLAN = "AUTH_NLS_LXLAN";
    static final String AUTH_NLS_LXCTERRITORY = "AUTH_NLS_LXCTERRITORY";
    static final String AUTH_NLS_LXCCURRENCY = "AUTH_NLS_LXCCURRENCY";
    static final String AUTH_NLS_LXCISOCURR = "AUTH_NLS_LXCISOCURR";
    static final String AUTH_NLS_LXCNUMERICS = "AUTH_NLS_LXCNUMERICS";
    static final String AUTH_NLS_LXCDATEFM = "AUTH_NLS_LXCDATEFM";
    static final String AUTH_NLS_LXCDATELANG = "AUTH_NLS_LXCDATELANG";
    static final String AUTH_NLS_LXCSORT = "AUTH_NLS_LXCSORT";
    static final String AUTH_NLS_LXCCALENDAR = "AUTH_NLS_LXCCALENDAR";
    static final String AUTH_NLS_LXCUNIONCUR = "AUTH_NLS_LXCUNIONCUR";
    static final String AUTH_NLS_LXCTIMEFM = "AUTH_NLS_LXCTIMEFM";
    static final String AUTH_NLS_LXCSTMPFM = "AUTH_NLS_LXCSTMPFM";
    static final String AUTH_NLS_LXCTTZNFM = "AUTH_NLS_LXCTTZNFM";
    static final String AUTH_NLS_LXCSTZNFM = "AUTH_NLS_LXCSTZNFM";
    static final String SESSION_CLIENT_LOBATTR = "SESSION_CLIENT_LOBATTR";
    static final String DRIVER_NAME_DEFAULT = "jdbcthin";
    static final int KPU_LIB_UNKN = 0;
    static final int KPU_LIB_DEF = 1;
    static final int KPU_LIB_EI = 2;
    static final int KPU_LIB_XE = 3;
    static final int KPU_LIB_ICUS = 4;
    static final int KPU_LIB_OCI = 5;
    static final int KPU_LIB_THIN = 10;
    static final String AUTH_ORA_EDITION = "AUTH_ORA_EDITION";
    static final String AUTH_COPYRIGHT = "AUTH_COPYRIGHT";
    static final String COPYRIGHT_STR = "\"Oracle\nEverybody follows\nSpeedy bits exchange\nStars await to glow\"\nThe preceding key is copyrighted by Oracle Corporation.\nDuplication of this key is not allowed without permission\nfrom Oracle Corporation. Copyright 2003 Oracle Corporation.";
    static final String SESSION_TIME_ZONE = "SESSION_TIME_ZONE";
    static final String SESSION_NLS_LXCCHARSET = "SESSION_NLS_LXCCHARSET";
    static final String SESSION_NLS_LXCNLSLENSEM = "SESSION_NLS_LXCNLSLENSEM";
    static final String SESSION_NLS_LXCNCHAREXCP = "SESSION_NLS_LXCNCHAREXCP";
    static final String SESSION_NLS_LXCNCHARIMP = "SESSION_NLS_LXCNCHARIMP";
    String sessionTimeZone = null;
    byte[] serverCompileTimeCapabilities = null;
    private T4CKvaldfList keyValList = null;
    private byte[] user = null;
    private long logonMode;
    private byte[][] outKeys = null;
    private byte[][] outValues = null;
    private int[] outFlags = new int[0];
    private int outNbPairs = 0;
    O5Logon o5logonHelper = new O5Logon();
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4CTTIoauthenticate(T4CConnection _conn, String _ressourceManagerId, byte[] serverCompileTimeCapabilities) throws SQLException {
        super(_conn, (byte)3);
        this.ressourceManagerId = _ressourceManagerId;
        this.serverCompileTimeCapabilities = serverCompileTimeCapabilities;
        this.setSessionFields(_conn);
        this.isSessionTZ = true;
        this.bUseO5Logon = false;
    }

    void marshal() throws IOException {
        if (this.user != null && this.user.length > 0) {
            this.meg.marshalPTR();
            this.meg.marshalSB4(this.user.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSB4(0);
        }
        this.meg.marshalUB4(this.logonMode);
        this.meg.marshalPTR();
        this.meg.marshalUB4(this.keyValList.size());
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        if (this.user != null && this.user.length > 0) {
            this.meg.marshalCHR(this.user);
        }
        this.meg.marshalKEYVAL(this.keyValList.getKeys(), this.keyValList.getValues(), this.keyValList.getFlags(), this.keyValList.size());
    }

    private void doOAUTH(byte[] luser, byte[] lpassword, long llogonMode, String authenticationAdaptor, boolean proxyAuthentication, byte[] proxyDN, byte[] proxyCertificate, byte[][] proxyRoles, int gl_session_id, int gl_serial_nb) throws IOException, SQLException {
        this.setFunCode((short)115);
        this.user = luser;
        this.logonMode = llogonMode | 1L;
        if (proxyAuthentication) {
            this.logonMode |= 0x400L;
        }
        if (luser != null && luser.length != 0 && lpassword != null && authenticationAdaptor != "RADIUS") {
            this.logonMode |= 0x100L;
        }
        this.keyValList = new T4CKvaldfList(this.meg.conv);
        if (lpassword != null) {
            this.keyValList.add(AUTH_PASSWORD, lpassword);
        }
        if (proxyRoles != null) {
            for (int i2 = 0; i2 < proxyRoles.length; ++i2) {
                this.keyValList.add(AUTH_INITIAL_CLIENT_ROLE, proxyRoles[i2]);
            }
        }
        if (proxyDN != null) {
            this.keyValList.add(AUTH_CLIENT_DN, proxyDN);
        }
        if (proxyCertificate != null) {
            this.keyValList.add(AUTH_CLIENT_CERTIFICATE, proxyCertificate);
        }
        this.keyValList.add(AUTH_TERMINAL, this.terminal);
        if (this.bUseO5Logon && this.encryptedKB != null) {
            this.keyValList.add(AUTH_SESSKEY, this.encryptedKB, (byte)1);
        }
        if (this.programName != null) {
            this.keyValList.add(AUTH_PROGRAM_NM, this.programName);
        }
        if (this.clientname != null) {
            this.keyValList.add(AUTH_PROXY_CLIENT_NAME, this.clientname);
        }
        this.keyValList.add(AUTH_MACHINE, this.machine);
        this.keyValList.add(AUTH_PID, this.processID);
        if (!this.ressourceManagerId.equals("0000")) {
            byte[] key = this.meg.conv.StringToCharBytes(AUTH_INTERNALNAME);
            key[key.length - 1] = 0;
            this.keyValList.add(key, this.internalName);
            key = this.meg.conv.StringToCharBytes(AUTH_EXTERNALNAME);
            key[key.length - 1] = 0;
            this.keyValList.add(key, this.externalName);
        }
        this.keyValList.add(AUTH_ACL, this.aclValue);
        this.keyValList.add(AUTH_ALTER_SESSION, this.alterSession, (byte)1);
        if (this.editionName != null) {
            this.keyValList.add(AUTH_ORA_EDITION, this.editionName);
        }
        this.keyValList.add(SESSION_CLIENT_LOBATTR, this.enableTempLobRefCnt);
        this.keyValList.add(AUTH_SESSION_CLIENT_DRVNM, this.driverName);
        this.keyValList.add(AUTH_SESSION_CLIENT_VSN, this.meg.conv.StringToCharBytes(Integer.toString(this.versionStringToInt(this.connection.getMetaData().getDriverVersion()), 10)));
        if (gl_session_id != -1) {
            this.keyValList.add(AUTH_SESSION_ID, this.meg.conv.StringToCharBytes(Integer.toString(gl_session_id)));
        }
        if (gl_serial_nb != -1) {
            this.keyValList.add(AUTH_SERIAL_NUM, this.meg.conv.StringToCharBytes(Integer.toString(gl_serial_nb)));
        }
        this.keyValList.add(AUTH_COPYRIGHT, this.meg.conv.StringToCharBytes(COPYRIGHT_STR));
        this.outNbPairs = 0;
        this.outKeys = null;
        this.outValues = null;
        this.outFlags = new int[0];
        this.doRPC();
    }

    void doOSESSKEY(String userName, long llogonMode) throws IOException, SQLException {
        this.setFunCode((short)118);
        this.user = this.meg.conv.StringToCharBytes(userName);
        this.logonMode = llogonMode | 1L;
        this.keyValList = new T4CKvaldfList(this.meg.conv);
        this.keyValList.add(AUTH_TERMINAL, this.terminal);
        if (this.programName != null) {
            this.keyValList.add(AUTH_PROGRAM_NM, this.programName);
        }
        this.keyValList.add(AUTH_MACHINE, this.machine);
        this.keyValList.add(AUTH_PID, this.processID);
        this.keyValList.add(AUTH_SID, this.sysUserName);
        this.outNbPairs = 0;
        this.outKeys = null;
        this.outValues = null;
        this.outFlags = new int[0];
        this.doRPC();
    }

    void readRPA() throws IOException, SQLException {
        this.outNbPairs = this.meg.unmarshalUB2();
        this.outKeys = new byte[this.outNbPairs][];
        this.outValues = new byte[this.outNbPairs][];
        this.outFlags = this.meg.unmarshalKEYVAL(this.outKeys, this.outValues, this.outNbPairs);
    }

    void processError() throws SQLException {
        if (this.getFunCode() == 118) {
            if (this.oer.getRetCode() != 28035 || this.connection.net.getAuthenticationAdaptorName() != "RADIUS") {
                this.oer.processError();
            }
        } else {
            super.processError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRPA() throws SQLException {
        if (this.getFunCode() == 115) {
            Properties connectionValues = new Properties();
            for (int i2 = 0; i2 < this.outNbPairs; ++i2) {
                String keyStr = this.meg.conv.CharBytesToString(this.outKeys[i2], this.outKeys[i2].length).trim();
                String valueStr = "";
                if (this.outValues[i2] != null) {
                    valueStr = this.meg.conv.CharBytesToString(this.outValues[i2], this.outValues[i2].length).trim();
                }
                connectionValues.setProperty(keyStr, valueStr);
            }
            String versionNoStr = connectionValues.getProperty(AUTH_VERSION_NO);
            if (versionNoStr != null) {
                try {
                    int serverVersionInt = new Integer(versionNoStr);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            connectionValues.setProperty("SERVER_HOST", connectionValues.getProperty(AUTH_SC_SERVER_HOST, ""));
            connectionValues.setProperty("INSTANCE_NAME", connectionValues.getProperty(AUTH_SC_INSTANCE_NAME, ""));
            connectionValues.setProperty("DATABASE_NAME", connectionValues.getProperty(AUTH_SC_DBUNIQUE_NAME, ""));
            connectionValues.setProperty("SERVICE_NAME", connectionValues.getProperty(AUTH_SC_SERVICE_NAME, ""));
            connectionValues.setProperty(SESSION_TIME_ZONE, this.sessionTimeZone);
            this.connection.sessionProperties = connectionValues;
        } else if (this.getFunCode() == 118 && this.connection.net.getAuthenticationAdaptorName() != "RADIUS") {
            if (this.outKeys == null || this.outKeys.length < 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CTTIoauthenticate.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 438);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            int indexOfSessKey = -1;
            int indexOfVfrDat = -1;
            try {
                for (int i3 = 0; i3 < this.outKeys.length; ++i3) {
                    String sKey = new String(this.outKeys[i3], "US-ASCII");
                    if (sKey.equals(AUTH_SESSKEY)) {
                        indexOfSessKey = i3;
                    } else if (sKey.equals(AUTH_VFR_DATA)) {
                        indexOfVfrDat = i3;
                    }
                    if (indexOfVfrDat == -1 || indexOfSessKey == -1) {
                        continue;
                    }
                    break;
                }
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
            if (indexOfSessKey == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CTTIoauthenticate.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 438);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.encryptedSK = this.outValues[indexOfSessKey];
            if (indexOfVfrDat != -1) {
                this.bUseO5Logon = true;
                this.salt = this.outValues[indexOfVfrDat];
                this.verifierType = this.outFlags[indexOfVfrDat];
            }
            if (!(this.bUseO5Logon || this.encryptedSK != null && this.encryptedSK.length == 16)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CTTIoauthenticate.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 438);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doOAUTH(String userStr, String passwordStr, long logonMode) throws IOException, SQLException {
        block49: {
            byte[] user = null;
            if (userStr != null && userStr.length() > 0) {
                user = this.meg.conv.StringToCharBytes(userStr);
            }
            byte[] passwordNet = null;
            byte[] paddedPwd = null;
            byte[] password = null;
            String authenticationAdaptor = this.connection.net.getAuthenticationAdaptorName();
            if (userStr != null && userStr.length() != 0) {
                byte pwdPadLen;
                if (authenticationAdaptor != "RADIUS" && this.encryptedSK.length > 16 && !this.bUseO5Logon) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CTTIoauthenticate.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 413);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 413);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (this.bUseO5Logon && (this.encryptedSK == null || this.encryptedSK.length != 64 && this.encryptedSK.length != 96)) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CTTIoauthenticate.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 413);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 413);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                String trimUser = userStr.trim();
                String trimPwd = null;
                if (passwordStr != null) {
                    trimPwd = passwordStr.trim();
                }
                passwordStr = null;
                String noQuotesUser = trimUser;
                String noQuotesPwd = trimPwd;
                if (trimUser.startsWith("\"") || trimUser.endsWith("\"")) {
                    noQuotesUser = this.removeQuotes(trimUser);
                }
                if (trimPwd != null && (trimPwd.startsWith("\"") || trimPwd.endsWith("\""))) {
                    noQuotesPwd = this.removeQuotes(trimPwd);
                }
                if (noQuotesPwd != null) {
                    passwordNet = this.meg.conv.StringToCharBytes(noQuotesPwd);
                }
                if (authenticationAdaptor != "RADIUS") {
                    if (passwordNet == null) {
                        password = null;
                    } else if (this.bUseO5Logon) {
                        this.encryptedKB = new byte[this.encryptedSK.length];
                        for (int k2 = 0; k2 < this.encryptedKB.length; ++k2) {
                            this.encryptedKB[k2] = 1;
                        }
                        int[] encryptedPasswordLength = new int[1];
                        byte[] o5logonpassword = new byte[256];
                        for (int k3 = 0; k3 < 256; ++k3) {
                            o5logonpassword[k3] = 0;
                        }
                        try {
                            this.o5logonHelper.generateOAuthResponse(this.verifierType, this.salt, noQuotesUser, noQuotesPwd, passwordNet, this.encryptedSK, this.encryptedKB, o5logonpassword, encryptedPasswordLength, this.meg.conv.isServerCSMultiByte, this.serverCompileTimeCapabilities[4]);
                        }
                        catch (Exception excc) {
                            // empty catch block
                        }
                        password = new byte[encryptedPasswordLength[0]];
                        System.arraycopy(o5logonpassword, 0, password, 0, encryptedPasswordLength[0]);
                    } else {
                        O3LoginClientHelper loginHelper = new O3LoginClientHelper(this.meg.conv.isServerCSMultiByte);
                        byte[] sessionKey = loginHelper.getSessionKey(noQuotesUser, noQuotesPwd, this.encryptedSK);
                        pwdPadLen = passwordNet.length % 8 > 0 ? (byte)((byte)(8 - passwordNet.length % 8)) : (byte)0;
                        paddedPwd = new byte[passwordNet.length + pwdPadLen];
                        System.arraycopy(passwordNet, 0, paddedPwd, 0, passwordNet.length);
                        byte[] ePwdOnSessKey = loginHelper.getEPasswd(sessionKey, paddedPwd);
                        password = new byte[2 * paddedPwd.length + 1];
                        if (password.length < 2 * ePwdOnSessKey.length) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T4CTTIoauthenticate.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 413);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 413);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                        RepConversion.bArray2Nibbles(ePwdOnSessKey, password);
                        password[password.length - 1] = RepConversion.nibbleToHex(pwdPadLen);
                    }
                } else if (passwordNet != null) {
                    if (this.connection.net.getSessionAttributes().getNTAdapter() instanceof TcpsNTAdapter) {
                        password = passwordNet;
                    } else {
                        pwdPadLen = (passwordNet.length + 1) % 8 > 0 ? (byte)((byte)(8 - (passwordNet.length + 1) % 8)) : (byte)0;
                        paddedPwd = new byte[passwordNet.length + 1 + pwdPadLen];
                        System.arraycopy(passwordNet, 0, paddedPwd, 0, passwordNet.length);
                        byte[] opwd = AuthenticationService.obfuscatePasswordForRadius(paddedPwd);
                        password = new byte[opwd.length * 2];
                        for (int i2 = 0; i2 < opwd.length; ++i2) {
                            byte b1 = (byte)((opwd[i2] & 0xF0) >> 4);
                            byte b2 = (byte)(opwd[i2] & 0xF);
                            password[i2 * 2] = (byte)(b1 < 10 ? b1 + 48 : b1 - 10 + 97);
                            password[i2 * 2 + 1] = (byte)(b2 < 10 ? b2 + 48 : b2 - 10 + 97);
                        }
                    }
                }
            }
            this.doOAUTH(user, password, logonMode, authenticationAdaptor, false, null, null, null, -1, -1);
            if (authenticationAdaptor != "RADIUS" && this.bUseO5Logon) {
                String b64SvrResponse = this.connection.sessionProperties.getProperty("AUTH_SVR_RESPONSE");
                try {
                    if (this.o5logonHelper.validateServerIdentity(b64SvrResponse)) break block49;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CTTIoauthenticate.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 452);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 452);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                catch (Exception e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CTTIoauthenticate.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 452);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 452);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
        }
    }

    void doOAUTH(int type, Properties prop, int gl_session_id, int gl_serial_nb) throws IOException, SQLException {
        byte[] dn = null;
        byte[] certificate = null;
        String[] strRoles = null;
        Object roles = null;
        byte[] proxyClientUser = null;
        if (type == 1) {
            String _userStr = prop.getProperty("PROXY_USER_NAME");
            String _passwd = prop.getProperty("PROXY_USER_PASSWORD");
            if (_passwd != null) {
                _userStr = _userStr + "/" + _passwd;
            }
            proxyClientUser = this.meg.conv.StringToCharBytes(_userStr);
        } else if (type == 2) {
            String _dnStr = prop.getProperty("PROXY_DISTINGUISHED_NAME");
            dn = this.meg.conv.StringToCharBytes(_dnStr);
        } else {
            try {
                certificate = (byte[])prop.get("PROXY_CERTIFICATE");
                StringBuffer sb = new StringBuffer();
                for (int i2 = 0; i2 < certificate.length; ++i2) {
                    String str = Integer.toHexString(0xFF & certificate[i2]);
                    int length = str.length();
                    if (length == 0) {
                        sb.append("00");
                        continue;
                    }
                    if (length == 1) {
                        sb.append('0');
                        sb.append(str);
                        continue;
                    }
                    sb.append(str);
                }
                certificate = sb.toString().getBytes();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        try {
            strRoles = (String[])prop.get("PROXY_ROLES");
        }
        catch (Exception e3) {
            // empty catch block
        }
        if (strRoles != null) {
            roles = new byte[strRoles.length][];
            for (int i3 = 0; i3 < strRoles.length; ++i3) {
                roles[i3] = this.meg.conv.StringToCharBytes(strRoles[i3]);
            }
        }
        this.doOAUTH(proxyClientUser, null, 0L, null, true, dn, certificate, (byte[][])roles, gl_session_id, gl_serial_nb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSessionFields(T4CConnection conn) throws SQLException {
        String terminalStr = this.connection.thinVsessionTerminal;
        String machineStr = this.connection.thinVsessionMachine;
        String osuserStr = this.connection.thinVsessionOsuser;
        String programStr = this.connection.thinVsessionProgram;
        String processStr = this.connection.thinVsessionProcess;
        String internalNameStr = this.connection.thinVsessionIname;
        String externalNameStr = this.connection.thinVsessionEname;
        String clientNameStr = this.connection.proxyClientName;
        String driverNameStr = this.connection.driverNameAttribute;
        String editionStr = this.connection.editionName;
        try {
            this.enableTempLobRefCnt = this.connection.enableTempLobRefCnt ? new String("1").getBytes("US-ASCII") : new String("0").getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException ioex) {
            // empty catch block
        }
        if (machineStr == null) {
            try {
                machineStr = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e2) {
                machineStr = "jdbcclient";
            }
        }
        if (externalNameStr == null) {
            externalNameStr = "jdbc_" + this.ressourceManagerId;
        }
        if (driverNameStr == null) {
            driverNameStr = DRIVER_NAME_DEFAULT;
        }
        this.terminal = this.meg.conv.StringToCharBytes(terminalStr);
        this.machine = this.meg.conv.StringToCharBytes(machineStr);
        this.sysUserName = this.meg.conv.StringToCharBytes(osuserStr);
        this.programName = this.meg.conv.StringToCharBytes(programStr);
        this.processID = this.meg.conv.StringToCharBytes(processStr);
        this.internalName = this.meg.conv.StringToCharBytes(internalNameStr);
        this.externalName = this.meg.conv.StringToCharBytes(externalNameStr);
        if (clientNameStr != null) {
            this.clientname = this.meg.conv.StringToCharBytes(clientNameStr);
        }
        if (editionStr != null) {
            this.editionName = this.meg.conv.StringToCharBytes(editionStr);
        }
        this.driverName = this.meg.conv.StringToCharBytes(driverNameStr);
        TimeZone tz = TimeZone.getDefault();
        String defaultTimeZone = tz.getID();
        if (!ZONEIDMAP.isValidRegion(defaultTimeZone) || !conn.timezoneAsRegion) {
            int tzOffset = tz.getOffset(System.currentTimeMillis());
            int hr = tzOffset / 3600000;
            int mi = tzOffset / 60000 % 60;
            defaultTimeZone = (hr < 0 ? "" + hr : "+" + hr) + (mi < 10 ? ":0" + mi : ":" + mi);
        }
        this.sessionTimeZone = defaultTimeZone;
        conn.sessionTimeZone = defaultTimeZone;
        String nlslanguage = CharacterSetMetaData.getNLSLanguage(ClassRef.LOCALE.getDefault());
        String nlsterritory = CharacterSetMetaData.getNLSTerritory(ClassRef.LOCALE.getDefault());
        if (nlslanguage == null || nlsterritory == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIoauthenticate.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 176);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 176);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        this.alterSession = this.meg.conv.StringToCharBytes("ALTER SESSION SET " + (this.isSessionTZ ? "TIME_ZONE='" + this.sessionTimeZone + "'" : "") + " NLS_LANGUAGE='" + nlslanguage + "' NLS_TERRITORY='" + nlsterritory + "' ");
        this.aclValue = this.meg.conv.StringToCharBytes("4400");
        this.alterSession[this.alterSession.length - 1] = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String removeQuotes(String str) {
        try {
            int i2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIoauthenticate.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(str));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int first = 0;
            int last = str.length() - 1;
            for (i2 = 0; i2 < str.length(); ++i2) {
                if (str.charAt(i2) == '\"') continue;
                first = i2;
                break;
            }
            for (i2 = str.length() - 1; i2 >= 0; --i2) {
                if (str.charAt(i2) == '\"') continue;
                last = i2;
                break;
            }
            String result = str.substring(first, last + 1);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIoauthenticate.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = result;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIoauthenticate.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private int versionStringToInt(String driverVersion) throws SQLException {
        String[] versionElements = driverVersion.split("\\.");
        int versionNumber = Integer.parseInt(versionElements[0].replaceAll("\\D", ""));
        int releaseNumber = Integer.parseInt(versionElements[1].replaceAll("\\D", ""));
        int updateNumber = Integer.parseInt(versionElements[2].replaceAll("\\D", ""));
        int portingReleaseNumber = Integer.parseInt(versionElements[3].replaceAll("\\D", ""));
        int portingUpdateNumber = Integer.parseInt(versionElements[4].replaceAll("\\D", ""));
        int numericVersion = versionNumber << 24 | releaseNumber << 20 | updateNumber << 12 | portingReleaseNumber << 8 | portingUpdateNumber;
        return numericVersion;
    }

    private String versionIntToString(int versionInt) throws SQLException {
        int versionNumber = (versionInt & 0xFF000000) >> 24 & 0xFF;
        int releaseNumber = (versionInt & 0xF00000) >> 20 & 0xFF;
        int updateNumber = (versionInt & 0xFF000) >> 12 & 0xFF;
        int portingReleaseNumber = (versionInt & 0xF00) >> 8 & 0xFF;
        int portingUpdateNumber = versionInt & 0xFF;
        String version = "" + versionNumber + "." + releaseNumber + "." + updateNumber + "." + portingReleaseNumber + "." + portingUpdateNumber;
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIoauthenticate.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIoauthenticate.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            T4CConnection t4CConnection = this.connection;
            return t4CConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIoauthenticate.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIoauthenticate"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

