/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleStatement;

class ResultSetAccessor
extends Accessor {
    static final int maxLength = 16;
    OracleStatement currentStmt;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSetAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind));
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.init(stmt, 102, 116, form, forBind);
            this.initForDataAccess(external_type, max_len, null);
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ResultSetAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ResultSetAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form));
                    Object var11_10 = null;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.init(stmt, 102, 116, form, false);
            this.initForDescribe(102, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            this.initForDataAccess(0, max_len, null);
            Object var13_13 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                ResultSetAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var15_17 = null;
            }
            catch (Throwable throwable2) {
                Object var15_18 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            ResultSetAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(external_type) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(typeName));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (external_type != 0) {
                this.externalType = external_type;
            }
            this.internalTypeMaxLength = 16;
            if (max_len > 0 && max_len < this.internalTypeMaxLength) {
                this.internalTypeMaxLength = max_len;
            }
            this.byteLength = this.internalTypeMaxLength;
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ResultSetAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSet getCursor(int currentRow) throws SQLException {
        OracleStatement newstmt;
        block19: {
            OracleResultSetImpl oracleResultSetImpl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ResultSetAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                byte[] bytes = this.getBytes(currentRow);
                newstmt = this.statement.connection.RefCursorBytesToStatement(bytes, this.statement);
                if (this.currentStmt == null || this.currentStmt.cursorId != newstmt.cursorId || this.currentStmt.currentResultSet == null) break block19;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ResultSetAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.currentStmt.currentResultSet);
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                oracleResultSetImpl = this.currentStmt.currentResultSet;
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ResultSetAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var11_19 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var11_20 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_15 = null;
                }
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return oracleResultSetImpl;
        }
        newstmt.doDescribe(false);
        newstmt.prepareAccessors();
        newstmt.setPrefetchInternal(this.statement.getFetchSize(), false, false);
        OracleResultSetImpl rset = new OracleResultSetImpl(newstmt.connection, newstmt);
        rset.close_statement_on_close = true;
        newstmt.currentResultSet = rset;
        this.currentStmt = newstmt;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ResultSetAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + rset);
                Object var7_24 = null;
            }
            catch (Throwable throwable) {
                Object var7_25 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        OracleResultSetImpl oracleResultSetImpl = rset;
        Object var9_13 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ResultSetAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_17 = null;
            }
            catch (Throwable throwable) {
                Object var11_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleResultSetImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getObject(int currentRow) throws SQLException {
        ResultSet resultSet;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    resultSet = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            ResultSet __result__ = this.getCursor(currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            resultSet = __result__;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ResultSetAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ResultSetAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return resultSet;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.ResultSetAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

